/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.snmp;

import com.blixx.boom.snmp.SNMPTrapd;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TreeEvent;
import org.snmp4j.util.TreeListener;
import org.snmp4j.util.TreeUtils;

public class SNMPWalkPrinter
implements IMonitorExt,
PDUFactory {
    int m_version = 0;
    String m_community = null;
    int m_retries = 1;
    int m_timeout = 10000;
    int m_port = 161;
    String m_host = "127.0.0.1";
    OID m_startOid = new OID("1.3.6");
    OID m_stopAt = null;
    Target target;
    Snmp session = null;
    OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    static int engineBootCount = 0;
    OID authProtocol;
    OID privProtocol;
    OctetString privPassphrase;
    OctetString authPassphrase;
    OctetString community = new OctetString("public");
    OctetString authoritativeEngineID;
    OctetString contextEngineID;
    OctetString contextName = new OctetString();
    OctetString securityName = new OctetString();
    int maxSizeResponsePDU = 65535;
    PDUv1 v1TrapPDU = new PDUv1();
    String[] m_parameters;
    public String m_monitor = "";
    public IMonitorSubmitter m_submitter = null;
    public IMessage m_msgSubmitter = null;

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        SNMPWalkPrinter mon = new SNMPWalkPrinter(parameters);
        mon.m_monitor = monitorName;
        return mon;
    }

    public SNMPWalkPrinter(String[] parameters) {
        this.m_parameters = parameters;
        this.parseOptions(parameters);
    }

    public void setInterval(long ms) {
        this.m_timeout = (int)ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_submitter = submitter;
    }

    public String runMonitor() {
        block12: {
            InetAddress remote = null;
            Snmp snmp = null;
            try {
                try {
                    this.parseOptions(this.m_parameters);
                    remote = InetAddress.getByName(this.m_host);
                    DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
                    snmp = new Snmp(transport);
                    ((MPv3)snmp.getMessageProcessingModel(3)).setLocalEngineID(this.localEngineID.getValue());
                    if (this.m_version == 3) {
                        SecurityProtocols.getInstance().addDefaultProtocols();
                        SecurityProtocols.getInstance().addPrivacyProtocol(new Priv3DES());
                        USM usm = new USM(SecurityProtocols.getInstance(), this.localEngineID, engineBootCount);
                        SecurityModels.getInstance().addSecurityModel(usm);
                        this.addUsmUser(snmp);
                    }
                    this.target = this.createTarget();
                    this.target.setVersion(this.m_version);
                    UdpAddress ua = new UdpAddress(String.valueOf(this.m_host) + "/" + this.m_port);
                    this.target.setAddress(ua);
                    this.target.setRetries(this.m_retries);
                    this.target.setTimeout(this.m_timeout);
                    this.target.setMaxSizeRequestPDU(this.maxSizeResponsePDU);
                    snmp.listen();
                    PDU request = this.createPDU(this.target);
                    request.setMaxRepetitions(0);
                    request.setNonRepeaters(0);
                    request.add(new VariableBinding(this.m_startOid));
                    this.walk(snmp, request, this.target);
                }
                catch (Throwable e) {
                    this.m_msgSubmitter.sendMessage(null, "", "", this.m_monitor, "Error: " + e.getMessage(), "warning", null);
                    try {
                        snmp.close();
                    }
                    catch (Throwable throwable) {}
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    snmp.close();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                snmp.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return String.valueOf(this.m_monitor) + "=0";
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
    }

    @Override
    public PDU createPDU(Target target) {
        PDU request;
        if (target.getVersion() == 3) {
            request = new ScopedPDU();
            ScopedPDU scopedPDU = request;
            if (this.contextEngineID != null) {
                scopedPDU.setContextEngineID(this.contextEngineID);
            }
            if (this.contextName != null) {
                scopedPDU.setContextName(this.contextName);
            }
        } else {
            request = this.m_version == -92 ? this.v1TrapPDU : new PDU();
            request.setType(-95);
        }
        return request;
    }

    @Override
    public PDU createPDU(MessageProcessingModel messageProcessingModel) {
        PDU request = messageProcessingModel.getID() == 3 ? new ScopedPDU() : new PDU();
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void parseOptions(String[] args) throws IllegalArgumentException {
        boolean lastArg = false;
        int i = 0;
        while (i < args.length) {
            String[] name_val = args[i].split("\\s+");
            if (name_val[0].equals("-c") && name_val.length == 2) {
                this.m_community = name_val[1];
            } else if (name_val[0].equals("-v") && name_val.length == 2) {
                if (name_val[1].equals("1")) {
                    this.m_version = 0;
                } else if (name_val[1].equals("2") || name_val[1].equals("2c")) {
                    this.m_version = 1;
                } else {
                    if (!name_val[1].equals("3")) throw new RuntimeException("Invalid SNMP version specified: " + name_val[1]);
                    this.m_version = 3;
                }
            } else if (name_val[0].equals("-p") && name_val.length == 2) {
                try {
                    this.m_port = Integer.parseInt(name_val[1]);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid SNMP port specified: " + name_val[1]);
                }
            } else if (name_val[0].equals("-r") && name_val.length == 2) {
                try {
                    this.m_retries = Integer.parseInt(name_val[1]);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid SNMP retry specified: " + name_val[1]);
                }
            } else if (name_val[0].equals("-t") && name_val.length == 2) {
                try {
                    float f = Float.parseFloat(name_val[1]);
                    this.m_timeout = (int)(f * 1000.0f);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Invalid timeout specified: " + name_val[1]);
                }
            } else if (name_val[0].equals("-h") && name_val.length == 2) {
                this.m_host = name_val[1];
            } else if (name_val[0].equals("-o") && name_val.length == 2) {
                this.m_startOid = new OID(name_val[1]);
            } else if (name_val[0].equals("-Xu") && name_val.length == 2) {
                this.securityName = SNMPWalkPrinter.createOctetString(name_val[1]);
            } else if (name_val[0].equals("-Xa") && name_val.length == 2) {
                String s = name_val[1];
                this.authProtocol = SNMPTrapd.getAuthProtocol(s);
            } else if (name_val[0].equals("-Xs") && name_val.length == 2) {
                this.authPassphrase = SNMPWalkPrinter.createOctetString(name_val[1]);
            } else if (name_val[0].equals("-Xp") && name_val.length == 2) {
                this.privPassphrase = SNMPWalkPrinter.createOctetString(name_val[1]);
            } else if (name_val[0].equals("-Xt") && name_val.length == 2) {
                String s = name_val[1];
                this.privProtocol = SNMPTrapd.getPrivProtocol(s);
            }
            ++i;
        }
    }

    private static OctetString createOctetString(String s) {
        OctetString octetString = s.startsWith("0x") ? OctetString.fromHexString(s.substring(2), ':') : new OctetString(s);
        return octetString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PDU walk(Snmp snmp, PDU request, Target target) throws IOException {
        TreeListener treeListener;
        OID rootOID = request.get(0).getOid();
        PDU response = null;
        final WalkCounts counts = new WalkCounts();
        long startTime = System.currentTimeMillis();
        TreeUtils treeUtils = new TreeUtils(snmp, this);
        treeUtils.setIgnoreLexicographicOrder(true);
        TreeListener treeListener2 = treeListener = new TreeListener(){
            private boolean finished;

            @Override
            public boolean next(TreeEvent e) {
                ++counts.requests;
                if (e.getVariableBindings() != null) {
                    VariableBinding[] vbs = e.getVariableBindings();
                    counts.objects += vbs.length;
                    int i = 0;
                    while (i < vbs.length) {
                        String oid = vbs[i].getOid().toString();
                        String value = vbs[i].getVariable().toString();
                        HashMap<String, String> opts = new HashMap<String, String>();
                        opts.put("POLICY_NAME", SNMPWalkPrinter.this.m_monitor);
                        SNMPWalkPrinter.this.m_msgSubmitter.sendMessage(SNMPWalkPrinter.this.m_host, "", "", oid, value, "unknown", opts);
                        ++i;
                    }
                }
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(TreeEvent e) {
                if (e.getVariableBindings() != null && e.getVariableBindings().length > 0) {
                    this.next(e);
                }
                if (e.isError()) {
                    SNMPWalkPrinter.this.m_msgSubmitter.sendMessage(SNMPWalkPrinter.this.m_host, "", "", SNMPWalkPrinter.this.m_monitor, "Error: " + e.getErrorMessage(), "warning", null);
                }
                this.finished = true;
                1 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }

            @Override
            public boolean isFinished() {
                return this.finished;
            }
        };
        synchronized (treeListener2) {
            treeUtils.getSubtree(target, rootOID, null, treeListener);
            try {
                treeListener.wait();
            }
            catch (InterruptedException ex) {
                HashMap<String, String> opts = new HashMap<String, String>();
                opts.put("POLICY_NAME", this.m_monitor);
                this.m_msgSubmitter.sendMessage(this.m_host, "", "", this.m_monitor, "Tree retrieval interrupted: " + ex.getMessage(), "warning", opts);
                Thread.currentThread().interrupt();
            }
        }
        return response;
    }

    private void addUsmUser(Snmp snmp) {
        snmp.getUSM().addUser(this.securityName, new UsmUser(this.securityName, this.authProtocol, this.authPassphrase, this.privProtocol, this.privPassphrase));
    }

    private Target createTarget() {
        if (this.m_version == 3) {
            UserTarget target = new UserTarget();
            if (this.authPassphrase != null) {
                if (this.privPassphrase != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(this.securityName);
            return target;
        }
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(this.community);
        return target;
    }

    class WalkCounts {
        public int requests;
        public int objects;

        WalkCounts() {
        }
    }
}

