/*
 * Decompiled with CFR 0.152.
 */
package com.wl.snmp.exp4j;

import com.wl.snmp.exp4j.ArrayStack;
import com.wl.snmp.exp4j.ValidationResult;
import com.wl.snmp.exp4j.function.Function;
import com.wl.snmp.exp4j.operator.Operator;
import com.wl.snmp.exp4j.tokenizer.FunctionToken;
import com.wl.snmp.exp4j.tokenizer.NumberToken;
import com.wl.snmp.exp4j.tokenizer.OperatorToken;
import com.wl.snmp.exp4j.tokenizer.Token;
import com.wl.snmp.exp4j.tokenizer.VariableToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class Expression {
    private final Token[] tokens;
    private final Map<String, Double> variables;
    private final Set<String> userFunctionNames;

    Expression(Token[] tokens) {
        this.tokens = tokens;
        this.variables = new HashMap<String, Double>(4);
        this.userFunctionNames = Collections.emptySet();
    }

    Expression(Token[] tokens, Set<String> userFunctionNames) {
        this.tokens = tokens;
        this.variables = new HashMap<String, Double>(4);
        this.userFunctionNames = userFunctionNames;
    }

    public Expression setVariable(String name, double value) {
        this.checkVariableName(name);
        this.variables.put(name, value);
        return this;
    }

    private void checkVariableName(String name) {
        if (this.userFunctionNames.contains(name)) {
            throw new IllegalArgumentException("The setVariable name '" + name + "' is invalid. Since there exists a function with the same name");
        }
    }

    public Expression setVariables(Map<String, Double> variables) {
        for (Map.Entry<String, Double> v : variables.entrySet()) {
            this.setVariable(v.getKey(), v.getValue());
        }
        return this;
    }

    public ValidationResult validate(boolean checkVariablesSet) {
        int n;
        ArrayList<String> errors = new ArrayList<String>(0);
        if (checkVariablesSet) {
            Token[] tokenArray = this.tokens;
            n = this.tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String var;
                Token t = tokenArray[n2];
                if (t.getType() == 6 && !this.variables.containsKey(var = ((VariableToken)t).getName())) {
                    errors.add("The setVariable '" + var + "' has not been set");
                }
                ++n2;
            }
        }
        int count = 0;
        Token[] tokenArray = this.tokens;
        int n3 = this.tokens.length;
        n = 0;
        while (n < n3) {
            Token tok = tokenArray[n];
            switch (tok.getType()) {
                case 1: 
                case 6: {
                    ++count;
                    break;
                }
                case 3: {
                    Function func = ((FunctionToken)tok).getFunction();
                    int argsNum = func.getNumArguments();
                    if (argsNum > count) {
                        errors.add("Not enough arguments for '" + func.getName() + "'");
                    }
                    if (argsNum <= 1) break;
                    count -= argsNum - 1;
                    break;
                }
                case 2: {
                    Operator op = ((OperatorToken)tok).getOperator();
                    if (op.getNumOperands() != 2) break;
                    --count;
                }
            }
            if (count < 1) {
                errors.add("Too many operators");
                return new ValidationResult(false, errors);
            }
            ++n;
        }
        if (count > 1) {
            errors.add("Too many operands");
        }
        return errors.size() == 0 ? ValidationResult.SUCCESS : new ValidationResult(false, errors);
    }

    public ValidationResult validate() {
        return this.validate(true);
    }

    public Future<Double> evaluateAsync(ExecutorService executor) {
        return executor.submit(new Callable<Double>(){

            @Override
            public Double call() throws Exception {
                return Expression.this.evaluate();
            }
        });
    }

    public double evaluate() {
        ArrayStack output = new ArrayStack();
        int i = 0;
        while (i < this.tokens.length) {
            Token t = this.tokens[i];
            if (t.getType() == 1) {
                output.push(((NumberToken)t).getValue());
            } else if (t.getType() == 6) {
                String name = ((VariableToken)t).getName();
                Double value = this.variables.get(name);
                if (value == null) {
                    throw new IllegalArgumentException("No value has been set for the setVariable '" + name + "'.");
                }
                output.push(value);
            } else if (t.getType() == 2) {
                OperatorToken op = (OperatorToken)t;
                if (output.size() < op.getOperator().getNumOperands()) {
                    throw new IllegalArgumentException("Invalid number of operands available for '" + op.getOperator().getSymbol() + "' operator");
                }
                if (op.getOperator().getNumOperands() == 2) {
                    double rightArg = output.pop();
                    double leftArg = output.pop();
                    output.push(op.getOperator().apply(leftArg, rightArg));
                } else if (op.getOperator().getNumOperands() == 1) {
                    double arg = output.pop();
                    output.push(op.getOperator().apply(arg));
                }
            } else if (t.getType() == 3) {
                FunctionToken func = (FunctionToken)t;
                if (output.size() < func.getFunction().getNumArguments()) {
                    throw new IllegalArgumentException("Invalid number of arguments available for '" + func.getFunction().getName() + "' function");
                }
                double[] args = new double[func.getFunction().getNumArguments()];
                int j = 0;
                while (j < func.getFunction().getNumArguments()) {
                    args[j] = output.pop();
                    ++j;
                }
                output.push(func.getFunction().apply(this.reverseInPlace(args)));
            }
            ++i;
        }
        if (output.size() > 1) {
            throw new IllegalArgumentException("Invalid number of items on the output queue. Might be caused by an invalid number of arguments for a function.");
        }
        return output.pop();
    }

    private double[] reverseInPlace(double[] args) {
        int len = args.length;
        int i = 0;
        while (i < len / 2) {
            double tmp = args[i];
            args[i] = args[len - i - 1];
            args[len - i - 1] = tmp;
            ++i;
        }
        return args;
    }
}

