/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.smi;

public enum MaxAccess {
    notAccessible("not-accessible"),
    accessibleForNotify("accessible-for-notify"),
    writeOnly("write-only"),
    readOnly("read-only"),
    readWrite("read-write"),
    readCreate("read-create");

    private String smiValue;

    private MaxAccess(String smiValue) {
        this.smiValue = smiValue;
    }

    public String getSmiValue() {
        return this.smiValue;
    }

    public static MaxAccess fromSmiValue(String smiValue) {
        MaxAccess[] maxAccessArray = MaxAccess.values();
        int n = maxAccessArray.length;
        int n2 = 0;
        while (n2 < n) {
            MaxAccess v = maxAccessArray[n2];
            if (v.getSmiValue().equals(smiValue)) {
                return v;
            }
            ++n2;
        }
        return null;
    }

    public boolean isReadOnly() {
        return this == readOnly;
    }

    public boolean isWritable() {
        return this.ordinal() >= readWrite.ordinal();
    }

    public boolean isCreatable() {
        return this == readCreate;
    }
}

