/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.test;

import com.blixx.boom.snmp.SALogger;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.test.NullMonSubmitter;
import com.blixx.ext.test.NullMsgSubmitter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.Snmp;
import org.snmp4j.event.AuthenticationFailureEvent;
import org.snmp4j.event.AuthenticationFailureListener;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.test.OIDTextFormatter;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.ThreadPool;

public class TrapReceiver
implements CommandResponder,
IMonitorExt,
Runnable,
AuthenticationFailureListener {
    public static final String SYSUPTIME_VARNAME = "T";
    private static String TRAPOID = ".1.3.6.1.6.3.1.1.4.1.0";
    private static final String SNMP_TRAP_ENTERPRISE_ID = ".1.3.6.1.6.3.1.1.4.3.0";
    private static final String SNMP_TRAPS = ".1.3.6.1.6.3.1.1.5";
    private static final String SNMP_SYSUPTIME = ".1.3.6.1.2.1.1.3";
    private static final String SNMP_SYSUPTIME2 = ".1.3.6.1.2.1.1.3.0";
    private static final String GROUP_SNMP = "SNMP";
    private static final String APPL_SNMPTRAPD = "SNMPTrapd";
    private static final int ERROR_EXCEPTION = -1;
    public static TrapReceiver m_instance = null;
    public IMessage m_msgSubmitter = null;
    public int m_port = 162;
    private String m_monitorName = null;
    private Thread m_listenerThread = null;
    public boolean m_printOutput = false;
    public AtomicBoolean m_running = new AtomicBoolean(true);
    Publisher m_publisher = null;
    Thread m_publischerThread = null;
    private Snmp m_trapSession = null;
    private Address listenAddress;
    static Map<String, String> GENERIC_TRAPS = new HashMap<String, String>(14, 0.99f);
    public static SALogger m_logger;
    private AtomicInteger processedTraps = new AtomicInteger(0);
    private long startTimeNs = -1L;
    public static AtomicInteger m_counter;

    static {
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.1", "0");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.2", "1");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.3", "2");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.4", "3");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.5", "4");
        GENERIC_TRAPS.put("1.3.6.1.6.3.1.1.5.6", "5");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.1", "0");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.2", "1");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.3", "2");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.4", "3");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.5", "4");
        GENERIC_TRAPS.put(".1.3.6.1.6.3.1.1.5.6", "5");
        m_logger = new SALogger();
        m_counter = new AtomicInteger(0);
    }

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        if (m_instance == null) {
            m_instance = new TrapReceiver();
            TrapReceiver.m_instance.m_monitorName = monitorName;
            if (parameters != null && parameters.length > 0) {
                StringBuilder sb = new StringBuilder();
                int i = 0;
                while (i < parameters.length) {
                    sb.append(parameters[i]);
                    if (i < parameters.length - 1) {
                        sb.append(" ");
                    }
                    ++i;
                }
                parameters = sb.toString().split("\\s+");
                try {
                    i = 0;
                    while (i < parameters.length) {
                        if (parameters[i].trim().equalsIgnoreCase("-p")) {
                            TrapReceiver.m_instance.m_port = Integer.parseInt(parameters[++i]);
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block22: {
            try {
                if (this.m_trapSession != null) {
                    try {
                        Snmp snmp = this.m_trapSession;
                        synchronized (snmp) {
                            this.m_trapSession.notifyAll();
                        }
                        this.m_trapSession.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ThreadPool threadPool = ThreadPool.create("Trap", 3);
                MessageDispatcherImpl messageDispatcher = new MessageDispatcherImpl();
                MultiThreadedMessageDispatcher mtDispatcher = new MultiThreadedMessageDispatcher(threadPool, messageDispatcher);
                this.m_trapSession = new Snmp(mtDispatcher);
                messageDispatcher.addAuthenticationFailureListener(this);
                Address listenAddress = GenericAddress.parse(System.getProperty("snmp4j.listenAddress", "udp:0.0.0.0/" + this.m_port));
                try {
                    if (!this.m_trapSession.addNotificationListener(listenAddress, this)) {
                        this.m_msgSubmitter.sendMessage(null, "AGENT", GROUP_SNMP, APPL_SNMPTRAPD, "Error: Failed to initialize notification listener.", "warning", null);
                        return;
                    }
                }
                catch (Exception e) {
                    this.m_msgSubmitter.sendMessage(null, "AGENT", GROUP_SNMP, APPL_SNMPTRAPD, "Error: Port is busy.", "warning", null);
                    this.m_trapSession = null;
                    return;
                }
                SNMP4JSettings.setOIDTextFormat(new OIDTextFormatter());
                SecurityProtocols protocols = SecurityProtocols.getInstance();
                protocols.addDefaultProtocols();
                MPv3 mPv3 = new MPv3();
                mPv3.setSecurityProtocols(protocols);
                this.m_trapSession.getMessageDispatcher().addMessageProcessingModel(new MPv1());
                this.m_trapSession.getMessageDispatcher().addMessageProcessingModel(new MPv2c());
                this.m_trapSession.getMessageDispatcher().addMessageProcessingModel(mPv3);
                USM usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
                usm.addUser(new OctetString(MPv3.createLocalEngineID()), new UsmUser(new OctetString("boom"), AuthMD5.ID, new OctetString("boomsnmp"), PrivDES.ID, new OctetString("boomsnmp")));
                usm.addUser(new OctetString(MPv3.createLocalEngineID()), new UsmUser(new OctetString("boomaes"), AuthSHA.ID, new OctetString("boomsnmp"), PrivAES128.ID, new OctetString("boomsnmp")));
                usm.addUser(new OctetString(MPv3.createLocalEngineID()), new UsmUser(new OctetString("boomnopriv"), AuthSHA.ID, new OctetString("boomsnmp"), null, null));
                SecurityModels.getInstance().addSecurityModel(usm);
                try {
                    Snmp snmp = this.m_trapSession;
                    synchronized (snmp) {
                        this.m_trapSession.wait();
                    }
                }
                catch (InterruptedException e) {
                    this.m_msgSubmitter.sendMessage(null, "AGENT", GROUP_SNMP, APPL_SNMPTRAPD, "SNMPTrapd stopped. Error: " + e.getMessage(), "warning", null);
                }
                try {
                    this.m_trapSession.close();
                }
                catch (Throwable throwable) {}
                break block22;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                this.m_trapSession = null;
            }
        }
    }

    public void processTrapV1(CommandResponderEvent event) {
        System.out.println("V1 Trap received");
        LinkedHashMap<String, String> opts = new LinkedHashMap<String, String>();
        PDUv1 pdu = (PDUv1)event.getPDU();
        String agentAddress = pdu.getAgentAddress().toString();
        opts.put("IP", agentAddress);
        opts.put("A", agentAddress);
        String enterprise = pdu.getEnterprise().toString();
        opts.put("Enterprise", enterprise);
        opts.put("e", enterprise);
        String generic = "" + pdu.getGenericTrap();
        opts.put("Generic", generic);
        opts.put("G", generic);
        String specific = "" + pdu.getSpecificTrap();
        opts.put("Specific", specific);
        opts.put("S", specific);
        opts.put(SYSUPTIME_VARNAME, "" + pdu.getTimestamp());
        OctetString community = new OctetString(event.getSecurityName());
        opts.put("Community", community.toString());
        opts.put("C", community.toString());
        String oid = String.valueOf(enterprise) + ":" + generic + "." + specific;
        opts.put("o", String.valueOf(enterprise) + "." + generic + "." + specific);
        ArrayList<? extends VariableBinding> list = new ArrayList<VariableBinding>();
        list.addAll(event.getPDU().getVariableBindings());
        opts.put("#", "" + list.size());
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            VariableBinding vb = (VariableBinding)list.get(i);
            String variableName = vb.getOid().toString();
            String variableValue = vb.getVariable().toString();
            opts.put(variableName, variableValue);
            opts.put("" + (i + 1), vb.getVariable().toString());
            sb.append(variableName).append("=").append(variableValue).append("\n");
            ++i;
        }
        String hostnameIP = pdu.getAgentAddress().toString();
        hostnameIP = agentAddress != null && agentAddress.length() > 0 ? agentAddress : (hostnameIP.startsWith("/") ? hostnameIP.substring(1) : hostnameIP.substring(0, hostnameIP.indexOf(47)));
        if (sb.length() == 0) {
            sb.append(oid);
        }
        this.m_msgSubmitter.sendMessage(hostnameIP, APPL_SNMPTRAPD, GROUP_SNMP, oid, sb.toString(), "warning", opts);
    }

    public void processTrapV2(CommandResponderEvent event) {
        HashMap<String, String> opts = new HashMap<String, String>();
        this.processAndSend(event, opts);
    }

    private void processAndSend(CommandResponderEvent event, HashMap<String, String> opts) {
        String E;
        String S;
        String G;
        opts.put("PDUCommand", "" + (256 + event.getPDU().getType()));
        OctetString community = new OctetString(event.getSecurityName());
        opts.put("Community", community.toString());
        opts.put("C", community.toString());
        opts.put("PDUErrorStatus", "" + event.getPDU().getErrorStatus());
        opts.put("PDUErrorIndex", "" + event.getPDU().getErrorIndex());
        String severiry = "warning";
        ArrayList<VariableBinding> list = new ArrayList<VariableBinding>();
        String sysUpTime = "";
        String oid = "";
        Vector<? extends VariableBinding> bindings = event.getPDU().getVariableBindings();
        int i = 0;
        while (i < bindings.size()) {
            VariableBinding vb = bindings.get(i);
            String variableName = vb.getOid().toString();
            if (SNMP_SYSUPTIME2.equals(variableName) || SNMP_SYSUPTIME.equals(variableName)) {
                sysUpTime = vb.getVariable().toString();
            } else if (TRAPOID.equals(variableName)) {
                oid = vb.getVariable().toString();
            } else {
                list.add(vb);
            }
            ++i;
        }
        opts.put("#", "" + list.size());
        StringBuilder sb = new StringBuilder();
        sb.append(SNMP_SYSUPTIME).append("=").append(sysUpTime).append("\n");
        sb.append(TRAPOID).append("=").append(oid).append("\n");
        opts.put(SYSUPTIME_VARNAME, sysUpTime);
        opts.put(TRAPOID, oid);
        int i2 = 0;
        while (i2 < list.size()) {
            VariableBinding vb = (VariableBinding)list.get(i2);
            String name = vb.getOid().toString();
            String value = vb.getVariable().toString();
            opts.put(name, value);
            opts.put("" + (i2 + 1), value);
            sb.append(name);
            sb.append("=" + value).append("\n");
            ++i2;
        }
        String generic = GENERIC_TRAPS.get(oid);
        if (generic != null) {
            G = generic;
            opts.put("G", G);
            S = "0";
            opts.put("S", S);
            String enterprise = opts.get(SNMP_TRAP_ENTERPRISE_ID);
            if (enterprise != null) {
                E = enterprise;
                opts.put("e", E);
                StringBuilder sbb = new StringBuilder();
                sbb.append(E).append(':').append(G).append('.').append(S);
                oid = sbb.toString();
            } else {
                E = ".1.3.6.1.6.3.1.1.5." + oid.charAt(oid.length() - 1);
                opts.put("e", E);
            }
        } else {
            G = "6";
            opts.put("G", G);
            int lastDot = oid.lastIndexOf(46);
            S = oid.substring(lastDot + 1);
            opts.put("S", S);
            if (oid.charAt(lastDot - 1) == '0') {
                E = oid.substring(0, lastDot - 2);
                opts.put("e", E);
            } else {
                E = oid.substring(0, lastDot);
                opts.put("e", E);
            }
        }
        String hostnameIP = event.getPeerAddress().toString();
        hostnameIP = hostnameIP.startsWith("/") ? hostnameIP.substring(1) : hostnameIP.substring(0, hostnameIP.indexOf(47));
        opts.put("o", oid);
        opts.put("A", hostnameIP);
        StringBuilder sbOBJECT = new StringBuilder();
        sbOBJECT.append(E).append(':').append(G).append('.').append(S);
        String OBJECT = sbOBJECT.toString();
        if (sb.length() == 0) {
            sb.append(oid);
        }
        this.m_msgSubmitter.sendMessage(hostnameIP, APPL_SNMPTRAPD, GROUP_SNMP, oid, sb.toString(), severiry, opts);
    }

    private void processTrapV3(CommandResponderEvent event) {
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("USMName", new String(event.getSecurityName()));
        this.processAndSend(event, opts);
    }

    @Override
    public void authenticationFailure(AuthenticationFailureEvent event) {
        String error = "Unknown Authentication failure";
        switch (event.getError()) {
            case -1402: {
                error = "Unsupported security model";
                break;
            }
            case 1408: {
                error = "Authentication failure";
                break;
            }
            case 1403: {
                error = "Unsupported security level";
                break;
            }
            case 1404: {
                error = "Uknown security name";
                break;
            }
            case 1407: {
                error = "Authentication error";
                break;
            }
            case 1411: {
                error = "Authentication not in time window";
                break;
            }
            case 1412: {
                error = "Unsupported Authentication protocol";
                break;
            }
            case 1410: {
                error = "Unknown engine ID";
                return;
            }
            case -1412: {
                error = "Wrong user name";
                break;
            }
            case 1603: {
                error = "TSM Inadequate security level";
                break;
            }
            case -1414: {
                error = "USM error";
            }
        }
        this.m_msgSubmitter.sendMessage(event.getAddress().toString(), APPL_SNMPTRAPD, GROUP_SNMP, "USM Error", error, "warning", null);
    }

    @Override
    public void processPdu(CommandResponderEvent event) {
        int processed;
        long pt = System.nanoTime();
        switch (event.getMessageProcessingModel()) {
            case 0: {
                this.processTrapV1(event);
                break;
            }
            case 1: 
            case 2: {
                this.processTrapV2(event);
                break;
            }
            case 3: {
                this.processTrapV3(event);
                break;
            }
            default: {
                System.out.println("Unknown trap version");
            }
        }
        pt = System.nanoTime() - pt;
        if (this.startTimeNs == -1L) {
            this.startTimeNs = System.nanoTime();
        }
        if ((processed = this.processedTraps.incrementAndGet()) % 1000 == 1) {
            long time = System.nanoTime() - this.startTimeNs;
            System.out.println("Processed " + (double)processed / (double)time * 1.0E9 + "/s, total=" + processed);
        }
    }

    public void printMap(Map<String, String> map) {
        for (String key : map.keySet()) {
            System.out.println(String.valueOf('\"') + key + '\"' + ":" + '\"' + map.get(key) + '\"');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snmpTrapSessionError(Snmp session, int error, Object ref) {
        this.m_msgSubmitter.sendMessage(null, APPL_SNMPTRAPD, GROUP_SNMP, null, "" + ref, "warning", null);
        if (error == -1) {
            Snmp snmp = session;
            synchronized (snmp) {
                try {
                    session.notify();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public void snmpProcessBadPacket(DatagramPacket dp) {
        TrapReceiver.print("unsupported UDP packet detected. ");
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
    }

    public String runMonitor() {
        if (this.m_trapSession == null || !this.m_listenerThread.isAlive()) {
            this.m_listenerThread = new Thread(this);
            this.m_listenerThread.start();
        }
        return String.valueOf(this.m_monitorName) + "=0";
    }

    public void setMessageSubmitter(IMessage submitter) {
        if (submitter != null) {
            this.m_msgSubmitter = submitter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            Snmp snmp = this.m_trapSession;
            synchronized (snmp) {
                try {
                    this.m_trapSession.notify();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.m_trapSession.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.m_running.set(false);
        m_instance = null;
    }

    public static void print(String msg) {
        if (m_instance != null && TrapReceiver.m_instance.m_printOutput) {
            m_logger.print(1, msg);
        }
    }

    public static void print(String msg, Throwable e) {
        if (m_instance != null && TrapReceiver.m_instance.m_printOutput) {
            m_logger.print(1, msg, e);
        }
    }

    public static void main(String[] parameters) {
        boolean sendDataToBoomAgent = false;
        int boomAgentPort = 23021;
        String boomAgentHost = "localhost";
        try {
            boomAgentHost = InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        boolean printOutput = false;
        if (parameters != null && parameters.length > 0) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < parameters.length) {
                sb.append(parameters[i]);
                if (i < parameters.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            parameters = sb.toString().split("\\s+");
            m_logger.setLevel(-1);
            m_logger.setMaxCount(5);
            m_logger.setMaxSize(0xA00000L);
            try {
                i = 0;
                while (i < parameters.length) {
                    if (parameters[i].trim().equalsIgnoreCase("-ap")) {
                        sendDataToBoomAgent = true;
                        boomAgentPort = Integer.parseInt(parameters[++i]);
                    } else if (parameters[i].trim().equalsIgnoreCase("-ah")) {
                        sendDataToBoomAgent = true;
                        boomAgentHost = parameters[++i];
                        InetAddress.getByName(boomAgentHost);
                    } else if (parameters[i].trim().equalsIgnoreCase("-v")) {
                        printOutput = true;
                    } else if (parameters[i].trim().equalsIgnoreCase("-logcount")) {
                        try {
                            int lc = Integer.parseInt(parameters[++i]);
                            m_logger.setMaxCount(lc);
                        }
                        catch (Throwable lc) {}
                    } else if (parameters[i].trim().equalsIgnoreCase("-logsize")) {
                        try {
                            long ls = m_logger.parseMaxSize(parameters[++i]);
                            if (ls > 1024L) {
                                m_logger.setMaxSize(ls);
                            }
                        }
                        catch (Throwable ls) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
                m_logger.setDir(".", "snmpSA_");
                m_logger.setLevel(1);
                m_logger.setEnabled(true);
                m_logger.print(1, "*********************************************************************");
            }
            catch (Throwable e) {
                e.printStackTrace();
                System.exit(1);
            }
        }
        TrapReceiver mon = (TrapReceiver)TrapReceiver.getInstance("SNMP4jTestMonitor", parameters);
        mon.m_printOutput = printOutput;
        MsgSubmitter msgSubmitter = null;
        if (sendDataToBoomAgent) {
            mon.setMonitorSubmitter(mon.new MonSubmitter());
            msgSubmitter = mon.new MsgSubmitter();
            mon.setMessageSubmitter(msgSubmitter);
            mon.check(msgSubmitter.getIndiQueue(), boomAgentHost, boomAgentPort);
        } else {
            mon.setMonitorSubmitter((IMonitorSubmitter)new NullMonSubmitter());
            mon.setMessageSubmitter((IMessage)new NullMsgSubmitter());
        }
        mon.runMonitor();
        while (true) {
            try {
                while (true) {
                    IMessage ms;
                    Thread.sleep(1000L);
                    mon.runMonitor();
                    if (msgSubmitter != null) {
                        mon.check(msgSubmitter.getIndiQueue(), boomAgentHost, boomAgentPort);
                    }
                    if ((ms = mon.m_msgSubmitter) == null || !(ms instanceof MsgSubmitter)) continue;
                    MsgSubmitter mss = (MsgSubmitter)ms;
                    int size = mss.m_queue.size();
                    if (size <= 0) continue;
                    TrapReceiver.print("Trap Queue size: " + size);
                }
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }

    public void check(LinkedBlockingQueue<Indi> indiQueue, String host, int port) {
        if (this.m_publisher == null) {
            this.m_publisher = new Publisher(indiQueue, host, port);
        }
        if (this.m_publischerThread == null || this.m_publisher.m_stopped.get()) {
            this.m_publischerThread = new Thread(this.m_publisher);
            this.m_publischerThread.setName("Publisher");
            this.m_publischerThread.start();
        }
    }

    public class Indi {
        public int m_id = 0;
        public String SEP = " ";
        public ByteArrayOutputStream m_text = new ByteArrayOutputStream();

        public Indi(String node, String application, String msggrp, String object, String text, String severity, HashMap optVars) {
            this.m_id = m_counter.incrementAndGet();
            StringBuilder sb = new StringBuilder("E");
            if (node != null && node.length() > 0) {
                sb.append("h=").append(this.quote(node)).append(this.SEP);
            }
            if (application != null && application.length() > 0) {
                sb.append("a=").append(this.quote(application)).append(this.SEP);
            }
            if (msggrp != null && msggrp.length() > 0) {
                sb.append("g=").append(this.quote(msggrp)).append(this.SEP);
            }
            if (object != null && object.length() > 0) {
                sb.append("o=").append(this.quote(object)).append(this.SEP);
            }
            if (severity != null && severity.length() > 0) {
                sb.append("s=").append(this.quote(severity)).append(this.SEP);
            }
            if (optVars != null) {
                for (Map.Entry entry : optVars.entrySet()) {
                    if (entry.getKey() == null) continue;
                    String key = "" + entry.getKey();
                    String value = this.quote("" + entry.getValue());
                    sb.append(key).append('=').append(value).append(this.SEP);
                }
            }
            sb.append("t=").append(this.quote(text));
            String str = sb.toString();
            StringBuilder sbprint = new StringBuilder("Received trap {");
            sbprint.append(this.m_id).append("} ").append(str.substring(1));
            TrapReceiver.print(sbprint.toString());
            try {
                this.m_text.write(str.getBytes());
            }
            catch (IOException e) {
                TrapReceiver.print("Error caching indi. ", e);
            }
        }

        public String quote(String in) {
            if (in.indexOf(34) == -1 && in.indexOf(32) == -1) {
                return in;
            }
            StringBuilder sb = new StringBuilder();
            sb.append('\"');
            int i = 0;
            while (i < in.length()) {
                char prev = '\u0000';
                char current = in.charAt(i);
                if (i > 0) {
                    prev = in.charAt(i - 1);
                }
                if ('\"' == current) {
                    if ('\\' == prev) {
                        sb.append('\\');
                    }
                    sb.append('\\');
                }
                sb.append(current);
                ++i;
            }
            sb.append('\"');
            return sb.toString();
        }

        public byte[] getSubmitString() {
            return this.m_text.toByteArray();
        }
    }

    public class MonSubmitter
    implements IMonitorSubmitter {
        public void submitMonitorValue(String monitor, double value, String object, HashMap optionalVariables) {
        }
    }

    public class MsgSubmitter
    implements IMessage {
        LinkedBlockingQueue<Indi> m_queue = new LinkedBlockingQueue(100000);
        AtomicBoolean m_queueFull = new AtomicBoolean(false);

        public LinkedBlockingQueue<Indi> getIndiQueue() {
            return this.m_queue;
        }

        public void sendMessage(String node, String application, String msggrp, String object, String text, String severity, HashMap optVars) {
            Indi indi = new Indi(node, application, msggrp, object, text, severity, optVars);
            if (!this.m_queue.offer(indi)) {
                if (this.m_queueFull.compareAndSet(false, true)) {
                    TrapReceiver.print("Indication queue is full! Size: " + this.m_queue.size());
                }
            } else if (this.m_queueFull.compareAndSet(true, false)) {
                TrapReceiver.print("Indication queue is now accepts objects");
            }
        }
    }

    private class Publisher
    implements Runnable {
        public AtomicBoolean m_stopped = new AtomicBoolean(false);
        BlockingQueue<Indi> m_queue = null;
        String m_host;
        int m_port = 23021;
        int m_lastFailedIDcount = 0;

        public Publisher(BlockingQueue<Indi> queue, String host, int port) {
            this.m_host = host;
            this.m_port = port;
            this.m_queue = queue;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            OutputStream os;
            InputStream is;
            Socket s;
            block13: {
                this.m_stopped.set(false);
                TrapReceiver.print("Publisher started");
                s = null;
                is = null;
                os = null;
                AtomicBoolean agentIsNotRunning = new AtomicBoolean(true);
                try {
                    try {
                        InetSocketAddress sa = new InetSocketAddress(InetAddress.getByName(this.m_host), this.m_port);
                        s = this.connect(agentIsNotRunning, sa);
                        is = s.getInputStream();
                        os = s.getOutputStream();
                        block6: while (TrapReceiver.this.m_running.get()) {
                            int result;
                            Indi i;
                            while (true) {
                                if (!TrapReceiver.this.m_running.get() || this.m_queue.size() != 0) {
                                    i = (Indi)this.m_queue.peek();
                                    if (i == null) continue block6;
                                    TrapReceiver.print("Sending indi: " + i.m_id);
                                    byte[] bytes = i.getSubmitString();
                                    os.write(bytes);
                                    result = 70;
                                    try {
                                        result = (char)is.read();
                                    }
                                    catch (Throwable e) {
                                        if (84 == result) break;
                                        ++this.m_lastFailedIDcount;
                                        if (this.m_lastFailedIDcount <= 5) {
                                            throw e;
                                        }
                                        TrapReceiver.print("Agent does not accept indication. Trap{" + i.m_id + "} , skipping after 5 tries. Last error: " + e.getMessage());
                                    }
                                    break;
                                }
                                Thread.sleep(1000L);
                            }
                            if (84 != result) {
                                ++this.m_lastFailedIDcount;
                                if (this.m_lastFailedIDcount <= 5) {
                                    throw new RuntimeException("Agent returns \"Fail\" response. Retry...");
                                }
                                TrapReceiver.print("Agent does not accept indication. Trap{" + i.m_id + "}");
                            }
                            this.m_queue.poll();
                            this.m_lastFailedIDcount = 0;
                        }
                    }
                    catch (Throwable e) {
                        if (this.m_lastFailedIDcount == 1) {
                            TrapReceiver.print("Publisher reconnects");
                            break block13;
                        }
                        TrapReceiver.print("Publisher stopped. Error ", e);
                    }
                }
                catch (Throwable throwable) {
                    this.m_stopped.set(true);
                    this.close(s, is, os);
                    throw throwable;
                }
            }
            this.m_stopped.set(true);
            this.close(s, is, os);
        }

        private void close(Socket s, InputStream is, OutputStream os) {
            try {
                os.write(new byte[]{125});
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                os.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                os.write(0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                os.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                is.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                s.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        private Socket connect(AtomicBoolean agentIsNotRunning, SocketAddress sa) throws SocketException, IOException, InterruptedException {
            boolean connected = false;
            Socket s = new Socket(Proxy.NO_PROXY);
            s.setSoTimeout(15000);
            s.setTcpNoDelay(true);
            s.bind(null);
            s.setReuseAddress(true);
            s.setSoLinger(true, 1);
            while (!connected) {
                try {
                    s.connect(sa);
                    connected = true;
                    if (!agentIsNotRunning.compareAndSet(true, false)) continue;
                    TrapReceiver.print("boom Agent is available");
                }
                catch (Throwable e) {
                    TrapReceiver.print("Can't connect. boom Agent is not running?", e);
                    try {
                        s.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    Thread.sleep(1000L);
                    s = new Socket(Proxy.NO_PROXY);
                    s.setSoTimeout(15000);
                    s.setTcpNoDelay(true);
                    s.bind(null);
                    s.setReuseAddress(true);
                    s.setSoLinger(true, 1);
                }
            }
            s.getOutputStream().write(new byte[]{123});
            return s;
        }
    }
}

