/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.test;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class TrapSenderVersion2 {
    public static final String community = "public";
    public static final String Oid = ".1.3.6.1.2.1.1.8";
    public static final String ipAddress = "127.0.0.1";
    public static final int port = 3162;
    private static TransportMapping m_transport;
    private static AtomicInteger m_treadsRunning;

    static {
        m_treadsRunning = new AtomicInteger(0);
    }

    public static void main(String[] args) {
        try {
            m_transport = new DefaultUdpTransportMapping();
            m_transport.listen();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int t = 0;
        while (t < 2) {
            Thread tr = new Thread(new Runnable(){

                @Override
                public void run() {
                    TrapSenderVersion2 trapV2 = new TrapSenderVersion2();
                    int i = 0;
                    while (i < 1000) {
                        trapV2.sendTrap_Version2();
                        ++i;
                    }
                    m_treadsRunning.decrementAndGet();
                }
            });
            tr.start();
            m_treadsRunning.incrementAndGet();
            ++t;
        }
        while (m_treadsRunning.get() > 0) {
            try {
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public void sendTrap_Version2() {
        try {
            CommunityTarget cTarget = new CommunityTarget();
            cTarget.setCommunity(new OctetString(community));
            cTarget.setVersion(1);
            cTarget.setAddress(new UdpAddress("127.0.0.1/3162"));
            cTarget.setRetries(2);
            cTarget.setTimeout(5000L);
            PDU pdu = new PDU();
            pdu.add(new VariableBinding(SnmpConstants.sysUpTime, new OctetString(new Date().toString())));
            pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, new OID(Oid)));
            pdu.add(new VariableBinding(SnmpConstants.snmpTrapAddress, new IpAddress(ipAddress)));
            pdu.add(new VariableBinding(new OID(Oid), new OctetString("Major")));
            pdu.setType(-89);
            Snmp snmp = new Snmp(m_transport);
            snmp.send(pdu, cTarget);
            snmp.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

