/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.test;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.log.ConsoleLogFactory;
import org.snmp4j.log.LogFactory;
import org.snmp4j.log.LogLevel;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class TrapSenderVersion3Inform {
    public static final OctetString boomSnmpTrapdEngineID = OctetString.fromHexString("80:01:01:01:00:01:01:01");
    public static final OctetString ENGINE_ID = OctetString.fromHexString("00:01:01:01:00:01:01:01");
    public static final String community = "public";
    public static final String Oid = ".1.3.6.1.2.1.1.8";
    private ScopedPDU m_pdu;
    private static TransportMapping m_transport;
    private static Snmp snmp;
    private static OctetString userName;
    private static UserTarget cTarget;
    private static byte[] messageOne;

    static {
        byte[] byArray = new byte[229];
        byArray[0] = 48;
        byArray[1] = -127;
        byArray[2] = -30;
        byArray[3] = 2;
        byArray[4] = 1;
        byArray[5] = 3;
        byArray[6] = 48;
        byArray[7] = 17;
        byArray[8] = 2;
        byArray[9] = 4;
        byArray[10] = 39;
        byArray[11] = 26;
        byArray[12] = -117;
        byArray[13] = 96;
        byArray[14] = 2;
        byArray[15] = 3;
        byArray[17] = -1;
        byArray[18] = -1;
        byArray[19] = 4;
        byArray[20] = 1;
        byArray[21] = 3;
        byArray[22] = 2;
        byArray[23] = 1;
        byArray[24] = 3;
        byArray[25] = 4;
        byArray[26] = 57;
        byArray[27] = 48;
        byArray[28] = 55;
        byArray[29] = 4;
        byArray[30] = 13;
        byArray[31] = -128;
        byArray[33] = 19;
        byArray[34] = 112;
        byArray[35] = 1;
        byArray[36] = -64;
        byArray[37] = -88;
        byArray[38] = 123;
        byArray[39] = 103;
        byArray[40] = 81;
        byArray[41] = 41;
        byArray[42] = -75;
        byArray[43] = 88;
        byArray[44] = 2;
        byArray[45] = 1;
        byArray[47] = 2;
        byArray[48] = 1;
        byArray[50] = 4;
        byArray[51] = 8;
        byArray[52] = 117;
        byArray[53] = 115;
        byArray[54] = 101;
        byArray[55] = 114;
        byArray[56] = 110;
        byArray[57] = 97;
        byArray[58] = 109;
        byArray[59] = 101;
        byArray[60] = 4;
        byArray[61] = 12;
        byArray[62] = 30;
        byArray[63] = -105;
        byArray[64] = 66;
        byArray[65] = 27;
        byArray[66] = 58;
        byArray[67] = -106;
        byArray[68] = -68;
        byArray[69] = -124;
        byArray[70] = -51;
        byArray[71] = 101;
        byArray[72] = 42;
        byArray[73] = -116;
        byArray[74] = 4;
        byArray[75] = 8;
        byArray[76] = -57;
        byArray[77] = 71;
        byArray[78] = -40;
        byArray[79] = 123;
        byArray[80] = 47;
        byArray[81] = -75;
        byArray[82] = 76;
        byArray[83] = -126;
        byArray[84] = 4;
        byArray[85] = -127;
        byArray[86] = -114;
        byArray[87] = -106;
        byArray[88] = -54;
        byArray[89] = -39;
        byArray[90] = -63;
        byArray[91] = 64;
        byArray[92] = 33;
        byArray[93] = -93;
        byArray[94] = 86;
        byArray[95] = 27;
        byArray[96] = 118;
        byArray[97] = 80;
        byArray[98] = 42;
        byArray[99] = 70;
        byArray[100] = -44;
        byArray[101] = 85;
        byArray[102] = 29;
        byArray[103] = 117;
        byArray[104] = -17;
        byArray[105] = -15;
        byArray[106] = 103;
        byArray[107] = -31;
        byArray[108] = 4;
        byArray[109] = 56;
        byArray[110] = -44;
        byArray[111] = 10;
        byArray[112] = -23;
        byArray[113] = 23;
        byArray[114] = 47;
        byArray[115] = -86;
        byArray[116] = 40;
        byArray[117] = 119;
        byArray[118] = 77;
        byArray[119] = -94;
        byArray[120] = -40;
        byArray[121] = 60;
        byArray[122] = -59;
        byArray[123] = -8;
        byArray[124] = 66;
        byArray[125] = -85;
        byArray[126] = 13;
        byArray[127] = 120;
        byArray[128] = -13;
        byArray[129] = 13;
        byArray[130] = 70;
        byArray[131] = 14;
        byArray[132] = -16;
        byArray[133] = -9;
        byArray[134] = -9;
        byArray[135] = 54;
        byArray[136] = -107;
        byArray[137] = 49;
        byArray[138] = 123;
        byArray[139] = 19;
        byArray[140] = 7;
        byArray[141] = 24;
        byArray[142] = 15;
        byArray[143] = -113;
        byArray[144] = 108;
        byArray[145] = 22;
        byArray[146] = 115;
        byArray[147] = -56;
        byArray[148] = 25;
        byArray[149] = 5;
        byArray[150] = 87;
        byArray[151] = -89;
        byArray[152] = -72;
        byArray[153] = 28;
        byArray[154] = -39;
        byArray[155] = 95;
        byArray[156] = 27;
        byArray[157] = 32;
        byArray[158] = -112;
        byArray[159] = -47;
        byArray[160] = 54;
        byArray[161] = -114;
        byArray[162] = -69;
        byArray[163] = 11;
        byArray[164] = 3;
        byArray[165] = -47;
        byArray[166] = 48;
        byArray[167] = 107;
        byArray[168] = -22;
        byArray[169] = -79;
        byArray[170] = -13;
        byArray[171] = 76;
        byArray[172] = -98;
        byArray[173] = 62;
        byArray[174] = 34;
        byArray[175] = 119;
        byArray[176] = -43;
        byArray[177] = 31;
        byArray[178] = 75;
        byArray[179] = -92;
        byArray[180] = 95;
        byArray[181] = -11;
        byArray[182] = -39;
        byArray[183] = -82;
        byArray[184] = -2;
        byArray[185] = -59;
        byArray[186] = 79;
        byArray[187] = 71;
        byArray[188] = 120;
        byArray[189] = 124;
        byArray[190] = 58;
        byArray[191] = 110;
        byArray[192] = -36;
        byArray[193] = -30;
        byArray[194] = 24;
        byArray[195] = 121;
        byArray[196] = 27;
        byArray[197] = 88;
        byArray[198] = 106;
        byArray[199] = -79;
        byArray[200] = -2;
        byArray[201] = 111;
        byArray[202] = -8;
        byArray[203] = 41;
        byArray[204] = 84;
        byArray[205] = -6;
        byArray[206] = -22;
        byArray[207] = -128;
        byArray[208] = -118;
        byArray[209] = 45;
        byArray[210] = -6;
        byArray[211] = -74;
        byArray[212] = 6;
        byArray[213] = -19;
        byArray[214] = 17;
        byArray[215] = -97;
        byArray[216] = 78;
        byArray[217] = -108;
        byArray[218] = 51;
        byArray[219] = -32;
        byArray[220] = -123;
        byArray[221] = 101;
        byArray[222] = 81;
        byArray[223] = -50;
        byArray[224] = 31;
        byArray[225] = -124;
        byArray[226] = 74;
        byArray[227] = 56;
        byArray[228] = 21;
        messageOne = byArray;
    }

    public static void main(String[] args) {
        try {
            LogFactory.setLogFactory(new ConsoleLogFactory());
            LogFactory.getLogger(Snmp.class).setLogLevel(LogLevel.DEBUG);
            USM usm = new USM(SecurityProtocols.getInstance().addDefaultProtocols(), ENGINE_ID, 0);
            usm.setEngineDiscoveryEnabled(true);
            SecurityModels.getInstance().addSecurityModel(usm);
            m_transport = new DefaultUdpTransportMapping(new UdpAddress(2162));
            snmp = new Snmp(m_transport);
            snmp.setLocalEngine(ENGINE_ID.getValue(), 0, 0);
            userName = new OctetString("boomaes");
            UsmUser userAes = new UsmUser(userName, AuthSHA.ID, new OctetString("boomsnmp"), PrivAES128.ID, new OctetString("boomsnmp"));
            snmp.getUSM().addUser(userName, userAes);
            m_transport.listen();
            cTarget = new UserTarget(new UdpAddress("127.0.0.1/3162"), new OctetString(userName), new byte[0]);
            cTarget.setVersion(3);
            cTarget.setRetries(1);
            cTarget.setTimeout(1000L);
            cTarget.setSecurityLevel(3);
            cTarget.setSecurityName(userName);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        final AtomicInteger counter2 = new AtomicInteger(0);
        Thread tr2 = new Thread(new Runnable(){

            @Override
            public void run() {
                int i = 0;
                while (i < 1) {
                    ScopedPDU pdu = new ScopedPDU();
                    pdu.add(new VariableBinding(SnmpConstants.sysUpTime, new OctetString(new Date().toString())));
                    pdu.add(new VariableBinding(SnmpConstants.snmpTrapOID, new OID(TrapSenderVersion3Inform.Oid)));
                    pdu.add(new VariableBinding(SnmpConstants.snmpTrapAddress, new IpAddress()));
                    pdu.setContextName(new OctetString("username"));
                    pdu.setType(-90);
                    pdu.add(new VariableBinding(new OID(TrapSenderVersion3Inform.Oid), new OctetString("Inform-" + counter2.incrementAndGet())));
                    try {
                        ResponseEvent re = snmp.send(pdu, cTarget);
                        if (re != null) {
                            System.out.println(re.getResponse());
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
                System.out.println("Processed INFORMs " + counter2.get());
            }
        });
        tr2.start();
    }
}

