/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.mysqlmpi;

import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitor;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;

public class MySQLMPI
implements IMonitorExt {
    public String m_monitor = null;
    public String m_metric = null;
    public String m_mpiDir = null;
    public long m_interval = 300000L;
    public String m_parameters = "";
    public IMessage m_submitter = null;
    private static Socket m_socket = null;

    public static IMonitor getInstance(String monitorName, String[] parameters) {
        MySQLMPI monitor = new MySQLMPI();
        monitor.m_monitor = monitorName;
        monitor.m_metric = parameters[0].trim();
        monitor.m_mpiDir = parameters[1].trim();
        if (!monitor.m_mpiDir.endsWith("/") && !monitor.m_mpiDir.endsWith("\\")) {
            monitor.m_mpiDir = String.valueOf(monitor.m_mpiDir) + File.separator;
        }
        if (parameters.length > 2) {
            int i = 2;
            while (i < parameters.length) {
                monitor.m_parameters = String.valueOf(monitor.m_parameters) + parameters[i];
                monitor.m_parameters = String.valueOf(monitor.m_parameters) + " ";
                ++i;
            }
            monitor.m_parameters = monitor.m_parameters.trim();
        }
        return monitor;
    }

    public String runMonitor() {
        MySQLMPI.startMPI(this.m_mpiDir, this.m_submitter);
        MySQLMPI.call(this.m_mpiDir, this.m_metric, this.m_monitor, this.m_parameters, this.m_interval);
        return null;
    }

    private static synchronized void call(String m_mpiDir, String m_metric, String m_monitor, String m_parameters, long m_interval) {
        try {
            String out;
            boolean isReconnected = false;
            if (m_socket == null || m_socket.isInputShutdown() || m_socket.isOutputShutdown()) {
                MySQLMPI.reconnect(m_mpiDir);
                isReconnected = true;
            }
            InputStream is = m_socket.getInputStream();
            OutputStream os = m_socket.getOutputStream();
            int ch = 35;
            if (!isReconnected) {
                if (is.available() > 0) {
                    byte[] str = new byte[1024];
                    int n = is.read(str);
                }
            } else {
                ch = is.read();
            }
            if (ch == 35) {
                out = "getmon " + m_metric + " " + m_monitor + " " + m_interval;
                if (m_parameters != null) {
                    out = String.valueOf(out) + "@CRLF" + m_parameters;
                }
                out = String.valueOf(out) + "\n";
                os.write(out.getBytes());
                byte[] str = new byte[1024];
                int count = is.read(str);
                String aaa = new String(str);
            } else {
                MySQLMPI.reconnect(m_mpiDir);
                ch = is.read();
                if (ch == 35) {
                    out = "getmon " + m_metric + " " + m_monitor + " " + (System.currentTimeMillis() - m_interval);
                    if (m_parameters != null) {
                        out = String.valueOf(out) + "@CRLF" + m_parameters;
                    }
                    out = String.valueOf(out) + "\n";
                    os.write(out.getBytes());
                    byte[] str = new byte[1024];
                    int n = is.read(str);
                }
            }
        }
        catch (SocketException e1) {
            try {
                m_socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            m_socket = null;
        }
        catch (Throwable e1) {
            try {
                m_socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            m_socket = null;
        }
    }

    private static void reconnect(String m_mpiDir) throws FileNotFoundException, IOException, SocketException {
        if (m_socket != null) {
            try {
                m_socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        File p = new File(String.valueOf(m_mpiDir) + "tsport.cfg");
        FileInputStream fis = new FileInputStream(p);
        byte[] arr = new byte[fis.available()];
        fis.read(arr);
        fis.close();
        String port = new String(arr);
        int portN = 4611;
        portN = Integer.parseInt(port);
        m_socket = new Socket();
        m_socket.bind(null);
        m_socket.setSoTimeout(60000);
        m_socket.setSoLinger(true, 1);
        m_socket.setReuseAddress(true);
        m_socket.connect(new InetSocketAddress("127.0.0.1", portN), 10000);
    }

    protected static synchronized void startMPI(String m_mpiDir, IMessage m_submitter) {
        File hb = new File(String.valueOf(m_mpiDir) + "hb.txt");
        if (!hb.exists() || System.currentTimeMillis() - hb.lastModified() > 20000L) {
            try {
                m_socket.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            m_socket = null;
            String startScriptExec = String.valueOf(m_mpiDir) + ".." + File.separator + "mysqlmpi_start.cmd";
            File startScript = new File(startScriptExec);
            if (startScript.exists()) {
                try {
                    Process p;
                    m_submitter.sendMessage(null, "MySQLMPI", "MySQLMPI", "Startup", "Starting MPI", "normal", null);
                    String prefix = "cmd.exe /C ";
                    if (File.separator.equals("/")) {
                        prefix = "";
                    }
                    if ((p = Runtime.getRuntime().exec(String.valueOf(prefix) + "mysqlmpi_start.cmd", null, startScript.getParentFile())) == null) {
                        m_submitter.sendMessage(null, "MySQLMPI", "MySQLMPI", "Startup", "Error Starting MPI", "warning", null);
                    }
                    Thread.sleep(60000L);
                }
                catch (Throwable e) {
                    m_submitter.sendMessage(null, "MySQLMPI", "MySQLMPI", "Startup", "Error Starting MPI:" + e.getMessage(), "normal", null);
                }
            } else {
                startScriptExec = String.valueOf(m_mpiDir) + ".." + File.separator + "mysqlmpi_start.sh";
                File startScript2 = new File(startScriptExec);
                if (startScript2.exists()) {
                    try {
                        m_submitter.sendMessage(null, "MySQLMPI", "MySQLMPI", "Startup", "Starting MPI", "normal", null);
                        Process p = Runtime.getRuntime().exec("mysqlmpi_start.sh", null, new File(String.valueOf(m_mpiDir) + ".." + File.separator));
                        if (p == null) {
                            m_submitter.sendMessage(null, "MySQLMPI", "MySQLMPI", "Startup", "Error Starting MPI", "warning", null);
                        }
                        Thread.sleep(60000L);
                    }
                    catch (Throwable e) {
                        m_submitter.sendMessage(null, "MySQLMPI", "MySQLMPI", "Startup", "Error Starting MPI:" + e.getMessage(), "normal", null);
                    }
                } else {
                    m_submitter.sendMessage(null, "MySQLMPI", "MySQLMPI", "Startup", "No startup script found. Please start the MySQLMPI manually.", "minor", null);
                }
            }
        }
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_submitter = submitter;
    }

    public void stop() {
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
    }
}

