/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.dcom;

import com.blixx.dcom.NullMsgSubmitter;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIUnsignedByte;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;

public class REventLogListener
implements IMonitorExt,
Runnable {
    private static final String WMI_DEFAULT_NAMESPACE = "ROOT\\CIMV2";
    private boolean m_run = true;
    private List<Thread> m_listeners = new ArrayList<Thread>();
    final String QUERY_FOR_ALL_LOG_EVENTS = "SELECT * FROM __InstanceCreationEvent WHERE TargetInstance ISA 'Win32_NTLogEvent'";
    final int RETURN_IMMEDIATE = 16;
    final int FORWARD_ONLY = 32;
    static IMessage m_msgSubmitter = null;
    String m_host = null;
    String m_user = null;
    String m_password = null;
    String m_monitor = null;
    private SimpleDateFormat m_datetime = new SimpleDateFormat("yyyyMMddHHmmss");

    public static REventLogListener getInstance(String monitor, String[] parameters) {
        REventLogListener ll = new REventLogListener();
        int i = 0;
        while (i < parameters.length) {
            ll = new REventLogListener();
            ll.m_monitor = monitor;
            String[] prm = parameters[i].split("\\s+");
            ll.m_host = prm[0];
            ll.m_user = prm[1];
            ll.m_password = prm[2];
            Thread tr = new Thread(ll);
            tr.start();
            ll.m_listeners.add(tr);
            ++i;
        }
        return ll;
    }

    public void run() {
        IJIDispatch wbemLocator = null;
        try {
            try {
                wbemLocator = this.getWmiLocator(this.m_host, this.m_user, this.m_password);
                JIVariant[] results = wbemLocator.callMethodA("ConnectServer", new Object[]{new JIString(this.m_host), new JIString(WMI_DEFAULT_NAMESPACE), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), new Integer(0), JIVariant.OPTIONAL_PARAM()});
                IJIDispatch wbemServices = this.toIDispatch(results[0]);
                JIVariant[] eventSourceSet = wbemServices.callMethodA("ExecNotificationQuery", new Object[]{new JIString("SELECT * FROM __InstanceCreationEvent WHERE TargetInstance ISA 'Win32_NTLogEvent'"), new JIString("WQL"), new JIVariant((Object)new Integer(48))});
                IJIDispatch wbemEventSource = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)eventSourceSet[0].getObjectAsComObject());
                System.out.println("Listener started for " + this.m_host);
                while (this.m_run) {
                    JIVariant eventAsVariant = wbemEventSource.callMethodA("NextEvent", new Object[]{JIVariant.OPTIONAL_PARAM()})[0];
                    IJIDispatch wbemEvent = this.toIDispatch(eventAsVariant);
                    JIVariant f = wbemEvent.get("TargetInstance");
                    IJIDispatch event = this.toIDispatch(f);
                    HashMap<String, String> opts = new HashMap<String, String>();
                    String logfile = event.get("LogFile").getObjectAsString2();
                    String message = event.get("Message").getObjectAsString2();
                    String source = event.get("SourceName").getObjectAsString2();
                    opts.put("source", source);
                    int recnum = event.get("RecordNumber").getObjectAsInt();
                    opts.put("recn", "" + recnum);
                    int eventcode = event.get("EventCode").getObjectAsInt();
                    opts.put("code", "" + eventcode);
                    int eventtype = ((JIUnsignedByte)event.get("EventType").getObject()).getValue().intValue();
                    String tg = event.get("TimeGenerated").getObjectAsString2();
                    tg = tg.substring(0, tg.indexOf(46));
                    Date now = new Date();
                    try {
                        now = this.m_datetime.parse(tg);
                    }
                    catch (ParseException parseException) {
                        // empty catch block
                    }
                    opts.put("time", now.toString());
                    String severity = "normal";
                    switch (eventtype) {
                        case 1: {
                            severity = "critical";
                            break;
                        }
                        case 2: {
                            severity = "minor";
                            break;
                        }
                    }
                    opts.put("POLICY_NAME", this.m_monitor);
                    opts.put("host", this.m_host);
                    opts.put("winhost", this.m_host);
                    message = message.replace("\r\n\r\n", "\r\n");
                    m_msgSubmitter.sendMessage(this.m_host, "NTLog", logfile, source, message, severity, opts);
                }
            }
            catch (Throwable e) {
                if (this.m_run) {
                    m_msgSubmitter.sendMessage(this.m_host, "NTLog", null, null, "EventListener for host: " + this.m_host + " has been unexpectedly stopped\n" + e.getMessage(), "warning", null);
                }
                try {
                    JISession.destroySession((JISession)wbemLocator.getAssociatedSession());
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            try {
                JISession.destroySession((JISession)wbemLocator.getAssociatedSession());
            }
            catch (Throwable throwable) {}
        }
    }

    private IJIDispatch getWmiLocator(String host, String user, String password) throws Exception {
        JISystem.getLogger().setLevel(Level.OFF);
        try {
            JISystem.setInBuiltLogHandler((boolean)false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JISystem.setAutoRegisteration((boolean)true);
        JISession dcomSession = JISession.createSession((String)host, (String)user, (String)password);
        dcomSession.useSessionSecurity(true);
        JIComServer wbemLocatorComObj = new JIComServer(JIProgId.valueOf((String)"WbemScripting.SWbemLocator"), host, dcomSession);
        return (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)wbemLocatorComObj.createInstance().queryInterface("00020400-0000-0000-c000-000000000046"));
    }

    private IJIDispatch toIDispatch(JIVariant comObjectAsVariant) throws JIException {
        return (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)comObjectAsVariant.getObjectAsComObject());
    }

    public void setInterval(long ms) {
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
    }

    public String runMonitor() {
        return String.valueOf(this.m_monitor) + "=0";
    }

    public void setMessageSubmitter(IMessage submitter) {
        m_msgSubmitter = submitter;
    }

    public void stop() {
        this.m_run = false;
        int i = 0;
        while (i < this.m_listeners.size()) {
            try {
                this.m_listeners.get(i).interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        this.m_listeners.clear();
    }

    public static void main(String[] args) {
        REventLogListener rl = REventLogListener.getInstance("mon", new String[]{"blixx22 administrator blixx22", "blixx26 administrator blixx26"});
        rl.setMessageSubmitter(new NullMsgSubmitter());
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        rl.stop();
        System.out.println("Exit?");
    }
}

