/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.dcom;

import com.blixx.dcom.WMIField;
import com.blixx.dcom.WinOSPerf;
import com.blixx.ext.IPerfMetric;
import com.blixx.ext.PerfDoubleMetric;
import com.blixx.ext.PerfStringMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMIClass {
    public Map<String, Double> m_cachedCounters = new HashMap<String, Double>();
    public String m_name = null;
    public String m_perfname = null;
    public boolean m_isPerformanceClass = false;
    public Map<String, List<String>> m_instances = new HashMap<String, List<String>>();
    public LinkedHashMap<String, WMIField> m_fields = new LinkedHashMap();
    public WinOSPerf m_parent = null;

    public WMIClass(String name, String perfname, WinOSPerf parent) {
        this.m_name = name;
        this.m_perfname = perfname != null && perfname.length() > 0 ? perfname.replaceAll("[\\W]", "") : this.m_name.replaceAll("[\\W]", "");
        this.m_parent = parent;
    }

    public void addInstance(String field, String instances) {
        if (instances != null && instances.length() > 0) {
            String[] arr = null;
            arr = instances.indexOf(34) == -1 ? instances.split("\\s*,\\s*") : instances.split("(?<=\")\\s*,\\s*(?=\")");
            ArrayList<String> masks = new ArrayList<String>();
            int i = 0;
            while (i < arr.length) {
                String iname = arr[i];
                if (iname.startsWith("\"")) {
                    iname = iname.substring(1);
                }
                if (iname.endsWith("\"")) {
                    iname = iname.substring(0, iname.length() - 1);
                }
                masks.add(iname);
                ++i;
            }
            if (masks.size() > 0) {
                this.m_instances.put(field, masks);
            }
        }
    }

    public void addField(WMIField field) {
        if (field.isPerf()) {
            this.m_isPerformanceClass = true;
        }
        this.m_fields.put(field.getWmiName(), field);
    }

    public WMIField getField(String name) {
        return this.m_fields.get(name);
    }

    public ArrayList<IPerfMetric> processInstance(String host, Map<String, Object> values) {
        ArrayList<IPerfMetric> perf = new ArrayList<IPerfMetric>();
        String instance = (String)values.remove("Name");
        HashMap<String, String> opts = new HashMap<String, String>();
        opts.put("host", host);
        opts.put("winhost", host);
        perf.add((IPerfMetric)new PerfStringMetric("HOST", host));
        perf.add((IPerfMetric)new PerfStringMetric("INSTANCE", instance == null ? "-" : instance));
        for (String name : values.keySet()) {
            WMIField field = this.getField(name);
            if (field == null) continue;
            double valDbl = -1.0;
            Object val = values.get(name);
            if (val != null) {
                try {
                    valDbl = Double.parseDouble(val.toString());
                    if (field.getType() != 0) {
                        String key = String.valueOf(field.getWmiName()) + " " + instance;
                        Double prev = this.m_cachedCounters.get(key);
                        if (prev == null) {
                            this.m_cachedCounters.put(key, new Double(valDbl));
                            valDbl = 0.0;
                        } else {
                            this.m_cachedCounters.put(key, new Double(valDbl));
                            valDbl -= prev.doubleValue();
                            valDbl /= (double)(this.m_parent.m_interval / 1000L);
                            switch (field.getType()) {
                                case 4: {
                                    break;
                                }
                                case 2: {
                                    valDbl /= 1048576.0;
                                    break;
                                }
                                case 3: {
                                    valDbl /= 1024.0;
                                    break;
                                }
                                default: {
                                    break;
                                }
                            }
                        }
                    }
                }
                catch (Throwable key) {
                    // empty catch block
                }
            }
            boolean instanceMatches = this.isInstanceMatches(field.getWmiName(), instance);
            if (this.m_parent.m_monSubmitter != null && field.getMonitorName() != null && instanceMatches) {
                this.m_parent.m_monSubmitter.submitMonitorValue(field.getMonitorName(), valDbl, instance, opts);
            }
            if (!field.isPerf()) continue;
            if (!instanceMatches) {
                valDbl = -1.0;
            }
            perf.add((IPerfMetric)new PerfDoubleMetric(field.getPerfName(), valDbl));
        }
        if (!this.m_isPerformanceClass) {
            perf = null;
        }
        return perf;
    }

    public boolean isInstanceMatches(String fieldname, String iname) {
        boolean matches = false;
        List<String> masks = this.m_instances.get(fieldname);
        if (masks == null || masks.size() == 0) {
            return true;
        }
        Iterator<String> it = masks.iterator();
        while (it.hasNext()) {
            boolean isMatched = false;
            boolean negation = false;
            String pattern = it.next();
            if (pattern.startsWith("!")) {
                negation = true;
                pattern = pattern.substring(1);
            }
            String ptrn = pattern.toLowerCase();
            if (pattern.startsWith("*")) {
                ptrn = ptrn.substring(1);
                if (pattern.endsWith("*")) {
                    ptrn = ptrn.substring(0, ptrn.length() - 1);
                    isMatched = iname.toLowerCase().contains(ptrn);
                } else {
                    isMatched = iname.toLowerCase().contains(ptrn);
                }
            } else if (pattern.endsWith("*")) {
                ptrn = ptrn.substring(0, ptrn.length() - 1);
                isMatched = iname.toLowerCase().startsWith(ptrn);
            } else {
                isMatched = pattern.equalsIgnoreCase(iname);
            }
            if (isMatched) {
                return !negation;
            }
            if (it.hasNext() || !negation || isMatched) continue;
            matches = true;
        }
        return matches;
    }

    public String getWmiClassName() {
        return this.m_name;
    }

    public String getPerfClassName() {
        return this.m_perfname;
    }
}

