/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.dcom;

import com.blixx.dcom.WMIClass;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import com.blixx.ext.IPerfMetric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JIComServer;
import org.jinterop.dcom.core.JIProgId;
import org.jinterop.dcom.core.JISession;
import org.jinterop.dcom.core.JIString;
import org.jinterop.dcom.core.JIVariant;
import org.jinterop.dcom.impls.JIObjectFactory;
import org.jinterop.dcom.impls.automation.IJIDispatch;
import org.jinterop.dcom.impls.automation.IJIEnumVariant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WMIWorker
implements Runnable {
    private static final String WMI_DEFAULT_NAMESPACE = "ROOT\\CIMV2";
    private static final int RETURN_IMMEDIATE = 16;
    private static final int FORWARD_ONLY = 32;
    String m_host = null;
    String m_user = null;
    String m_password = null;
    List<WMIClass> m_classes = null;
    IMonitorSubmitter m_monSubmitter = null;
    IPerfLog m_perfSubmitter = null;
    IMessage m_msgSubmitter = null;
    private JISession dcomSession;
    public boolean m_isFinished = true;

    public WMIWorker(String host, String user, String pass, List<WMIClass> classes, IMonitorSubmitter monSubmitter, IPerfLog perfSubmitter, IMessage msgSubmitter) {
        this.m_host = host;
        this.m_user = user;
        this.m_password = pass;
        this.m_classes = classes;
        this.m_monSubmitter = monSubmitter;
        this.m_perfSubmitter = perfSubmitter;
        this.m_msgSubmitter = msgSubmitter;
        JISystem.getLogger().setLevel(Level.OFF);
        try {
            JISystem.setInBuiltLogHandler((boolean)false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        JISystem.setAutoRegisteration((boolean)true);
    }

    @Override
    public void run() {
        try {
            try {
                this.m_isFinished = false;
                IJIDispatch wbemLocator = this.getWmiLocator(this.m_host, this.m_user, this.m_password);
                JIVariant[] res = wbemLocator.callMethodA("ConnectServer", new Object[]{new JIString(this.m_host), new JIString(WMI_DEFAULT_NAMESPACE), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), new Integer(0), JIVariant.OPTIONAL_PARAM()});
                IJIDispatch wbemServices = this.toIDispatch(res[0]);
                int i = 0;
                while (i < this.m_classes.size()) {
                    try {
                        this.processClasses(wbemServices, this.m_classes.get(i));
                    }
                    catch (Exception e) {
                        this.m_msgSubmitter.sendMessage(null, "JRWIN_MPI", "MONITOR", this.m_host, "Class: " + this.m_classes.get(i).getWmiClassName() + " Error: " + e.getMessage(), "warning", null);
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                this.m_msgSubmitter.sendMessage(null, "JRWIN_MPI", "MONITOR", this.m_host, "Error: " + e.getMessage(), "warning", null);
                this.m_isFinished = true;
                try {
                    JISession.destroySession((JISession)this.dcomSession);
                }
                catch (Throwable throwable) {}
            }
        }
        finally {
            this.m_isFinished = true;
            try {
                JISession.destroySession((JISession)this.dcomSession);
            }
            catch (Throwable throwable) {}
        }
    }

    private void processClasses(IJIDispatch wbemServices, WMIClass wmiClass) throws JIException {
        JIVariant cv;
        JIVariant[] results = wbemServices.callMethodA("ExecQuery", new Object[]{new JIString("Select * from " + wmiClass.getWmiClassName()), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM(), JIVariant.OPTIONAL_PARAM()});
        IJIDispatch objectSet = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)results[0].getObjectAsComObject());
        try {
            cv = objectSet.get("Count");
        }
        catch (Throwable e) {
            this.m_msgSubmitter.sendMessage(null, "JRWIN_MPI", "MONITOR", this.m_host, "Class \"" + wmiClass.getWmiClassName() + "\" not available on the host: " + this.m_host, "warning", null);
            return;
        }
        int count = cv.getObjectAsInt();
        IJIComObject enumComObject = objectSet.get("_NewEnum").getObjectAsComObject();
        IJIEnumVariant enumVariant = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)enumComObject.queryInterface("00020404-0000-0000-C000-000000000046"));
        IJIDispatch wbemObject_dispatch = null;
        int i = 0;
        while (i < count) {
            Object[] values = enumVariant.next(1);
            JIArray array = (JIArray)values[0];
            Object[] arrayObj = (Object[])array.getArrayInstance();
            int j = 0;
            while (j < arrayObj.length) {
                wbemObject_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[j]).getObjectAsComObject());
                IJIComObject propsSetComObject = wbemObject_dispatch.get("Properties_").getObjectAsComObject();
                IJIDispatch propSet = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)propsSetComObject);
                Map<String, Object> props = this.getProps(propSet);
                ArrayList<IPerfMetric> perfs = wmiClass.processInstance(this.m_host, props);
                if (this.m_perfSubmitter != null && perfs != null) {
                    boolean isSubmit = false;
                    int k = 0;
                    while (k < perfs.size()) {
                        Double d;
                        if (perfs.get(k).getType() == "DOUBLE" && (d = (Double)perfs.get(k).getValue()) != -1.0) {
                            isSubmit = true;
                            break;
                        }
                        ++k;
                    }
                    if (isSubmit) {
                        this.m_perfSubmitter.submitPerfRow(wmiClass.getPerfClassName(), System.currentTimeMillis(), perfs);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public Map<String, Object> getProps(IJIDispatch propSet) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        try {
            IJIComObject enumComObject = propSet.get("_NewEnum").getObjectAsComObject();
            IJIEnumVariant enumVariant = (IJIEnumVariant)JIObjectFactory.narrowObject((IJIComObject)enumComObject.queryInterface("00020404-0000-0000-C000-000000000046"));
            JIVariant cv = propSet.get("Count");
            int count = cv.getObjectAsInt();
            IJIDispatch wbemProperty_dispatch = null;
            int i = 0;
            while (i < count) {
                Object[] values = enumVariant.next(1);
                JIArray array = (JIArray)values[0];
                Object[] arrayObj = (Object[])array.getArrayInstance();
                int j = 0;
                while (j < arrayObj.length) {
                    try {
                        wbemProperty_dispatch = (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)((JIVariant)arrayObj[j]).getObjectAsComObject());
                        JIVariant nameV = wbemProperty_dispatch.get("Name");
                        String name = nameV.getObjectAsString2();
                        JIVariant valueV = wbemProperty_dispatch.get("Value");
                        Object value = WMIWorker.convertToNativeType(valueV);
                        props.put(name, value);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (JIException jIException) {
            // empty catch block
        }
        return props;
    }

    private IJIDispatch getWmiLocator(String host, String user, String password) throws Exception {
        String domain = host;
        int ds = user.indexOf(92);
        if (ds != -1) {
            domain = user.substring(0, ds);
            user = user.substring(ds + 1);
        }
        this.dcomSession = JISession.createSession((String)domain, (String)user, (String)password);
        this.dcomSession.useSessionSecurity(true);
        JIComServer wbemLocatorComObj = new JIComServer(JIProgId.valueOf((String)"WbemScripting.SWbemLocator"), host, this.dcomSession);
        return (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)wbemLocatorComObj.createInstance().queryInterface("00020400-0000-0000-c000-000000000046"));
    }

    private IJIDispatch toIDispatch(JIVariant comObjectAsVariant) throws JIException {
        return (IJIDispatch)JIObjectFactory.narrowObject((IJIComObject)comObjectAsVariant.getObjectAsComObject());
    }

    private static Object convertToNativeType(JIVariant type) throws JIException {
        if (type.isArray()) {
            Object[] array;
            ArrayList<Object> objs = new ArrayList<Object>();
            Object[] objectArray = array = (Object[])type.getObjectAsArray().getArrayInstance();
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                objs.add(WMIWorker.convertToNativeType((JIVariant)element));
                ++n2;
            }
            return objs;
        }
        switch (type.getType()) {
            case 1: {
                return null;
            }
            case 8: {
                return type.getObjectAsString().getString();
            }
            case 2: {
                return type.getObjectAsShort();
            }
            case 3: {
                return type.getObjectAsInt();
            }
            case 17: {
                return type.getObjectAsUnsigned().getValue();
            }
            case 11: {
                return type.getObjectAsBoolean();
            }
            case 14: {
                return Float.valueOf(type.getObjectAsFloat());
            }
            case 7: {
                return type.getObjectAsDate();
            }
        }
        return type.getObject();
    }
}

