/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.dcom;

import com.blixx.dcom.NullMonSubmitter;
import com.blixx.dcom.NullMsgSubmitter;
import com.blixx.dcom.NullPerfSubmitter;
import com.blixx.dcom.WMIClass;
import com.blixx.dcom.WMIField;
import com.blixx.dcom.WMIWorker;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExtPerf;
import com.blixx.ext.IMonitorSubmitter;
import com.blixx.ext.IPerfLog;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WinOSPerf
implements IMonitorExtPerf {
    IPerfLog m_perfLog = null;
    IMonitorSubmitter m_monSubmitter = null;
    IMessage m_msgSubmitter = null;
    long m_interval = 0L;
    String m_propFile = null;
    String m_monitor = null;
    String[] m_parameters = null;
    boolean m_run = true;
    HashMap<String, WMIClass> m_classes = new HashMap();
    List<WMIWorker> threads = new ArrayList<WMIWorker>();

    public static WinOSPerf getInstance(String monitor, String[] parameters) {
        WinOSPerf instance = new WinOSPerf();
        instance.m_monitor = monitor;
        instance.m_propFile = parameters[0];
        instance.m_parameters = parameters;
        try {
            instance.loadConfigFile(instance.m_propFile);
        }
        catch (FileNotFoundException e) {
            RuntimeException rte = new RuntimeException("Config file not found. " + instance.m_propFile);
            rte.setStackTrace(e.getStackTrace());
            throw rte;
        }
        return instance;
    }

    public void setPerfSubmitter(IPerfLog submitter) {
        this.m_perfLog = submitter;
        ArrayList<WMIClass> classes = new ArrayList<WMIClass>(this.m_classes.values());
        int i = 1;
        while (i < this.m_parameters.length) {
            String[] prm = this.m_parameters[i].split("\\s+");
            WMIWorker worker = new WMIWorker(prm[0], prm[1], prm[2], classes, this.m_monSubmitter, this.m_perfLog, this.m_msgSubmitter);
            this.threads.add(worker);
            ++i;
        }
    }

    public void setInterval(long ms) {
        this.m_interval = ms;
    }

    public void setMonitorSubmitter(IMonitorSubmitter submitter) {
        this.m_monSubmitter = submitter;
    }

    public String runMonitor() {
        int i = 0;
        while (i < this.threads.size()) {
            WMIWorker worker = this.threads.get(i);
            if (worker.m_isFinished) {
                try {
                    Thread tr = new Thread(worker);
                    tr.start();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            ++i;
        }
        return String.valueOf(this.m_monitor) + "=0";
    }

    public void setMessageSubmitter(IMessage submitter) {
        this.m_msgSubmitter = submitter;
    }

    public void stop() {
        this.m_run = false;
    }

    public void loadConfigFile(String filename) throws FileNotFoundException {
        File props = new File(filename);
        FileReader fr = new FileReader(props);
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                this.parseLine(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading property file: " + filename);
        }
    }

    public void parseLine(String line) {
        if ((line = line.trim()).length() < 17 || line.startsWith("#")) {
            return;
        }
        String[] arr = line.split("[|]");
        if (arr.length < 5) {
            return;
        }
        WMIClass cl = null;
        String className = null;
        String wminame = null;
        String monname = null;
        int type = 0;
        boolean perf = false;
        String perfname = null;
        int i = 0;
        while (i < arr.length) {
            String curr = arr[i].trim();
            switch (i) {
                case 0: {
                    className = curr;
                    String perfclass = null;
                    int p0 = curr.indexOf(61);
                    if (p0 != -1) {
                        className = curr.substring(0, p0);
                        perfclass = curr.substring(p0 + 1);
                    }
                    if ((cl = this.m_classes.get(className)) != null) break;
                    cl = new WMIClass(className, perfclass, this);
                    this.m_classes.put(className, cl);
                    break;
                }
                case 1: {
                    wminame = curr;
                    break;
                }
                case 2: {
                    if (curr.length() == 0) {
                        monname = null;
                        break;
                    }
                    monname = curr;
                    break;
                }
                case 3: {
                    String typeStr = curr;
                    int eqi = typeStr.indexOf(61);
                    if (eqi != -1) {
                        typeStr = curr.substring(0, eqi).trim();
                        String masks = curr.substring(eqi + 1).trim();
                        cl.addInstance(wminame, masks);
                    }
                    if (typeStr.equalsIgnoreCase("COUNTER")) {
                        type = 1;
                        break;
                    }
                    if (typeStr.equalsIgnoreCase("RAW_SEC")) {
                        type = 4;
                        break;
                    }
                    if (typeStr.equalsIgnoreCase("RAW_BPS")) {
                        type = 2;
                        break;
                    }
                    if (typeStr.equalsIgnoreCase("RAW_KBPS")) {
                        type = 3;
                        break;
                    }
                    type = 0;
                    break;
                }
                case 4: {
                    String perfStr = curr;
                    int eqi2 = curr.indexOf(61);
                    if (eqi2 != -1) {
                        perfname = curr.substring(eqi2 + 1).trim();
                        perfStr = curr.substring(0, eqi2);
                    }
                    if (perfStr.equalsIgnoreCase("PERF")) {
                        perf = true;
                        break;
                    }
                    perf = false;
                    break;
                }
            }
            ++i;
        }
        cl.addField(new WMIField(wminame, monname, type, perf, perfname));
    }

    public static void main(String[] args) {
        String[] pr = new String[]{"JavaWinOSPerf.props", "musya2 administrator Markaba99", "blixxnb5 blixxnb5\\administrator blixxnb5"};
        WinOSPerf wop = WinOSPerf.getInstance("NNN", pr);
        wop.setMessageSubmitter(new NullMsgSubmitter());
        wop.setInterval(10000L);
        wop.setMonitorSubmitter(new NullMonSubmitter());
        wop.setPerfSubmitter(new NullPerfSubmitter());
        while (wop.m_run) {
            wop.runMonitor();
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

