/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi;

import com.blixx.esxi.command.AbstractMonitor;
import com.blixx.esxi.command.Command;
import com.blixx.esxi.command.CommandFactory;
import com.blixx.esxi.connection.ConnectionAttributes;
import com.blixx.esxi.connection.EsxiConnection;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.monitor.MultiColMonSubmitter;
import com.blixx.esxi.options.CommandLineAnalyser;
import com.blixx.esxi.types.CLIOpts;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.types.MonitorType;
import com.blixx.esxi.types.Operation;
import com.blixx.esxi.types.Severity;
import com.blixx.esxi.utils.PropertyReader;
import com.blixx.esxi.utils.StringUtils;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IAction;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorExt;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.ComputeResourceSummary;
import com.vmware.vim25.HostListSummaryQuickStats;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.VirtualMachineSummary;
import com.vmware.vim25.mo.ClusterComputeResource;
import com.vmware.vim25.mo.ComputeResource;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.PerformanceManager;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsxiTop
implements IAction,
IMonitorExt {
    public static final Logger logger = LoggerFactory.getLogger(EsxiTop.class);
    private String currentWorkDir = ".";
    private IMessage m_msgSubmit;
    private IMonitorSubmitter m_monSubmit;
    private String m_monitor;
    private long m_interval;
    private CommandLineAnalyser analyser;
    private ConnectionAttributes m_attrs;
    private EsxiConnection connection;
    private AtomicBoolean m_instanceInitialised = new AtomicBoolean(false);
    private String m_esxiHost;
    private Command m_command;
    public static final String APPLICATION = "ESXiTop";
    private String m_ret;
    private ServiceInstance m_si;

    public static void main(String[] args) {
        EsxiTop t = new EsxiTop();
        System.out.println(t.run(args, 0));
    }

    public static EsxiTop getInstance(String monitor, String[] args) {
        logger.info("Create EsxiTop instance for monitor " + monitor);
        args = StringUtils.trimArgs(args);
        if (logger.isDebugEnabled()) {
            StringUtils.printArgsAsDebug(args, logger);
        }
        return new EsxiTop(monitor, args);
    }

    public EsxiTop(String monitor, String[] args) {
        this.m_monitor = monitor;
        this.m_ret = this.m_monitor + "=0";
        Properties props = PropertyReader.init(args, this.currentWorkDir);
        this.analyser = new CommandLineAnalyser(args, props);
    }

    public EsxiTop() {
    }

    public String run(String[] parameters, int timeout) {
        Properties props = PropertyReader.init(parameters, this.currentWorkDir);
        String result = null;
        if (logger.isDebugEnabled()) {
            int len = parameters != null ? parameters.length : 0;
            logger.debug("Action called with " + len + " args: ");
            StringUtils.printArgsAsDebug(parameters, logger);
        }
        StringWriter str = new StringWriter();
        PrintWriter pw = new PrintWriter(str);
        this.analyser = new CommandLineAnalyser(parameters, props);
        if (!this.analyser.analyseOptions(pw)) {
            return str.toString();
        }
        this.m_attrs = this.analyser.getConnectionAttributes();
        this.connection = new EsxiConnection(this.analyser.getConnectionAttributes());
        Operation op = this.analyser.getOperation();
        try {
            this.m_si = this.connection.connect();
        }
        catch (EsxiTopException e) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(bos);
            ps.append("Connection failed. ");
            ps.append(e.getMessage() + "\n");
            e.printStackTrace(ps);
            result = bos.toString();
            return result;
        }
        if (op != null) {
            switch (op) {
                case PERFORMANCE_INFO: {
                    result = this.getPerformanceInfo();
                    break;
                }
                case MONITOR: {
                    try {
                        String key = this.analyser.getAttributeValue(CLIOpts.MONITOR_NAME);
                        String type = this.analyser.getAttributeValue(CLIOpts.MONITOR_TYPE);
                        String aggregatedStr = this.analyser.getAttributeValue(CLIOpts.ALL_INSTANCES);
                        Boolean allInstances = aggregatedStr != null ? Boolean.valueOf(aggregatedStr) : null;
                        boolean print_refresh_rate = Arrays.asList(this.analyser.getArgs()).contains("-prr");
                        MultiColMonSubmitter mon = new MultiColMonSubmitter();
                        CommandFactory factory = new CommandFactory(null, mon);
                        Command cmd = factory.createCommand(this.m_si, this.m_attrs.getEntityName(), this.m_attrs.getEntityType(), MonitorType.get(type), key, "ActionMonitor", allInstances);
                        cmd.execute();
                        if (print_refresh_rate && cmd instanceof AbstractMonitor) {
                            result = mon.toResult("refresh_rate=" + ((AbstractMonitor)((Object)cmd)).getRefreshRateSeconds() + "sec");
                            break;
                        }
                        result = mon.toResult(null);
                    }
                    catch (Throwable e) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(bos);
                        ps.append(e.getMessage() + "\n");
                        e.printStackTrace(ps);
                        result = bos.toString();
                    }
                    break;
                }
                case LISTVMS: {
                    try {
                        String format = "%-50s|%-50s|%-20s|%-25s|%-20s\n";
                        StringBuilder builder = new StringBuilder(String.format(format, "VM-Name", "HostSystem", "PowerStatus", "Guest Heartbeat Status", "Tool Status"));
                        builder.append(String.format(format, "-", "-", "-", "-", "-"));
                        ManagedEntity[] entities = Utils.determineManagedEntities(this.m_si, "VirtualMachine", null);
                        if (entities != null) {
                            for (ManagedEntity entity : entities) {
                                if (!(entity instanceof VirtualMachine)) continue;
                                VirtualMachine vm = (VirtualMachine)entity;
                                VirtualMachineSummary sum = vm.getSummary();
                                VirtualMachineRuntimeInfo runtime = vm.getRuntime();
                                ManagedObjectReference hmor = runtime.getHost();
                                HostSystem host = new HostSystem(vm.getServerConnection(), hmor);
                                builder.append(String.format(format, vm.getName(), host.getName(), runtime.getPowerState().name(), sum.getQuickStats().getGuestHeartbeatStatus().name(), sum.getGuest().getToolsStatus().name()));
                            }
                        }
                        result = builder.toString();
                    }
                    catch (Throwable e) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(bos);
                        ps.append(e.getMessage() + "\n");
                        e.printStackTrace(ps);
                        result = bos.toString();
                    }
                    break;
                }
                case LISTHOSTS: {
                    try {
                        String format = "%-50s|%-20s\n";
                        StringBuilder builder = new StringBuilder(String.format(format, "HostSystem", "PowerStatus"));
                        builder.append(String.format(format, "-", "-"));
                        ManagedEntity[] entities = Utils.determineManagedEntities(this.m_si, "HostSystem", null);
                        if (entities != null) {
                            for (ManagedEntity entity : entities) {
                                if (!(entity instanceof HostSystem)) continue;
                                HostSystem hs = (HostSystem)entity;
                                HostRuntimeInfo runtime = hs.getRuntime();
                                builder.append(String.format(format, hs.getName(), runtime.getPowerState().name()));
                            }
                        }
                        result = builder.toString();
                    }
                    catch (EsxiTopException e) {
                        ByteArrayOutputStream bos = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream(bos);
                        ps.append(e.getMessage() + "\n");
                        e.printStackTrace(ps);
                        result = bos.toString();
                    }
                    break;
                }
                case CLUSTER_INFO: {
                    StringBuilder sb = this.getClustersInfo();
                    result = sb.toString();
                    break;
                }
                default: {
                    result = "no operation selected";
                    break;
                }
            }
        } else {
            result = this.analyser.getBasicHelpText("Operation missing");
        }
        this.connection.disconnect();
        return result;
    }

    public StringBuilder getClustersInfo() {
        StringBuilder sb = new StringBuilder();
        try {
            ManagedEntity[] arr;
            for (ManagedEntity me : arr = Utils.determineEntities(this.m_si, "ClusterComputeResource")) {
                if (me instanceof ComputeResource) {
                    ClusterComputeResource cr = (ClusterComputeResource)me;
                    sb.append("Cluster: ").append(cr.getName()).append('\n');
                    sb.append('[').append(cr.getName()).append(']').append(" Status: ").append(cr.getOverallStatus()).append('\n');
                    sb.append('[').append(cr.getName()).append(']').append(" Hosts: ");
                    long usedMem = 0L;
                    long usedCPU = 0L;
                    int cpuFairness = 0;
                    int memFairness = 0;
                    int vmTotal = 0;
                    int vmRunning = 0;
                    int hostCountOnline = 0;
                    int hostL = cr.getHosts().length;
                    for (int i = 0; i < hostL; ++i) {
                        try {
                            HostSystem hs = cr.getHosts()[i];
                            sb.append(hs.getName());
                            HostListSummaryQuickStats quickStats = hs.getSummary().getQuickStats();
                            usedCPU += (long)quickStats.getOverallCpuUsage().intValue();
                            usedMem += (long)quickStats.getOverallMemoryUsage().intValue();
                            cpuFairness += quickStats.getDistributedCpuFairness().intValue();
                            memFairness += quickStats.getDistributedMemoryFairness().intValue();
                            ++hostCountOnline;
                            try {
                                VirtualMachine[] vmList = hs.getVms();
                                vmTotal += vmList.length;
                                for (VirtualMachine vm : vmList) {
                                    if (vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOff) continue;
                                    ++vmRunning;
                                }
                                continue;
                            }
                            catch (Throwable vmList) {
                                continue;
                            }
                        }
                        catch (Throwable hs) {
                            // empty catch block
                        }
                    }
                    sb.append('\n');
                    cpuFairness /= hostCountOnline;
                    memFairness /= hostCountOnline;
                    sb.append('[').append(cr.getName()).append(']').append(" VMs Running/Total: ").append(vmRunning).append('/').append(vmTotal).append("\n");
                    ComputeResourceSummary crs = cr.getSummary();
                    sb.append('[').append(cr.getName()).append(']').append(" CPU Used/Effective: ").append(usedCPU).append('/').append(crs.getTotalCpu()).append(" MHz (").append(usedCPU * 100L / (long)crs.getTotalCpu()).append("%)\n");
                    long tmem = crs.getTotalMemory() / 0x100000L;
                    sb.append('[').append(cr.getName()).append(']').append(" Memory Used/Effective: ").append(usedMem).append('/').append(tmem).append(" MB (").append(usedMem * 100L / tmem).append("%)\n");
                    long freeDiskSpace = 0L;
                    long capacityDiskSpace = 0L;
                    for (int i = 0; i < cr.getDatastores().length; ++i) {
                        Datastore ds = cr.getDatastores()[i];
                        freeDiskSpace += ds.getSummary().getFreeSpace();
                        capacityDiskSpace += ds.getSummary().getCapacity();
                    }
                    long usedDiskSpace = (capacityDiskSpace /= 0x40000000L) - (freeDiskSpace /= 0x40000000L);
                    sb.append('[').append(cr.getName()).append(']').append(" Disks Used/Effective: ").append(usedDiskSpace).append('/').append(capacityDiskSpace).append(" GB (").append(usedDiskSpace * 100L / capacityDiskSpace).append("%)\n");
                    sb.append('[').append(cr.getName()).append(']').append(" Hosts Effective/Total: ").append(crs.getNumEffectiveHosts()).append('/').append(crs.getNumHosts()).append('\n');
                    sb.append('[').append(cr.getName()).append(']').append(" OverheadMemory: ").append(cr.getResourcePool().getSummary().getQuickStats().getOverheadMemory()).append(" MB").append('\n');
                    sb.append('[').append(cr.getName()).append(']').append(" ConsumedOverheadMemory: ").append(cr.getResourcePool().getSummary().getQuickStats().getConsumedOverheadMemory()).append(" MB").append('\n');
                    sb.append('[').append(cr.getName()).append(']').append(" SwappedMemory: ").append(cr.getResourcePool().getSummary().getQuickStats().getSwappedMemory()).append(" MB").append('\n');
                    sb.append('[').append(cr.getName()).append(']').append(" BalloonedMemory: ").append(cr.getResourcePool().getSummary().getQuickStats().getBalloonedMemory()).append(" MB").append('\n');
                    sb.append('[').append(cr.getName()).append(']').append(" CpuFairness: ").append(cpuFairness).append('\n');
                    sb.append('[').append(cr.getName()).append(']').append(" MemoryFairness: ").append(memFairness).append('\n');
                }
                sb.append("\n");
            }
        }
        catch (Throwable e1) {
            sb.append("Error: ").append(e1.getMessage() == null ? e1.getClass().toString() : e1.getMessage());
        }
        return sb;
    }

    private void printCCRStats(ClusterComputeResource cr) {
        System.out.println("GuestMemoryUsage " + cr.getResourcePool().getSummary().getQuickStats().getGuestMemoryUsage());
        System.out.println("HostMemoryUsage " + cr.getResourcePool().getSummary().getQuickStats().getHostMemoryUsage());
        System.out.println("OverallCpuUsage() " + cr.getResourcePool().getSummary().getQuickStats().getOverallCpuUsage());
        System.out.println("DynamicType " + cr.getResourcePool().getSummary().getQuickStats().getDynamicType());
        System.out.println("BalloonedMemory " + cr.getResourcePool().getSummary().getQuickStats().getBalloonedMemory());
        System.out.println("CompressedMemory() " + cr.getResourcePool().getSummary().getQuickStats().getCompressedMemory());
        System.out.println("ConsumedOverheadMemory() " + cr.getResourcePool().getSummary().getQuickStats().getConsumedOverheadMemory());
        System.out.println("DistributedCpuEntitlement() " + cr.getResourcePool().getSummary().getQuickStats().getDistributedCpuEntitlement());
        System.out.println("DistributedMemoryEntitlement() " + cr.getResourcePool().getSummary().getQuickStats().getDistributedMemoryEntitlement());
        System.out.println("OverallCpuDemand() " + cr.getResourcePool().getSummary().getQuickStats().getOverallCpuDemand());
        System.out.println("OverheadMemory() " + cr.getResourcePool().getSummary().getQuickStats().getOverheadMemory());
        System.out.println("PrivateMemory() " + cr.getResourcePool().getSummary().getQuickStats().getPrivateMemory());
        System.out.println("SharedMemory() " + cr.getResourcePool().getSummary().getQuickStats().getSharedMemory());
        System.out.println("StaticCpuEntitlement() " + cr.getResourcePool().getSummary().getQuickStats().getStaticCpuEntitlement());
        System.out.println("StaticMemoryEntitlement() " + cr.getResourcePool().getSummary().getQuickStats().getStaticMemoryEntitlement());
        System.out.println("SwappedMemory()() " + cr.getResourcePool().getSummary().getQuickStats().getSwappedMemory());
    }

    public String runMonitor() {
        if (!this.m_instanceInitialised.get()) {
            StringWriter str = new StringWriter();
            PrintWriter pw = new PrintWriter(str);
            if (this.analyser.analyseOptions(pw)) {
                this.m_attrs = this.analyser.getConnectionAttributes();
                this.m_esxiHost = this.m_attrs.getHostname();
                try {
                    this.connection = new EsxiConnection(this.m_attrs);
                    this.m_si = this.connection.connect();
                }
                catch (EsxiTopException e) {
                    logger.error("Could not connect: ", (Throwable)e);
                    this.m_msgSubmit.sendMessage(null, APPLICATION, "ESXi", this.m_monitor, "Could not initialise reason: " + e.getMessage(), Severity.CRITICAL.getValue(), null);
                    this.connection.disconnect();
                    return this.m_ret;
                }
                try {
                    logger.info("Create monitor for policy: " + this.m_monitor + " for managed entity " + this.m_attrs.getEntityName() + "and entity type: " + this.m_attrs.getEntityType());
                    CommandFactory factory = new CommandFactory(this.m_msgSubmit, this.m_monSubmit);
                    String allInstancesStr = this.analyser.getAttributeValue(CLIOpts.ALL_INSTANCES);
                    Boolean allInst = allInstancesStr != null ? Boolean.valueOf(allInstancesStr) : null;
                    this.m_command = factory.createCommand(this.m_si, this.m_attrs.getEntityName(), this.m_attrs.getEntityType(), MonitorType.get(this.analyser.getAttributeValue(CLIOpts.MONITOR_TYPE)), this.analyser.getAttributeValue(CLIOpts.MONITOR_NAME), this.m_monitor, allInst);
                    if (this.m_command == null) {
                        logger.error("No command to execute");
                        throw new EsxiTopException("No command to execute");
                    }
                    this.m_instanceInitialised.set(true);
                }
                catch (EsxiTopException e) {
                    logger.error("Could not create a monitor for policy: " + this.m_monitor + " managed entity " + this.m_attrs.getEntityName() + " type " + this.m_attrs.getEntityType(), (Throwable)e);
                    this.m_msgSubmit.sendMessage(null, APPLICATION, "ESXi", this.m_monitor, "Could not create a monitor for managed entity " + this.m_attrs.getEntityName() + " reason: " + e.getMessage(), Severity.CRITICAL.getValue(), null);
                    this.connection.disconnect();
                    return this.m_ret;
                }
            }
            this.m_msgSubmit.sendMessage(null, APPLICATION, "ESXi", this.m_monitor, str.toString(), Severity.CRITICAL.getValue(), null);
        }
        if (this.m_instanceInitialised.get()) {
            HashMap<Object, Object> map = this.generateOptionsMap();
            try {
                this.m_command.setOptions(map);
                this.m_command.execute();
            }
            catch (EsxiTopException e) {
                logger.error("Error getting last metric ", (Throwable)e);
                this.m_msgSubmit.sendMessage(null, APPLICATION, "ESXi", this.m_monitor, "Error getting last metric " + e.getCause() != null ? e.getCause().getMessage() : e.getMessage(), Severity.CRITICAL.getValue(), null);
            }
        }
        return this.m_ret;
    }

    private HashMap<Object, Object> generateOptionsMap() {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put(MessageOptions.USER.getValue(), this.m_attrs.getUser());
        map.put(MessageOptions.URL.getValue(), this.m_attrs.getUrlStr());
        return map;
    }

    public void stop() {
        if (this.m_instanceInitialised.compareAndSet(true, false)) {
            this.connection.disconnect();
            this.m_msgSubmit.sendMessage(null, APPLICATION, "ESXi", this.m_monitor, String.format("Successfully disconnect from ESXi host %s", this.m_esxiHost), Severity.NORMAL.getValue(), null);
        }
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }

    public void setMonitorSubmitter(IMonitorSubmitter monSubmitter) {
        this.m_monSubmit = monSubmitter;
    }

    public void setMessageSubmitter(IMessage messageSubmitter) {
        this.m_msgSubmit = messageSubmitter;
    }

    public String dispatchRequest() {
        return null;
    }

    public String getPerformanceInfo() {
        String format = "%-50s %s\n";
        String keyFormat = "%s.%s.%s";
        StringBuilder builder = new StringBuilder();
        PerformanceManager pm = this.m_si.getPerformanceManager();
        PerfCounterInfo[] perfinfo = pm.getPerfCounter();
        Object[] keys = new String[perfinfo.length];
        for (int i = 0; i < perfinfo.length; ++i) {
            String key = String.format(keyFormat, perfinfo[i].groupInfo.key, perfinfo[i].nameInfo.key, perfinfo[i].rollupType);
            keys[i] = String.format(format, key, perfinfo[i].getUnitInfo().getKey());
        }
        Arrays.sort(keys);
        for (Object key : keys) {
            builder.append((String)key);
        }
        return builder.toString();
    }
}

