/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.MonitorConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.utils.PerfGroupingUtils;
import com.blixx.esxi.utils.Utils;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfProviderSummary;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PerfSummaryType;
import com.vmware.vim25.mo.ManagedEntity;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractMonitor {
    private static final int GROUP_NAME_STATS = 3;
    private static final int GROUP_NAME = 2;
    public static final String AGGREGATED_STATISTICS = "";
    public static final String ALL_INSTANCES_STATISTICS = "*";
    public static final int GROUP_INDEX = 0;
    public static final int METRIC_INDEX = 1;
    public static final int STATS_TYPE_INDEX = 2;
    private static final Logger logger = LoggerFactory.getLogger(AbstractMonitor.class);
    public DateFormat SAMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final Set<String> allInstSet = new HashSet<String>();
    protected MonitorConfig m_config;
    protected int m_refresh;
    protected PerfQuerySpec[] m_spec;
    protected PerfCounterInfo[] m_info;
    protected Map<Integer, PerfCounterInfo> counterToInfo = new HashMap<Integer, PerfCounterInfo>();
    protected ManagedEntity[] m_me;
    protected boolean allInstances = false;

    public AbstractMonitor(MonitorConfig config) throws EsxiTopException {
        this.m_config = config;
        this.initMonitor();
    }

    public String getKey() {
        return this.m_config.getMetricKey();
    }

    public MonitorConfig getMonitorConfig() {
        return this.m_config;
    }

    public final void initMonitor() throws EsxiTopException {
        this.m_me = this.determineManagedEntity();
        this.m_refresh = this.determineRefreshRate();
        this.m_info = this.determineCounterInfo();
        this.allInstances = this.determineInstanceType();
        this.m_spec = this.createQuerySpec();
    }

    protected boolean determineInstanceType() {
        if (this.m_config.getAllInstances() != null) {
            return this.m_config.getAllInstances();
        }
        String[] splits = this.m_config.getMetricKey().split("\\.");
        return allInstSet.contains(splits[0]);
    }

    protected ManagedEntity[] determineManagedEntity() throws EsxiTopException {
        ManagedEntity[] me = Utils.determineManagedEntities(this.m_config.getServiceInstance(), this.m_config.getEntityType(), this.m_config.getEntityName());
        if (me != null && me.length > 0) {
            return me;
        }
        return null;
    }

    protected PerfCounterInfo[] determineCounterInfo() throws EsxiTopException {
        if (this.m_config.getMetricKey() == null) {
            throw new EsxiTopException("No valid metric key found");
        }
        if (this.m_config.getMetricKey().contains(ALL_INSTANCES_STATISTICS)) {
            String[] keys = this.m_config.getMetricKey().split("\\.");
            if (keys == null) {
                throw new EsxiTopException("Could not determine metric key");
            }
            if (keys.length == 3) {
                List<PerfCounterInfo> infos = PerfGroupingUtils.getInstance().getPerfInfoPerGroup(true, this.m_config.getPerformanceManager(), keys[0]);
                if (infos == null || infos.size() == 0) {
                    throw new EsxiTopException("Could not determine metric info");
                }
                String name = keys[1];
                String stats = keys[2];
                ArrayList<PerfCounterInfo> nameCollected = new ArrayList<PerfCounterInfo>();
                if (ALL_INSTANCES_STATISTICS.equals(name)) {
                    nameCollected.addAll(infos);
                } else {
                    for (PerfCounterInfo info : infos) {
                        if (!info.getNameInfo().getKey().equals(name)) continue;
                        nameCollected.add(info);
                    }
                }
                ArrayList<PerfCounterInfo> statsCollected = new ArrayList<PerfCounterInfo>();
                if (ALL_INSTANCES_STATISTICS.equals(stats) && nameCollected.size() > 0) {
                    statsCollected.addAll(nameCollected);
                } else {
                    for (PerfCounterInfo info : nameCollected) {
                        if (info.getRollupType() != PerfSummaryType.valueOf((String)stats)) continue;
                        statsCollected.add(info);
                    }
                }
                if (statsCollected.size() == 0) {
                    throw new EsxiTopException("No metrics found for name " + this.m_config.getMetricKey());
                }
                return statsCollected.toArray(new PerfCounterInfo[statsCollected.size()]);
            }
            if (keys.length == 2) {
                String name = keys[1];
                List<PerfCounterInfo> infos = PerfGroupingUtils.getInstance().getPerfInfoPerGroup(true, this.m_config.getPerformanceManager(), keys[0]);
                if (infos.size() == 0) {
                    throw new EsxiTopException("No metrics found for group " + keys[0]);
                }
                if (ALL_INSTANCES_STATISTICS.equals(name)) {
                    return infos.toArray(new PerfCounterInfo[infos.size()]);
                }
                ArrayList<PerfCounterInfo> result = new ArrayList<PerfCounterInfo>();
                for (PerfCounterInfo info : infos) {
                    if (!info.getNameInfo().getKey().equals(name)) continue;
                    result.add(info);
                }
                return result.toArray(new PerfCounterInfo[result.size()]);
            }
        } else {
            return new PerfCounterInfo[]{PerfGroupingUtils.getInstance().getPerfInfoPerKey(true, this.m_config.getPerformanceManager(), this.m_config.getMetricKey())};
        }
        throw new EsxiTopException("No perfcounter info found for key=" + this.m_config.getMetricKey());
    }

    protected PerfQuerySpec[] createQuerySpec() {
        int i;
        PerfQuerySpec[] spec = new PerfQuerySpec[this.m_me.length];
        PerfMetricId[] ids = new PerfMetricId[this.m_info.length];
        int n = this.m_info.length;
        for (i = 0; i < n; ++i) {
            ids[i] = new PerfMetricId();
            ids[i].setCounterId(this.m_info[i].getKey());
            if (this.allInstances) {
                ids[i].setInstance(ALL_INSTANCES_STATISTICS);
            } else {
                ids[i].setInstance(AGGREGATED_STATISTICS);
            }
            this.counterToInfo.put(this.m_info[i].getKey(), this.m_info[i]);
        }
        if (ids.length > 0) {
            n = this.m_me.length;
            for (i = 0; i < n; ++i) {
                spec[i] = new PerfQuerySpec();
                spec[i].setEntity(this.m_me[i].getMOR());
                spec[i].setMetricId(ids);
                spec[i].setMaxSample(Integer.valueOf(1));
                spec[i].setIntervalId(Integer.valueOf(this.m_refresh));
            }
        }
        return spec;
    }

    protected int determineRefreshRate() throws EsxiTopException {
        int refresh = -1;
        try {
            PerfProviderSummary pps = this.m_config.getPerformanceManager().queryPerfProviderSummary(this.m_me[0]);
            refresh = pps.getRefreshRate();
        }
        catch (Throwable e) {
            throw new EsxiTopException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Refresh Intervall=%s", refresh));
        }
        return refresh;
    }

    public int getRefreshRateSeconds() {
        return this.m_refresh;
    }

    static {
        allInstSet.add("disk");
        allInstSet.add("net");
    }
}

