/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.Command;
import com.blixx.esxi.command.CommandConfig;
import com.blixx.esxi.command.DataStoreMonitor;
import com.blixx.esxi.command.MonitorConfig;
import com.blixx.esxi.command.MulitSubmitMonitor;
import com.blixx.esxi.command.MultiHostMonitor;
import com.blixx.esxi.command.OverallStatusMon;
import com.blixx.esxi.command.SingleSubmitMonitor;
import com.blixx.esxi.command.VMGuestHeartBeatMon;
import com.blixx.esxi.command.VMToolsActiveMon;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MonitorType;
import com.blixx.ext.IMessage;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.mo.ServiceInstance;

public class CommandFactory {
    public static final String DATASTORE_USAGE = "datastore_monitoring";
    private IMessage m_msgSubmit;
    private IMonitorSubmitter m_monSubmit;

    public CommandFactory(IMessage msgSubmit, IMonitorSubmitter monSubmit) {
        this.m_msgSubmit = msgSubmit;
        this.m_monSubmit = monSubmit;
    }

    public Command createCommand(ServiceInstance si, String entityName, String entityType, MonitorType type, String key, String monitorName, Boolean allInstance) throws EsxiTopException {
        CommandConfig config = new CommandConfig(si, type, monitorName, key, entityType, entityName);
        Command cmd = null;
        if (type != null) {
            switch (type) {
                case VM_HEART_BEAT_MON: {
                    cmd = new VMGuestHeartBeatMon(this.m_monSubmit, config);
                    break;
                }
                case VM_TOOLS_MON: {
                    cmd = new VMToolsActiveMon(this.m_monSubmit, config);
                    break;
                }
                case OVERALL_STATUS_MON: {
                    cmd = new OverallStatusMon(this.m_monSubmit, config);
                    break;
                }
                case MULTI_SUBMIT_MON: {
                    if (key.equals(DATASTORE_USAGE)) {
                        cmd = new DataStoreMonitor(this.m_monSubmit, config);
                        break;
                    }
                    cmd = new MulitSubmitMonitor(this.m_monSubmit, new MonitorConfig(si, entityName, entityType, key, monitorName, allInstance));
                    break;
                }
                case SINGLE_SUBMIT_MON: {
                    if (key.equals(DATASTORE_USAGE)) {
                        cmd = new DataStoreMonitor(this.m_monSubmit, config);
                        break;
                    }
                    cmd = new SingleSubmitMonitor(this.m_monSubmit, new MonitorConfig(si, entityName, entityType, key, monitorName, allInstance));
                    break;
                }
                case MULTI_HOST_MON: {
                    if (key.equals(DATASTORE_USAGE)) {
                        cmd = new DataStoreMonitor(this.m_monSubmit, config);
                        break;
                    }
                    cmd = new MultiHostMonitor(this.m_monSubmit, config);
                    break;
                }
                default: {
                    throw new EsxiTopException("No Command found for the following command config : " + config.toString());
                }
            }
        }
        return cmd;
    }
}

