/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.AbstractCommand;
import com.blixx.esxi.command.CommandConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.DatastoreSummary;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VirtualMachineUsageOnDatastore;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStoreMonitor
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(DataStoreMonitor.class);
    private IMonitorSubmitter m_monSubmitter;

    public DataStoreMonitor(IMonitorSubmitter monSubmitter, CommandConfig config) throws EsxiTopException {
        super(config);
        this.m_monSubmitter = monSubmitter;
    }

    @Override
    public void execute() throws EsxiTopException {
        block8: {
            logger.debug("Datastore monitor start processing");
            HashMap<ManagedObjectReference, String> hostsCache = new HashMap<ManagedObjectReference, String>();
            HashMap<ManagedObjectReference, DatastoreSummary> storesCache = new HashMap<ManagedObjectReference, DatastoreSummary>();
            Folder root = this.m_config.getServiceInstance().getRootFolder();
            InventoryNavigator inv = new InventoryNavigator((ManagedEntity)root);
            try {
                String en = this.m_config.getEntityName();
                String et = this.m_config.getEntityType();
                ManagedEntity[] me = Utils.determineManagedEntities(this.m_config.getServiceInstance(), et, en);
                if (me == null) break block8;
                for (ManagedEntity e : me) {
                    if (e instanceof VirtualMachine) {
                        VirtualMachineUsageOnDatastore[] usages;
                        VirtualMachine vm = (VirtualMachine)e;
                        ManagedObjectReference hostMor = vm.getRuntime().getHost();
                        HashMap<Object, Object> opts = Utils.mergeOptions(this.m_options);
                        String hostname = (String)hostsCache.get(hostMor);
                        if (hostname == null) {
                            hostname = Utils.determineHost(this.m_config.getServiceInstance().getServerConnection(), hostMor);
                            opts.put(MessageOptions.HOST_SYSTEM.getValue(), hostname);
                            hostsCache.put(hostMor, hostname);
                        }
                        opts.put(MessageOptions.HOST_SYSTEM.getValue(), hostname);
                        logger.debug("Datastore monitor. VM: {}", (Object)hostname);
                        for (VirtualMachineUsageOnDatastore use : usages = vm.getStorage().getPerDatastoreUsage()) {
                            DatastoreSummary sum = (DatastoreSummary)storesCache.get(use.getDatastore());
                            if (sum == null) {
                                Datastore store = new Datastore(this.m_config.getServiceInstance().getServerConnection(), use.getDatastore());
                                sum = store.getSummary();
                                storesCache.put(use.getDatastore(), sum);
                                logger.debug("Datastore monitor (VirtualMachineUsageOnDatastore). Datastore: {} freeSpace: {} ", (Object)store.getName(), (Object)sum.getFreeSpace());
                            }
                            String object = Utils.constructObject(hostname, vm.getName(), sum.getName(), sum.getType());
                            opts = this.addUsagesOnStores(use, sum, opts);
                            this.m_monSubmitter.submitMonitorValue(hostname, -1.0, object, opts);
                        }
                        continue;
                    }
                    if (!(e instanceof HostSystem)) continue;
                    HostSystem sys = (HostSystem)e;
                    logger.debug("Datastore monitor. HostSystem: {}", (Object)sys.getName());
                    Datastore[] stores = sys.getDatastores();
                    logger.debug("Datastore monitor. HostSystem: {}. {} datastores found.", (Object)sys.getName(), (Object)(stores == null ? -1 : stores.length));
                    for (Datastore store : stores) {
                        store.refreshDatastoreStorageInfo();
                        DatastoreSummary summary = store.getSummary();
                        logger.debug("Datastore monitor. Datastore: {} freeSpace: {} ", (Object)store.getName(), (Object)summary.getFreeSpace());
                        String object = Utils.constructObject(sys.getName(), summary.getName(), summary.getType());
                        HashMap<Object, Object> opts = Utils.mergeOptions(this.m_options);
                        opts = this.addStoreValues(summary, opts);
                        this.m_monSubmitter.submitMonitorValue(sys.getName(), -1.0, object, opts);
                    }
                }
            }
            catch (Throwable e) {
                logger.error("", e);
                throw new EsxiTopException(e);
            }
        }
        logger.debug("Datastore monitor finished");
    }

    private HashMap<Object, Object> addUsagesOnStores(VirtualMachineUsageOnDatastore use, DatastoreSummary store, HashMap<Object, Object> opts) {
        opts.put("name", store.getName());
        opts.put("type", store.getType());
        opts.put("unshared", use.getUnshared());
        opts.put("uncommited", use.getUncommitted());
        opts.put("committed", use.getCommitted());
        return opts;
    }

    private HashMap<Object, Object> addStoreValues(DatastoreSummary summary, HashMap<Object, Object> opts) {
        long capacity = summary.getCapacity();
        Long unc = summary.getUncommitted();
        long uncommitted = 0L;
        if (unc != null) {
            uncommitted = unc;
        }
        long freeSpace = summary.getFreeSpace();
        if (capacity == 0L && freeSpace == 0L) {
            freeSpace = -1L;
            capacity = -1L;
        }
        opts.put("name", summary.getName());
        opts.put("type", summary.getType());
        opts.put("capacity", capacity);
        opts.put("uncommited", uncommitted);
        opts.put("freespace", freeSpace);
        opts.put("url", summary.getUrl());
        opts.put("multipleHostAccess", summary.getMultipleHostAccess());
        return opts;
    }
}

