/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.AbstractMonitor;
import com.blixx.esxi.command.Command;
import com.blixx.esxi.command.MonitorConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.types.MetricInfo;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.mo.ManagedEntity;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MulitSubmitMonitor
extends AbstractMonitor
implements Command {
    private static final Logger logger = LoggerFactory.getLogger(MulitSubmitMonitor.class);
    private IMonitorSubmitter m_monSubmitter;
    private HashMap<Object, Object> m_options;

    public MulitSubmitMonitor(IMonitorSubmitter monSub, MonitorConfig config) throws EsxiTopException {
        super(config);
        this.m_monSubmitter = monSub;
    }

    private void process() throws EsxiTopException {
        try {
            PerfEntityMetricBase[] bases = this.m_config.getPerformanceManager().queryPerf(this.m_spec);
            if (bases != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Found %s child metric bases", bases != null ? Integer.valueOf(bases.length) : "0"));
                }
                this.processChilds(bases);
            } else {
                logger.warn("No metrics found for metric " + this.m_config.getMetricKey());
            }
        }
        catch (Throwable e) {
            logger.error("Error getting monitor value", e);
            throw new EsxiTopException("Error getting monitor value", e);
        }
    }

    private void processChilds(PerfEntityMetricBase[] childBases) throws EsxiTopException {
        if (childBases != null) {
            Map<String, ManagedEntity> entities = Utils.determineEntities2(this.m_config.getServiceInstance(), childBases[0].getEntity().getType());
            for (PerfEntityMetricBase base : childBases) {
                MetricInfo[] miList = Utils.getMetricInfos(base, this.counterToInfo);
                String name = Utils.determineEntityName(base, entities);
                String hostname = Utils.determineHostForVm(this.m_config.getServiceInstance().getServerConnection(), base);
                for (MetricInfo mi : miList) {
                    if (name == null || mi.getMetric() == Double.MIN_VALUE) continue;
                    HashMap<Object, Object> newOpts = Utils.mergeOptions(this.m_options);
                    newOpts.put(MessageOptions.UNIT.getValue(), mi.getUnit());
                    newOpts.put(MessageOptions.SAMPLETIME.getValue(), this.SAMPLE_DATE_FORMAT.format(mi.getSampleTime().getTime()));
                    newOpts.put(MessageOptions.ENTITY.getValue(), name);
                    newOpts.put(MessageOptions.METRIC_KEY.getValue(), mi.getMetricKey());
                    if (hostname != null) {
                        newOpts.put(MessageOptions.HOST_SYSTEM.getValue(), hostname);
                    }
                    String object = Utils.constructObject(hostname, name, mi.getInstance(), mi.getMetricKey());
                    this.m_monSubmitter.submitMonitorValue(this.m_config.getMonitorName(), mi.getMetric(), object, newOpts);
                }
            }
        }
    }

    @Override
    public void execute() throws EsxiTopException {
        this.process();
    }

    @Override
    public void setOptions(HashMap<Object, Object> options) {
        this.m_options = options;
    }
}

