/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.AbstractCommand;
import com.blixx.esxi.command.CommandConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.types.MetricInfo;
import com.blixx.esxi.utils.PerfGroupingUtils;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfProviderSummary;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiHostMonitor
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(MultiHostMonitor.class);
    private final IMonitorSubmitter m_monSubmitter;
    private ManagedEntity[] m_entities;
    private PerfQuerySpec[] m_querySpec;
    private PerfCounterInfo m_info;
    private int m_refresh;

    public MultiHostMonitor(IMonitorSubmitter monSubmit, CommandConfig cfg) throws EsxiTopException {
        super(cfg);
        this.m_monSubmitter = monSubmit;
        this.init();
    }

    @Override
    public void execute() throws EsxiTopException {
        PerfEntityMetricBase[] bases = Utils.queryPerformanceManager(this.m_config.getServiceInstance().getPerformanceManager(), this.m_querySpec);
        logger.debug("MultiHostMonitor monitor. Query: {}", (Object[])this.m_querySpec);
        if (bases != null && bases.length > 0) {
            for (PerfEntityMetricBase base : bases) {
                MetricInfo[] metrikInfos = null;
                if ((metrikInfos = this.determineEntity(metrikInfos, base)) == null || metrikInfos.length <= 0) continue;
                for (MetricInfo mi : metrikInfos) {
                    HashMap<Object, Object> newOpts = Utils.mergeOptions(this.m_options);
                    newOpts.put(MessageOptions.UNIT.getValue(), mi.getUnit());
                    newOpts.put(MessageOptions.SAMPLETIME.getValue(), this.SAMPLE_DATE_FORMAT.format(mi.getSampleTime().getTime()));
                    newOpts.put(MessageOptions.ENTITY.getValue(), mi.getEntityName());
                    newOpts.put(MessageOptions.METRIC_KEY.getValue(), this.m_config.getMetricKey());
                    String object = mi.getEntityName() + ":" + mi.getInstance() + ":" + this.m_config.getMetricKey();
                    this.m_monSubmitter.submitMonitorValue(this.m_config.getMonitorName(), mi.getMetric(), object, newOpts);
                    logger.debug("MultiHostMonitor monitor. Submit. Object: {} {}", (Object)object, (Object)mi.getMetric());
                }
            }
        } else {
            logger.debug("MultiHostMonitor monitor. Nothing found for Query: {}", (Object[])this.m_querySpec);
        }
    }

    private MetricInfo[] determineEntity(MetricInfo[] metrikInfos, PerfEntityMetricBase base) {
        ManagedObjectReference mor = base.getEntity();
        HostSystem hs = new HostSystem(this.m_config.getServiceInstance().getServerConnection(), mor);
        String name = hs.getName();
        if (name != null) {
            for (MetricInfo info : metrikInfos) {
                info.setEntityName(name);
            }
        }
        return metrikInfos;
    }

    public void init() throws EsxiTopException {
        this.determineManagedEntity();
        this.determineRefreshRate();
        this.determineCounterInfo();
        this.createQuerySpec();
    }

    private void createQuerySpec() {
        PerfQuerySpec[] spec = new PerfQuerySpec[this.m_entities.length];
        int n = this.m_entities.length;
        for (int i = 0; i < n; ++i) {
            spec[i] = new PerfQuerySpec();
            PerfMetricId id = new PerfMetricId();
            id.setCounterId(this.m_info.getKey());
            if (this.m_config.getMetricKey().startsWith("disk.")) {
                id.setInstance("*");
            } else {
                id.setInstance("");
            }
            spec[i].setEntity(this.m_entities[i].getMOR());
            spec[i].setMetricId(new PerfMetricId[]{id});
            spec[i].setMaxSample(Integer.valueOf(1));
            spec[i].setIntervalId(Integer.valueOf(this.m_refresh));
        }
        this.m_querySpec = spec;
    }

    private void determineCounterInfo() throws EsxiTopException {
        this.m_info = PerfGroupingUtils.getInstance().getPerfInfoPerKey(true, this.m_config.getServiceInstance().getPerformanceManager(), this.m_config.getMetricKey());
        if (this.m_info == null) {
            throw new EsxiTopException("Error no metric available for key=" + this.m_config.getMetricKey());
        }
    }

    private void determineManagedEntity() throws EsxiTopException {
        this.m_entities = Utils.determineManagedEntities(this.m_config.getServiceInstance(), "HostSystem", null);
        if (this.m_entities == null) {
            throw new EsxiTopException("Error determine managed entities");
        }
    }

    private void determineRefreshRate() throws EsxiTopException {
        this.m_refresh = -1;
        try {
            PerfProviderSummary pps = this.m_config.getServiceInstance().getPerformanceManager().queryPerfProviderSummary(this.m_entities[0]);
            this.m_refresh = pps.getRefreshRate();
        }
        catch (Throwable e) {
            throw new EsxiTopException(e);
        }
        if (this.m_refresh == -1) {
            throw new EsxiTopException("Error determining refresh rate");
        }
    }
}

