/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.AbstractCommand;
import com.blixx.esxi.command.CommandConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.ManagedEntityStatus;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverallStatusMon
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(OverallStatusMon.class);
    private static final HashMap<ManagedEntityStatus, Double> status = new HashMap();
    private final Map<String, String> objectNames = new HashMap<String, String>();
    private final Map<String, String> hosts = new HashMap<String, String>();
    private IMonitorSubmitter m_monSubmit;

    public OverallStatusMon(IMonitorSubmitter monSubmit, CommandConfig config) throws EsxiTopException {
        super(config);
        this.m_monSubmit = monSubmit;
    }

    @Override
    public void execute() throws EsxiTopException {
        ManagedEntity[] entities;
        String entityName = this.m_config.getEntityName();
        String et = this.m_config.getEntityType();
        if (("VirtualMachine".equals(et) || "HostSystem".equals(et)) && "*".equals(this.m_config.getEntityName())) {
            entityName = null;
        }
        if ((entities = Utils.determineManagedEntities(this.m_config.getServiceInstance(), this.m_config.getEntityType(), entityName)) != null) {
            for (ManagedEntity entity : entities) {
                String hostname = null;
                if (entity instanceof VirtualMachine) {
                    VirtualMachine vm = (VirtualMachine)entity;
                    if (vm.getRuntime().getPowerState() == VirtualMachinePowerState.poweredOff) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("Ignoring vm " + vm.getName() + " for overall status because it is offline");
                        continue;
                    }
                    hostname = this.hosts.get(entity.getName());
                    if (hostname == null) {
                        ManagedObjectReference mor = vm.getRuntime().getHost();
                        HostSystem host = new HostSystem(this.m_config.getServiceInstance().getServerConnection(), mor);
                        hostname = host.getName();
                        this.hosts.put(entity.getName(), hostname);
                    }
                }
                HashMap<Object, Object> opts = Utils.mergeOptions(this.m_options);
                opts.put(MessageOptions.ENTITY.getValue(), entity.getName());
                opts.put(MessageOptions.HOST_SYSTEM.getValue(), hostname);
                if (logger.isDebugEnabled()) {
                    logger.debug("Submit value " + status.get(entity.getOverallStatus()) + " for entity=" + opts.get(MessageOptions.ENTITY.getValue()));
                }
                String name = entity.getName();
                String objectName = this.objectNames.get(entity.getName());
                if (objectName == null) {
                    objectName = hostname != null ? hostname + ":" + name + ":" + this.m_config.getMetricKey() : name + ":" + this.m_config.getMetricKey();
                    this.objectNames.put(name, objectName);
                }
                this.m_monSubmit.submitMonitorValue(this.m_config.getMonitorName(), status.get(entity.getOverallStatus()).doubleValue(), objectName, opts);
            }
        }
    }

    static {
        status.put(ManagedEntityStatus.green, 0.0);
        status.put(ManagedEntityStatus.gray, 1.0);
        status.put(ManagedEntityStatus.yellow, 2.0);
        status.put(ManagedEntityStatus.red, 3.0);
    }
}

