/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.AbstractMonitor;
import com.blixx.esxi.command.Command;
import com.blixx.esxi.command.MonitorConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.types.MetricInfo;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.RuntimeFault;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleSubmitMonitor
extends AbstractMonitor
implements Command {
    private static Logger logger = LoggerFactory.getLogger(SingleSubmitMonitor.class);
    private IMonitorSubmitter m_monSubmitter;
    private HashMap<Object, Object> m_options;

    public SingleSubmitMonitor(IMonitorSubmitter monSub, MonitorConfig config) throws EsxiTopException {
        super(config);
        this.m_monSubmitter = monSub;
    }

    @Override
    public void execute() throws EsxiTopException {
        PerfEntityMetricBase[] base = null;
        try {
            base = this.m_config.getPerformanceManager().queryPerf(this.m_spec);
            logger.debug(String.format("queryPerf found %s elements", base != null ? Integer.valueOf(base.length) : "0"));
            if (base != null) {
                List<MetricInfo> miList = Utils.getMetricInfo(base[0], this.counterToInfo);
                for (MetricInfo mi : miList) {
                    HashMap<Object, Object> newOpts = Utils.mergeOptions(this.m_options);
                    newOpts.put(MessageOptions.UNIT.getValue(), mi.getUnit());
                    newOpts.put(MessageOptions.SAMPLETIME.getValue(), this.SAMPLE_DATE_FORMAT.format(mi.getSampleTime().getTime()));
                    newOpts.put(MessageOptions.ENTITY.getValue(), mi.getEntityName());
                    newOpts.put(MessageOptions.METRIC_KEY.getValue(), mi.getMetricKey());
                    String object = mi.getEntityName() + ":" + mi.getMetricKey();
                    this.m_monSubmitter.submitMonitorValue(this.m_config.getMonitorName(), mi.getMetric(), object, newOpts);
                }
            }
        }
        catch (RuntimeFault e) {
            logger.error("Error getting monitor value", (Throwable)e);
            throw new EsxiTopException("Error getting monitor value", e);
        }
        catch (RemoteException e) {
            logger.error("Error getting monitor value", (Throwable)e);
            throw new EsxiTopException("Error getting monitor value", e);
        }
    }

    @Override
    public void setOptions(HashMap<Object, Object> options) {
        this.m_options = options;
    }
}

