/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.AbstractCommand;
import com.blixx.esxi.command.CommandConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IMessage;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.HashMap;

public class VMGuestHeartBeat
extends AbstractCommand {
    private IMessage m_msgSubmit;
    private static final String TYPE = "VirtualMachine";

    public VMGuestHeartBeat(IMessage msgSub, CommandConfig config) throws EsxiTopException {
        super(config);
        this.m_msgSubmit = msgSub;
    }

    @Override
    public void execute() throws EsxiTopException {
        ManagedEntity[] entities;
        for (ManagedEntity entity : entities = Utils.determineManagedEntities(this.m_config.getServiceInstance(), TYPE, this.m_config.getEntityName())) {
            VirtualMachine vm;
            VirtualMachineRuntimeInfo vmRuntime;
            if (!(entity instanceof VirtualMachine) || (vmRuntime = (vm = (VirtualMachine)entity).getRuntime()).getPowerState() != VirtualMachinePowerState.poweredOn) continue;
            this.m_msgSubmit.sendMessage(vm.getName(), "ESXiTop", "ESXi", TYPE, vm.getSummary().getQuickStats().getGuestHeartbeatStatus().toString(), null, this.m_options);
        }
    }

    @Override
    public void setOptions(HashMap<Object, Object> options) {
        super.setOptions(options);
        if (this.m_options != null && this.m_config.getMonitorName() != null) {
            this.m_options.put(MessageOptions.POLICY_NAME.getValue(), this.m_config.getMonitorName());
        }
    }
}

