/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.AbstractCommand;
import com.blixx.esxi.command.CommandConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.ManagedEntityStatus;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.HashMap;
import java.util.Map;

public class VMGuestHeartBeatMon
extends AbstractCommand {
    private static final String TYPE = "VirtualMachine";
    private static final HashMap<ManagedEntityStatus, Double> status = new HashMap();
    private final Map<String, String> objectNames = new HashMap<String, String>();
    private final Map<String, String> hosts = new HashMap<String, String>();
    IMonitorSubmitter m_monSubmit;

    public VMGuestHeartBeatMon(IMonitorSubmitter monSubmit, CommandConfig config) throws EsxiTopException {
        super(config);
        this.m_monSubmit = monSubmit;
    }

    @Override
    public void execute() throws EsxiTopException {
        ManagedEntity[] entities;
        for (ManagedEntity entity : entities = Utils.determineManagedEntities(this.m_config.getServiceInstance(), TYPE, this.m_config.getEntityName())) {
            VirtualMachine vm;
            VirtualMachineRuntimeInfo vmRuntime;
            if (!(entity instanceof VirtualMachine) || (vmRuntime = (vm = (VirtualMachine)entity).getRuntime()).getPowerState() != VirtualMachinePowerState.poweredOn) continue;
            HashMap<Object, Object> opts = Utils.mergeOptions(this.m_options);
            opts.put(MessageOptions.ENTITY.getValue(), vm.getName());
            if (this.hosts.get(vm.getName()) == null) {
                ManagedObjectReference hmor = vm.getRuntime().getHost();
                HostSystem host = new HostSystem(this.m_config.getServiceInstance().getServerConnection(), hmor);
                String hostname = host.getName();
                this.hosts.put(vm.getName(), hostname);
            }
            ManagedEntityStatus stat = vm.getSummary().getQuickStats().getGuestHeartbeatStatus();
            String name = entity.getName();
            String objectName = this.objectNames.get(entity.getName());
            if (objectName == null) {
                String hostname = this.hosts.get(vm.getName());
                objectName = hostname != null ? hostname + ":" + name + ":" + this.m_config.getMetricKey() : name + ":" + this.m_config.getMetricKey();
                this.objectNames.put(name, objectName);
            }
            this.m_monSubmit.submitMonitorValue(this.m_config.getMonitorName(), status.get(stat).doubleValue(), objectName, opts);
        }
    }

    static {
        status.put(ManagedEntityStatus.green, 0.0);
        status.put(ManagedEntityStatus.gray, 1.0);
        status.put(ManagedEntityStatus.yellow, 2.0);
        status.put(ManagedEntityStatus.red, 3.0);
    }
}

