/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.command;

import com.blixx.esxi.command.AbstractCommand;
import com.blixx.esxi.command.CommandConfig;
import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MessageOptions;
import com.blixx.esxi.utils.Utils;
import com.blixx.ext.IMonitorSubmitter;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMToolsActiveMon
extends AbstractCommand {
    private static final Logger logger = LoggerFactory.getLogger(VMToolsActiveMon.class);
    private static final String TYPE = "VirtualMachine";
    private static final HashMap<VirtualMachineToolsStatus, Double> status = new HashMap();
    private final Map<String, String> objectNames = new HashMap<String, String>();
    private final Map<String, String> hosts = new HashMap<String, String>();
    private static final Double unknown;
    private IMonitorSubmitter m_monSubmit;

    public VMToolsActiveMon(IMonitorSubmitter monSubmit, CommandConfig config) throws EsxiTopException {
        super(config);
        this.m_monSubmit = monSubmit;
    }

    @Override
    public void execute() throws EsxiTopException {
        ManagedEntity[] entities;
        String entityName = this.m_config.getEntityName();
        if (this.m_config.getEntityType().equals(TYPE) && this.m_config.getEntityName().equals("*")) {
            entityName = null;
        }
        for (ManagedEntity entity : entities = Utils.determineManagedEntities(this.m_config.getServiceInstance(), TYPE, entityName)) {
            VirtualMachineToolsStatus vmTools;
            Double toSend;
            VirtualMachine vm;
            VirtualMachineRuntimeInfo vmRuntime;
            if (!(entity instanceof VirtualMachine) || (vmRuntime = (vm = (VirtualMachine)entity).getRuntime()).getPowerState() != VirtualMachinePowerState.poweredOn) continue;
            HashMap<Object, Object> opts = Utils.mergeOptions(this.m_options);
            opts.put(MessageOptions.ENTITY.getValue(), vm.getName());
            if (this.hosts.get(vm.getName()) == null) {
                ManagedObjectReference hmor = vm.getRuntime().getHost();
                HostSystem host = new HostSystem(this.m_config.getServiceInstance().getServerConnection(), hmor);
                String hostname = host.getName();
                this.hosts.put(vm.getName(), hostname);
            }
            if ((toSend = status.get(vmTools = vm.getSummary().getGuest().getToolsStatus())) == null) {
                toSend = unknown;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Submit value " + toSend + " for entity=" + opts.get(MessageOptions.ENTITY.getValue()));
            }
            String name = entity.getName();
            String objectName = this.objectNames.get(entity.getName());
            if (objectName == null) {
                String hostname = this.hosts.get(vm.getName());
                objectName = hostname != null ? hostname + ":" + name + ":" + this.m_config.getMetricKey() : name + ":" + this.m_config.getMetricKey();
                this.objectNames.put(name, objectName);
            }
            this.m_monSubmit.submitMonitorValue(this.m_config.getMonitorName(), toSend.doubleValue(), objectName, opts);
        }
    }

    static {
        status.put(VirtualMachineToolsStatus.toolsOk, 0.0);
        status.put(VirtualMachineToolsStatus.toolsOld, 1.0);
        status.put(VirtualMachineToolsStatus.toolsNotInstalled, 2.0);
        status.put(VirtualMachineToolsStatus.toolsNotRunning, 3.0);
        unknown = -1.0;
    }
}

