/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.connection;

import com.blixx.esxi.types.CLIOpts;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.cli.CommandLine;

public class ConnectionAttributes {
    private CommandLine m_opts;

    public ConnectionAttributes(CommandLine opts) {
        this.m_opts = opts;
    }

    public String getUser() {
        return this.getString(CLIOpts.USERNAME);
    }

    public String getPassword(boolean decrypt) {
        return this.getString(CLIOpts.PASSWORD);
    }

    public URL getURL() throws MalformedURLException {
        return new URL(this.getString(CLIOpts.URL));
    }

    public String getUrlStr() {
        return this.getString(CLIOpts.URL);
    }

    public boolean isIgnorecert() {
        return this.getBoolean(CLIOpts.IGNORECERT);
    }

    public String getHostname() {
        return this.getString(CLIOpts.HOSTNAME);
    }

    public String getEntityName() {
        return this.getString(CLIOpts.ENTITY_NAME);
    }

    public String getEntityType() {
        return this.getString(CLIOpts.ENTITY_TYPE);
    }

    private String getString(CLIOpts optName) {
        return this.m_opts.getOptionValue(optName.getValue());
    }

    private boolean getBoolean(CLIOpts optName) {
        return this.m_opts.hasOption(optName.getValue());
    }

    public String toString() {
        return String.format("Connection with url=%s user=%s password=%s ignorecert=%b", this.getUrlStr(), this.getUser(), this.getPassword(false), this.isIgnorecert());
    }
}

