/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.connection;

import com.blixx.esxi.connection.ConnectionAttributes;
import com.blixx.esxi.exception.EsxiTopException;
import com.vmware.vim25.mo.ServiceInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EsxiConnection {
    private static final Logger logger = LoggerFactory.getLogger(EsxiConnection.class);
    private ConnectionAttributes m_attrs;
    private ServiceInstance m_si;
    private boolean connected = false;

    public EsxiConnection(ConnectionAttributes attrs) {
        this.m_attrs = attrs;
    }

    public ServiceInstance connect() throws EsxiTopException {
        try {
            if (!this.isConnected()) {
                this.m_si = new ServiceInstance(this.m_attrs.getURL(), this.m_attrs.getUser(), this.m_attrs.getPassword(false), this.m_attrs.isIgnorecert());
                this.m_si.getServerConnection().getVimService().getWsc().setReadTimeout(600000);
                int timeout = this.m_si.getServerConnection().getVimService().getWsc().getReadTimeout();
                logger.debug("WSClient timeout set to {} ms", (Object)timeout);
                this.connected = true;
            }
        }
        catch (Throwable e) {
            logger.error("Error during esxi connect", e);
            throw new EsxiTopException(e);
        }
        return this.m_si;
    }

    public void disconnect() {
        if (this.m_si != null && this.isConnected()) {
            this.m_si.getServerConnection().logout();
            this.connected = false;
            this.m_si = null;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }
}

