/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.monitor;

import com.blixx.ext.IMessage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MessageMonitor
implements IMessage {
    private final Map<String, String> m_nodes = new HashMap<String, String>();
    private final Map<String, String> m_applications = new HashMap<String, String>();
    private final Map<String, String> m_groups = new HashMap<String, String>();
    private final Map<String, String> m_texts = new HashMap<String, String>();
    private final Map<String, HashMap<Object, Object>> m_optionsPerObj = new HashMap<String, HashMap<Object, Object>>();
    private final List<String> m_objects = new ArrayList<String>();

    public void sendMessage(String node, String application, String msggrp, String object, String text, String severity, HashMap optVars) {
        this.m_objects.add(object);
        if (node != null) {
            this.m_nodes.put(object, node);
        }
        if (application != null) {
            this.m_applications.put(object, application);
        }
        if (msggrp != null) {
            this.m_groups.put(object, msggrp);
        }
        if (text != null) {
            this.m_texts.put(object, text);
        }
        if (optVars != null) {
            this.m_optionsPerObj.put(object, optVars);
        }
    }

    public String toResult() {
        StringBuilder builder = new StringBuilder();
        for (String object : this.m_objects) {
            builder.append("node=");
            builder.append(this.m_nodes.get(object));
            builder.append(";");
            builder.append("application=");
            builder.append(this.m_applications.get(object));
            builder.append("group=");
            builder.append(this.m_groups.get(object));
            builder.append(";");
            builder.append(this.m_texts.get(object));
            HashMap<Object, Object> opts = this.m_optionsPerObj.get(object);
            Set<Object> keys = opts.keySet();
            if (keys == null) continue;
            for (Object key : keys) {
                builder.append(";");
                builder.append(key);
                builder.append("=");
                builder.append(opts.get(key));
            }
        }
        return builder.toString();
    }
}

