/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.monitor;

import com.blixx.ext.IMonitorSubmitter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiColMonSubmitter
implements IMonitorSubmitter {
    private static final Logger logger = LoggerFactory.getLogger(MultiColMonSubmitter.class);
    private final Map<String, Double> m_values = new HashMap<String, Double>();
    private final Map<String, String> m_monitors = new HashMap<String, String>();
    private final Map<String, HashMap<Object, Object>> m_optionsPerObj = new HashMap<String, HashMap<Object, Object>>();
    private final List<String> m_objects = new ArrayList<String>();
    private static final String format = "object=%s;metric=%s;value=%s";

    public void submitMonitorValue(String monitor, double value, String object, HashMap options) {
        if (object != null) {
            this.m_values.put(object, value);
            this.m_monitors.put(object, monitor);
            this.m_optionsPerObj.put(object, options);
            this.m_objects.add(object);
        }
    }

    public String toResult(String optinalInfo) {
        StringBuilder result = new StringBuilder();
        for (String obj : this.m_objects) {
            Set<Object> keys;
            Double val = this.m_values.get(obj);
            String mon = this.m_monitors.get(obj);
            HashMap<Object, Object> opts = this.m_optionsPerObj.get(obj);
            String submitOneMetric = String.format(format, obj != null ? obj : "NULL-obj", mon != null ? mon : "NULL-mon", val != null ? val : "NULL-val");
            result.append(submitOneMetric);
            logger.debug("Pre-Submit: " + submitOneMetric);
            if (opts != null && (keys = opts.keySet()) != null) {
                for (Object key : keys) {
                    result.append(";");
                    result.append(key);
                    result.append("=");
                    result.append(opts.get(key));
                }
                if (optinalInfo != null) {
                    result.append(";");
                    result.append(optinalInfo);
                }
            }
            result.append("\n");
        }
        return result.toString();
    }
}

