/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.options;

import com.blixx.esxi.connection.ConnectionAttributes;
import com.blixx.esxi.options.ConnectionAutomata;
import com.blixx.esxi.options.ConnectionOptions;
import com.blixx.esxi.options.IOptions;
import com.blixx.esxi.options.OperationMonitorOptions;
import com.blixx.esxi.options.OptionFactory;
import com.blixx.esxi.types.CLIOpts;
import com.blixx.esxi.types.Operation;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CommandLineAnalyser {
    private CommandLine m_parsedCommandLine;
    private String[] m_args;
    private Properties m_props;
    private Options m_connectOpts = OptionFactory.generateOptions(ConnectionOptions.getAllOptions());
    private Map<String, Options> m_operationOptions = new HashMap<String, Options>();
    private Map<String, IOptions> m_iopts = new HashMap<String, IOptions>();

    public CommandLineAnalyser(String[] argsToParse, Properties props) {
        this.m_operationOptions.put(Operation.MONITOR.getValue(), OptionFactory.generateOptions(OperationMonitorOptions.getAllOptions()));
        this.m_iopts.put(Operation.MONITOR.getValue(), OperationMonitorOptions.MONITOR_TYPE.getStart());
        this.m_args = argsToParse;
        this.m_props = props;
    }

    public Options getConnectionOptions() {
        return this.m_connectOpts;
    }

    public Options getOptions(String name) {
        return this.m_operationOptions.get(name);
    }

    public Options getAllOptions() {
        Options opts = new Options();
        Collection optionCol = this.m_connectOpts.getOptions();
        this.addOption(opts, optionCol);
        Set<String> keys = this.m_operationOptions.keySet();
        for (String key : keys) {
            Options temp = this.m_operationOptions.get(key);
            this.addOption(opts, temp.getOptions());
        }
        return opts;
    }

    private Options addOption(Options opts, Collection<Option> col) {
        if (col != null) {
            for (Option temp : col) {
                opts.addOption(temp);
            }
        }
        return opts;
    }

    public boolean analyseOptions(PrintWriter helpText) {
        GnuParser parser = new GnuParser();
        try {
            this.m_parsedCommandLine = this.m_props != null ? parser.parse(this.getAllOptions(), this.getArgs(), this.m_props) : parser.parse(this.getAllOptions(), this.getArgs());
            ConnectionAutomata automat = new ConnectionAutomata();
            StringBuilder errorText = new StringBuilder();
            if (!automat.processTransitions(this.m_parsedCommandLine, errorText, ConnectionOptions.USER.getTransitions(), ConnectionOptions.USER.getStart())) {
                helpText.println(this.getBasicHelpText(errorText.toString()));
                helpText.flush();
                return false;
            }
            String operation = this.m_parsedCommandLine.getOptionValue(ConnectionOptions.OPERATION.getValue());
            IOptions start = this.m_iopts.get(operation);
            if (start != null && !automat.processTransitions(this.m_parsedCommandLine, errorText, start.getTransitions(), start)) {
                helpText.println(this.getMonitorHelpText(errorText.toString()));
                helpText.flush();
                return false;
            }
        }
        catch (ParseException e) {
            helpText.println(this.getBasicHelpText(""));
            helpText.println(e.getMessage());
            helpText.flush();
            return false;
        }
        return true;
    }

    private String getHelpText(Options opts, String header, String footer) {
        StringBuilder builder = new StringBuilder();
        StringWriter caw = new StringWriter();
        PrintWriter pw = new PrintWriter(caw);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(pw, 80, "esxitop [options]", header, opts, 5, 10, footer);
        builder.append(caw.toString());
        try {
            if (caw != null) {
                caw.close();
                caw = null;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (pw != null) {
            pw.close();
            pw = null;
        }
        return builder.toString();
    }

    public String getBasicHelpText(String footer) {
        return this.getHelpText(this.m_connectOpts, "\nrequired options", footer);
    }

    public String getMonitorHelpText(String footer) {
        return this.getHelpText(this.m_operationOptions.get(Operation.MONITOR.getValue()), "\n options neede for operation " + (Object)((Object)Operation.MONITOR), footer);
    }

    public ConnectionAttributes getConnectionAttributes() {
        return new ConnectionAttributes(this.m_parsedCommandLine);
    }

    public String getAttributeValue(CLIOpts attr) {
        return this.getAttributeValue(attr.getValue());
    }

    public String getAttributeValue(String attr) {
        if (this.m_parsedCommandLine != null) {
            return this.m_parsedCommandLine.getOptionValue(attr);
        }
        return null;
    }

    public Operation getOperation() {
        if (!this.m_parsedCommandLine.hasOption(CLIOpts.OPERATION.getValue()) && this.m_props == null) {
            return null;
        }
        if (this.getAttributeValue(CLIOpts.OPERATION) != null) {
            return Operation.get(this.getAttributeValue(CLIOpts.OPERATION));
        }
        return null;
    }

    public String[] getArgs() {
        return this.m_args;
    }
}

