/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.options;

import com.blixx.esxi.options.IOptions;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionAutomata {
    private static Logger logger = LoggerFactory.getLogger(ConnectionAutomata.class);

    public boolean processTransitions(CommandLine cml, StringBuilder errorText, Map<IOptions, IOptions> transitions, IOptions start) {
        IOptions current = start;
        if (logger.isDebugEnabled()) {
            logger.debug("Start processing transitions with state " + current);
        }
        while (current != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Process state " + current);
            }
            if (!cml.hasOption(current.getValue())) {
                errorText.append("Option ");
                errorText.append(current.getValue());
                errorText.append(" is missing");
                logger.warn(errorText.toString());
                return false;
            }
            if (!current.hasArg()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Option is allright " + current + "! Go to next state!");
                }
                current = transitions.get(current);
                continue;
            }
            if (cml.getOptionValue(current.getValue()) == null) {
                errorText.append("Value for option ");
                errorText.append(current.getValue());
                errorText.append(" is missing");
                logger.warn(errorText.toString());
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Option is allright " + current + "! Go to next state!");
            }
            current = transitions.get(current);
        }
        logger.info("All options successfully parsed");
        return true;
    }
}

