/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.options;

import com.blixx.esxi.options.IOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum ConnectionOptions implements IOptions
{
    USER("u", "user", "esxi user which has read priviliges on the esxi host.", true),
    PASSWORD("p", "password", "password of the esxi user.", true),
    URL("url", "url", "URL to to esxi host sdk like https://hostname/sdk/", true),
    HOSTNAME("host", "hostname", "Name of the esxi host to monitor", true),
    IGNORECERT("ic", "ignorecert", "Use this option if you want to ignore the certificates from the esxi system", false),
    OPERATION("op", "operation", "Choose one of the following available ops: perf_info, monitor", true),
    PROPERTY_FILE("pf", "property_file", "Specify the name of the property file with options", true);

    private static Map<String, ConnectionOptions> types;
    private String shortValue;
    private String value;
    private String description;
    private boolean arg;

    private ConnectionOptions(String shortValue, String value, String description, boolean hasArg) {
        this.shortValue = shortValue;
        this.value = value;
        this.description = description;
        this.arg = hasArg;
    }

    public static Collection<ConnectionOptions> getAllTypes() {
        return types.values();
    }

    public static List<IOptions> getAllOptions() {
        return new ArrayList<IOptions>(ConnectionOptions.getAllTypes());
    }

    @Override
    public String getShort() {
        return this.shortValue;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean hasArg() {
        return this.arg;
    }

    @Override
    public IOptions getStart() {
        return USER;
    }

    @Override
    public Map<IOptions, IOptions> getTransitions() {
        HashMap<IOptions, IOptions> transitions = new HashMap<IOptions, IOptions>();
        transitions.put(USER, PASSWORD);
        transitions.put(PASSWORD, URL);
        transitions.put(URL, HOSTNAME);
        transitions.put(HOSTNAME, OPERATION);
        transitions.put(OPERATION, null);
        return transitions;
    }

    static {
        types = new HashMap<String, ConnectionOptions>();
        for (ConnectionOptions opts : EnumSet.allOf(ConnectionOptions.class)) {
            types.put(opts.getValue(), opts);
        }
    }
}

