/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.options;

import com.blixx.esxi.options.IOptions;
import com.blixx.esxi.types.MonitorType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum OperationMonitorOptions implements IOptions
{
    MONITOR_TYPE("mt", "monitor_type", "Choose one of the following: " + MonitorType.getDescription(), true),
    MONITOR_NAME("mn", "monitor_name", "Choose an esxi performance monitor key key like cpu.usage.average ", true),
    ENTITY_NAME("en", "entity_name", "Choose an instance name for the used entity_type like an VM name", true),
    ENTITY_TYPE("et", "entity_type", "choose one of the esxi managed types like HostSystem or VirtualMachine", true),
    ALL_INSTANCES("ai", "all_instances", "Choose all_instances if monitors are specific for instance e.g. for each cpu core. Default is aggrgated for all beside from disk and net", true),
    PRINT_REFRESH_RATE("prr", "print_refresh_rate", "print referesh rate(ms)", false);

    private static Map<String, OperationMonitorOptions> types;
    private String shortValue;
    private String value;
    private String description;
    private boolean arg;

    private OperationMonitorOptions(String shortValue, String value, String description, boolean hasArg) {
        this.shortValue = shortValue;
        this.value = value;
        this.description = description;
        this.arg = hasArg;
    }

    public static Collection<OperationMonitorOptions> getAllTypes() {
        return types.values();
    }

    public static List<IOptions> getAllOptions() {
        return new ArrayList<IOptions>(OperationMonitorOptions.getAllTypes());
    }

    @Override
    public String getShort() {
        return this.shortValue;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public boolean hasArg() {
        return this.arg;
    }

    @Override
    public IOptions getStart() {
        return MONITOR_TYPE;
    }

    @Override
    public Map<IOptions, IOptions> getTransitions() {
        HashMap<IOptions, IOptions> transitions = new HashMap<IOptions, IOptions>();
        transitions.put(MONITOR_TYPE, MONITOR_NAME);
        transitions.put(MONITOR_NAME, ENTITY_NAME);
        transitions.put(ENTITY_NAME, ENTITY_TYPE);
        transitions.put(ENTITY_TYPE, null);
        return transitions;
    }

    static {
        types = new HashMap<String, OperationMonitorOptions>();
        for (OperationMonitorOptions opts : EnumSet.allOf(OperationMonitorOptions.class)) {
            types.put(opts.getValue(), opts);
        }
    }
}

