/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.types;

import java.util.EnumSet;
import java.util.HashMap;

public enum MonitorType {
    VM_TOOLS("vm_tools"),
    VM_TOOLS_MON("vm_tools_mon"),
    OVERALL_STATUS("overall_status"),
    OVERALL_STATUS_MON("overall_status_mon"),
    VM_HEART_BEAT("vm_heart_beat"),
    VM_HEART_BEAT_MON("vm_heart_beat_mon"),
    MULTI_SUBMIT_MON("multi_monitor"),
    SINGLE_SUBMIT_MON("single_monitor"),
    MULTI_HOST_MON("multi_host_monitor"),
    SUM_COMPOSITE_MONITOR("sum_composite_monitor"),
    COMPOSITE_MONITOR("composite_monitor"),
    FLAT_MONITOR("flat_monitor");

    private static final HashMap<String, MonitorType> values;
    private final String value;

    private MonitorType(String value) {
        this.value = value;
    }

    public static MonitorType get(String name) {
        return values.get(name);
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.value;
    }

    public static String getDescription() {
        StringBuilder builderFormat = new StringBuilder("%1$s, %2$s, %3$s, %4$s, %5$s ");
        builderFormat.append("where %1$s is a monitor which submits exactly one performance metrik for exactly one entity\n");
        builderFormat.append("%2$s submits multiple values for mulitple entities from one type. e.g. all virtual machines\n");
        builderFormat.append("%3$s submits the tools status for all running virtual machines toolsOk=0.0, toolsOld=1.0, toolsNotInstalled=2.0, toolsNotRunning=3.0\n ");
        builderFormat.append("%4$s submits the heartbeat status of either one or all running vms green=0.0, gray=1.0, yellow=2.0, red=3.0\n");
        builderFormat.append("%5$s submits the overall status of a managed entity green=0.0, gray=1.0, yellow=2.0, red=3.0\n");
        return String.format(builderFormat.toString(), new Object[]{SINGLE_SUBMIT_MON.getValue(), MULTI_SUBMIT_MON.getValue(), VM_TOOLS_MON.getValue(), VM_HEART_BEAT_MON.getValue(), OVERALL_STATUS_MON});
    }

    static {
        values = new HashMap();
        for (MonitorType type : EnumSet.allOf(MonitorType.class)) {
            values.put(type.toString(), type);
        }
    }
}

