/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.utils;

import com.blixx.esxi.exception.EsxiTopException;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.mo.PerformanceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PerfGroupingUtils {
    public static final String KEY_FORMAT = "%s.%s.%s";
    private Map<String, List<PerfCounterInfo>> groupedInfo = new HashMap<String, List<PerfCounterInfo>>();
    private Map<String, PerfCounterInfo> keyedInfo = new HashMap<String, PerfCounterInfo>();
    private static PerfGroupingUtils instance = new PerfGroupingUtils();

    private PerfGroupingUtils() {
    }

    public static PerfGroupingUtils getInstance() {
        return instance;
    }

    public List<PerfCounterInfo> getPerfInfoPerGroup(boolean fromCache, PerformanceManager pm, String group) {
        if (fromCache) {
            List<PerfCounterInfo> groupList = this.groupedInfo.get(group);
            if (groupList != null && groupList.size() > 0) {
                return groupList;
            }
            this.fillGroupedInfo(pm, group);
            return this.groupedInfo.get(group);
        }
        this.clearGroup(group);
        this.fillGroupedInfo(pm, group);
        return this.groupedInfo.get(group);
    }

    public PerfCounterInfo getPerfInfoPerKey(boolean fromCache, PerformanceManager pm, String key) throws EsxiTopException {
        PerfCounterInfo info = null;
        if (fromCache) {
            info = this.keyedInfo.get(key);
            if (info != null) {
                return info;
            }
            this.fillKeyInfo(pm);
            info = this.keyedInfo.get(key);
        } else {
            this.clearKeyInfo();
            this.fillKeyInfo(pm);
            info = this.keyedInfo.get(key);
        }
        if (info == null) {
            throw new EsxiTopException("No such metric " + key + " available!");
        }
        return info;
    }

    private void clearKeyInfo() {
        this.keyedInfo.clear();
    }

    private void fillKeyInfo(PerformanceManager pm) {
        PerfCounterInfo[] infos;
        for (PerfCounterInfo info : infos = pm.getPerfCounter()) {
            String key = null;
            key = PerfGroupingUtils.generateKey(info);
            if (key == null) continue;
            this.keyedInfo.put(key, info);
        }
    }

    private void clearGroup(String group) {
        this.groupedInfo.remove(group);
    }

    private void fillGroupedInfo(PerformanceManager pm, String group) {
        PerfCounterInfo[] perfCounters;
        List<PerfCounterInfo> cis = this.groupedInfo.get(group);
        if (cis == null) {
            cis = new ArrayList<PerfCounterInfo>();
            this.groupedInfo.put(group, cis);
        }
        if ((perfCounters = pm.getPerfCounter()) != null) {
            for (PerfCounterInfo info : perfCounters) {
                if (!group.equals(info.getGroupInfo().getKey())) continue;
                cis.add(info);
            }
        }
    }

    public static String generateKey(PerfCounterInfo info) {
        String group = info.getGroupInfo().getKey();
        String name = info.getNameInfo().getKey();
        String roll = info.getRollupType().toString();
        return String.format(KEY_FORMAT, group, name, roll);
    }
}

