/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.utils;

import com.blixx.esxi.EsxiTop;
import com.blixx.esxi.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyReader {
    public static Logger logger = LoggerFactory.getLogger(PropertyReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(String path, String fileName) {
        File file = new File(path, fileName);
        Properties props = null;
        if (file.exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                props = new Properties();
                props.load(in);
            }
            catch (FileNotFoundException e) {
                logger.warn("Property File not found", (Throwable)e);
            }
            catch (IOException e) {
                logger.error("Error loading properties", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        logger.error("Error closing stream", (Throwable)e);
                    }
                    in = null;
                }
            }
        }
        return props;
    }

    public static Properties init(String[] args, String currentWorkDir) {
        String fileName = StringUtils.getArgValue("property_file", args);
        if (fileName == null) {
            fileName = StringUtils.getArgValue("pf", args);
        }
        Properties props = null;
        if (fileName != null && (props = PropertyReader.getProperties(currentWorkDir + "/spi/", fileName)) != null) {
            Set<Object> keys = props.keySet();
            if (EsxiTop.logger.isDebugEnabled()) {
                for (Object obj : keys) {
                    EsxiTop.logger.debug(obj + "=" + props.get(obj));
                }
            }
        }
        return props;
    }
}

