/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.esxi.utils;

import com.blixx.esxi.exception.EsxiTopException;
import com.blixx.esxi.types.MetricInfo;
import com.vmware.vim25.ElementDescription;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfMetricIntSeries;
import com.vmware.vim25.PerfMetricSeries;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PerfSampleInfo;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.PerformanceManager;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    public static final Logger logger = LoggerFactory.getLogger(Utils.class);
    private static final DateFormat format = DateFormat.getDateTimeInstance(3, 2, Locale.GERMAN);

    public static ManagedEntity[] determineEntities(ServiceInstance si, String type) throws EsxiTopException {
        Folder root = si.getRootFolder();
        InventoryNavigator inv = new InventoryNavigator((ManagedEntity)root);
        ManagedEntity[] ent = null;
        try {
            ent = inv.searchManagedEntities(type);
        }
        catch (InvalidProperty e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        catch (RuntimeFault e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        catch (RemoteException e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        return ent;
    }

    public static Map<String, ManagedEntity> determineEntities2(ServiceInstance si, String type) throws EsxiTopException {
        Folder root = si.getRootFolder();
        InventoryNavigator inv = new InventoryNavigator((ManagedEntity)root);
        ManagedEntity[] ent = null;
        HashMap<String, ManagedEntity> m_mapMORvalueToName = new HashMap<String, ManagedEntity>();
        try {
            for (ManagedEntity me : ent = inv.searchManagedEntities(type)) {
                m_mapMORvalueToName.put(me.getMOR().get_value(), me);
            }
        }
        catch (InvalidProperty e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        catch (RuntimeFault e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        catch (RemoteException e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        return m_mapMORvalueToName;
    }

    public static String determineEntityName(PerfEntityMetricBase base, ManagedEntity[] entities) {
        if (entities != null && entities.length > 0) {
            for (ManagedEntity entity : entities) {
                if (entity == null || !base.getEntity().getVal().equals(entity.getMOR().get_value())) continue;
                return entity.getName();
            }
        }
        return null;
    }

    public static String determineEntityName(PerfEntityMetricBase base, Map<String, ManagedEntity> entities) {
        ManagedEntity me = entities.get(base.getEntity().getVal());
        if (me != null) {
            return me.getName();
        }
        return null;
    }

    public static String determineEntityName(ServiceInstance si, PerfEntityMetricBase base) throws EsxiTopException {
        Folder root = si.getRootFolder();
        InventoryNavigator inv = new InventoryNavigator((ManagedEntity)root);
        ManagedEntity[] ent = null;
        try {
            ent = inv.searchManagedEntities(base.getEntity().getType());
        }
        catch (InvalidProperty e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        catch (RuntimeFault e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        catch (RemoteException e) {
            throw new EsxiTopException("Error dermine entity name", e);
        }
        if (ent != null) {
            for (ManagedEntity entity : ent) {
                if (entity == null || !base.getEntity().getVal().equals(entity.getMOR().get_value())) continue;
                return entity.getName();
            }
        }
        return null;
    }

    public static MetricInfo[] getMetricInfos(PerfEntityMetricBase perfEntityBase, Map<Integer, PerfCounterInfo> info) throws EsxiTopException {
        MetricInfo[] mi = null;
        if (perfEntityBase != null && perfEntityBase instanceof PerfEntityMetric) {
            PerfEntityMetric perfMetric = (PerfEntityMetric)perfEntityBase;
            PerfSampleInfo[] infos = perfMetric.getSampleInfo();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Found %s sample infos", infos != null ? Integer.valueOf(infos.length) : "0"));
                if (infos != null) {
                    for (PerfSampleInfo sampleInfo : infos) {
                        logger.debug(String.format("Sampleinfo with interval %s and timestamp %s ", sampleInfo.getInterval(), format.format(sampleInfo.getTimestamp().getTime())));
                    }
                }
            }
            PerfMetricSeries[] vals = perfMetric.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Found %s performance metric series", vals != null ? Integer.valueOf(vals.length) : "0"));
            }
            if (vals != null) {
                mi = new MetricInfo[vals.length];
                for (int i = 0; i < vals.length; ++i) {
                    if (!(vals[i] instanceof PerfMetricIntSeries)) continue;
                    PerfMetricIntSeries intVal = (PerfMetricIntSeries)vals[i];
                    long[] values = intVal.getValue();
                    long lastValue = values[values.length - 1];
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.format("Found %s values for metricId %s and instance %s", values != null ? Integer.valueOf(values.length) : "0", intVal.getId().getCounterId(), intVal.getId().getInstance()));
                    }
                    mi[i] = new MetricInfo();
                    PerfMetricId metrikId = intVal.getId();
                    mi[i].setInstance(metrikId.getInstance());
                    PerfCounterInfo counterInfo = info.get(intVal.getId().getCounterId());
                    if (counterInfo == null) {
                        mi[i].setUnit("error");
                        mi[i].setMetricKey("error");
                        mi[i].setMetric(lastValue);
                        continue;
                    }
                    ElementDescription unitInfo = counterInfo.getUnitInfo();
                    ElementDescription groupInfo = counterInfo.getGroupInfo();
                    ElementDescription nameInfo = counterInfo.getNameInfo();
                    mi[i].setUnit(unitInfo.getKey());
                    mi[i].setMetricKey(groupInfo.getKey() + "." + nameInfo.getKey() + "." + counterInfo.getRollupType().toString());
                    if ("percent".equals(mi[i].getUnit())) {
                        mi[i].setMetric(lastValue / 100L);
                    } else {
                        mi[i].setMetric(lastValue);
                    }
                    mi[i].setSampleTime(infos[infos.length - 1].getTimestamp());
                }
            }
        }
        return mi;
    }

    public static List<MetricInfo> getMetricInfo(PerfEntityMetricBase perfEntityBase, Map<Integer, PerfCounterInfo> info) throws EsxiTopException {
        ArrayList<MetricInfo> result = new ArrayList<MetricInfo>();
        if (perfEntityBase != null && perfEntityBase instanceof PerfEntityMetric) {
            PerfEntityMetric perfMetric = (PerfEntityMetric)perfEntityBase;
            PerfSampleInfo[] infos = perfMetric.getSampleInfo();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Found %s sample infos", infos != null ? Integer.valueOf(infos.length) : "0"));
                if (infos != null) {
                    for (PerfSampleInfo sampleInfo : infos) {
                        logger.debug(String.format("Sampleinfo with interval %s and timestamp %s ", sampleInfo.getInterval(), format.format(sampleInfo.getTimestamp().getTime())));
                    }
                }
            }
            PerfMetricSeries[] vals = perfMetric.getValue();
            if (logger.isDebugEnabled()) {
                logger.debug(String.format("Found %s performance metric series", vals != null ? Integer.valueOf(vals.length) : "0"));
            }
            for (PerfMetricSeries pms : vals) {
                if (!(pms instanceof PerfMetricIntSeries)) continue;
                PerfMetricIntSeries intVal = (PerfMetricIntSeries)pms;
                long[] values = intVal.getValue();
                if (logger.isDebugEnabled()) {
                    logger.debug(String.format("Found %s values for metricId %s ", values != null ? Integer.valueOf(values.length) : "0", intVal.getId().getCounterId()));
                }
                MetricInfo mi = new MetricInfo();
                PerfCounterInfo counterInfo = info.get(intVal.getId().getCounterId());
                if (counterInfo == null) {
                    mi.setUnit("error");
                    mi.setMetricKey("error");
                    mi.setMetric(values[values.length - 1]);
                } else {
                    ElementDescription unitInfo = counterInfo.getUnitInfo();
                    ElementDescription groupInfo = counterInfo.getGroupInfo();
                    ElementDescription nameInfo = counterInfo.getNameInfo();
                    mi.setUnit(unitInfo.getKey());
                    mi.setMetricKey(groupInfo.getKey() + "." + nameInfo.getKey() + "." + counterInfo.getRollupType().toString());
                    if ("percent".equals(mi.getUnit())) {
                        mi.setMetric(values[values.length - 1] / 100L);
                    } else {
                        mi.setMetric(values[values.length - 1]);
                    }
                    mi.setSampleTime(infos[infos.length - 1].getTimestamp());
                }
                result.add(mi);
            }
        }
        return result;
    }

    public static ManagedEntity[] determineManagedEntities(ServiceInstance si, String type, String name) throws EsxiTopException {
        ManagedEntity[] entities = null;
        if (type == null) {
            return entities;
        }
        Folder root = si.getRootFolder();
        InventoryNavigator inv = new InventoryNavigator((ManagedEntity)root);
        try {
            if (name == null || "*".equals(name)) {
                entities = inv.searchManagedEntities(type);
            } else {
                ManagedEntity me = inv.searchManagedEntity(type, name);
                if (me != null) {
                    entities = new ManagedEntity[]{me};
                }
            }
        }
        catch (InvalidProperty e) {
            logger.error("EsxiTop->determineManagedEntities: ", (Throwable)e);
            throw new EsxiTopException("EsxiTop->determineManagedEntities: ", e);
        }
        catch (RuntimeFault e) {
            logger.error("EsxiTop->determineManagedEntities: ", (Throwable)e);
            throw new EsxiTopException("EsxiTop->determineManagedEntities: ", e);
        }
        catch (RemoteException e) {
            logger.error("EsxiTop->determineManagedEntities: ", (Throwable)e);
            throw new EsxiTopException("EsxiTop->determineManagedEntities: ", e);
        }
        return entities;
    }

    public static HashMap<Object, Object> mergeOptions(HashMap<Object, Object> opts) {
        HashMap<Object, Object> newOpts = new HashMap<Object, Object>();
        if (opts != null) {
            Set<Object> set = opts.keySet();
            for (Object obj : set) {
                newOpts.put(obj, opts.get(obj));
            }
        }
        return newOpts;
    }

    public static PerfEntityMetricBase[] queryPerformanceManager(PerformanceManager pm, PerfQuerySpec[] querySpec) throws EsxiTopException {
        try {
            PerfEntityMetricBase[] bases = pm.queryPerf(querySpec);
            return bases;
        }
        catch (RuntimeFault e) {
            logger.error("Error query performance manager", (Throwable)e);
            throw new EsxiTopException("Error query performance manager", e);
        }
        catch (RemoteException e) {
            logger.error("Error query performance manager", (Throwable)e);
            throw new EsxiTopException("Error query performance manager", e);
        }
    }

    public static String determineHostForVm(ServerConnection conn, PerfEntityMetricBase base) {
        String hostname = null;
        if ("VirtualMachine".equals(base.getEntity().getType())) {
            VirtualMachine vm = new VirtualMachine(conn, base.getEntity());
            hostname = Utils.determineHost(conn, vm);
        }
        return hostname;
    }

    public static String determineHost(ServerConnection conn, ManagedObjectReference hostMor) {
        String hostname = null;
        HostSystem host = new HostSystem(conn, hostMor);
        hostname = host.getName();
        return hostname;
    }

    public static String determineHost(ServerConnection conn, VirtualMachine vm) {
        return Utils.determineHost(conn, vm.getRuntime().getHost());
    }

    public static String constructObject(String ... args) {
        StringBuilder builder = new StringBuilder();
        if (args != null) {
            for (String arg : args) {
                builder.append(arg);
                builder.append(":");
            }
        }
        return builder.toString();
    }

    public static String constructObject(String hostname, String entityName, String instance, String key) {
        StringBuilder builder = new StringBuilder();
        if (hostname != null) {
            builder.append(hostname);
            builder.append(":");
        }
        if (entityName != null) {
            builder.append(entityName);
            builder.append(":");
        }
        if (instance != null) {
            builder.append(instance);
            builder.append(":");
        }
        builder.append(key);
        return builder.toString();
    }
}

