/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.utils.Digest;
import com.blixx.shared.utils.MD5;
import com.blixx.shared.utils.Shabal256;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Formatter;

public class DigestUtils {
    public static void processDirectory(File dir, Digest algorithm) throws Exception {
        algorithm.update(dir.getName().getBytes());
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                DigestUtils.processDirectory(list[i], algorithm);
                continue;
            }
            DigestUtils.updateDigest(algorithm, list[i]);
        }
    }

    public static void updateDigest(Digest algorithm, File file) throws Exception {
        algorithm.update(file.getName().getBytes());
        if (file.length() == 0L) {
            return;
        }
        FileInputStream fis = new FileInputStream(file);
        BufferedInputStream bis = new BufferedInputStream(fis);
        byte[] arr = new byte[65536];
        int count = -1;
        while ((count = bis.read(arr)) != -1) {
            algorithm.update(arr, 0, count);
        }
        bis.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] file2digest(Digest algorithm, File file) throws Exception {
        algorithm = algorithm.copy();
        algorithm.reset();
        algorithm.update(file.getName().getBytes());
        if (file.length() != 0L) {
            FileInputStream fis = new FileInputStream(file);
            try (BufferedInputStream bis = new BufferedInputStream(fis);){
                byte[] arr = new byte[65536];
                int count = -1;
                while ((count = bis.read(arr)) != -1) {
                    algorithm.update(arr, 0, count);
                }
            }
        }
        return algorithm.digest();
    }

    public static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    public static String getHex(Digest algorithm) {
        byte[] hash = algorithm.digest();
        return DigestUtils.byteArray2Hex(hash);
    }

    public static void updateDisgest(Digest algorithm, InputStream is) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] arr = new byte[65536];
        int count = -1;
        while ((count = bis.read(arr)) != -1) {
            algorithm.update(arr, 0, count);
        }
        bis.close();
    }

    public static void updateDisgestKSO(Digest algorithm, InputStream is) throws Exception {
        BufferedInputStream bis = new BufferedInputStream(is);
        byte[] arr = new byte[65536];
        int count = -1;
        while ((count = bis.read(arr)) != -1) {
            algorithm.update(arr, 0, count);
        }
    }

    public static String getShabal256Hex(File file) throws Exception {
        Shabal256 sh256 = new Shabal256();
        DigestUtils.updateDigest(sh256, file);
        return DigestUtils.getHex(sh256);
    }

    public static String getShabal256Hex4Dir(File dir) throws Exception {
        Shabal256 sh256 = new Shabal256();
        DigestUtils.processDirectory(dir, sh256);
        return DigestUtils.getHex(sh256);
    }

    public static String getMD5Hex(File file) throws Exception {
        MD5 md5 = new MD5();
        DigestUtils.updateDigest(md5, file);
        return DigestUtils.getHex(md5);
    }

    public static String getMD5Hex4Dir(File dir) throws Exception {
        MD5 md5 = new MD5();
        DigestUtils.processDirectory(dir, md5);
        return DigestUtils.getHex(md5);
    }
}

