/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.utils.Digest;
import com.blixx.shared.utils.Shabal256;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;

public class FileSyncUtils {
    public static final String MARK_MODIFIED = "[M]";
    public static final String MARK_ADDED = "[A]";
    public static final String MARK_DELETED = "[D]";
    public static final String MARK_CONFLICT = "[!]";
    public static final String MARK_OK = "[OK]";
    static final byte[] DIR_STUB = "<dir>".getBytes();
    static final byte[] EMPTY_DIR_STUB = "<empty>".getBytes();
    static final String DIR_HASH = FileSyncUtils.byteArray2Hex(DIR_STUB);
    static final String EMPTY_DIR_HASH = FileSyncUtils.byteArray2Hex(EMPTY_DIR_STUB);

    public static String getDigest(File f) throws Exception {
        File[] children;
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        Shabal256 d = new Shabal256();
        if (f.isFile()) {
            m.put(f.getName(), FileSyncUtils.file2digest(d, f));
        } else if (f.isDirectory() && (children = f.listFiles()) != null) {
            for (File child : children) {
                if (child.isFile()) {
                    m.put(child.getName(), FileSyncUtils.file2digest(d, child));
                    continue;
                }
                m.putAll(FileSyncUtils.collectDirDigest(child.getName() + "/", d, child));
            }
            if (children.length == 0) {
                String name = "/";
                m.put(name, EMPTY_DIR_STUB);
            }
        }
        return FileSyncUtils.formatDigest(m);
    }

    public static String getShortDigest(File f) throws Exception {
        File[] children;
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        Shabal256 d = new Shabal256();
        if (f.isFile()) {
            m.put(f.getName(), FileSyncUtils.file2digest(d, f));
        } else if (f.isDirectory() && (children = f.listFiles()) != null) {
            for (File child : children) {
                if (child.isFile()) {
                    m.put(child.getName(), FileSyncUtils.file2digest(d, child));
                    continue;
                }
                m.put(child.getName() + "/", FileSyncUtils.dir2digest(d, child));
            }
            if (children.length == 0) {
                String name = "/";
                m.put(name, EMPTY_DIR_STUB);
            }
        }
        return FileSyncUtils.formatDigest(m);
    }

    public static String verifyDigest(File f, String digest, boolean verbose) throws Exception {
        HashMap<String, String> original = FileSyncUtils.parseDigest(digest);
        HashMap<String, String> result = new HashMap<String, String>();
        String signature = original.remove("/");
        if (signature != null) {
            assert (signature.equals(EMPTY_DIR_HASH));
            if (f.isFile()) {
                result.put("/", MARK_CONFLICT);
            } else {
                File[] children = f.listFiles();
                if (children != null) {
                    for (File child : children) {
                        String name = child.getName();
                        if (f.isDirectory()) {
                            name = name + "/";
                        }
                        result.put(name, MARK_ADDED);
                    }
                }
            }
        } else {
            Shabal256 d = new Shabal256();
            if (f.isFile()) {
                result = FileSyncUtils.verifyFileDigest(original, f.getName(), d, f);
            } else {
                File[] children = f.listFiles();
                if (children != null) {
                    for (File child : children) {
                        if (child.isFile()) {
                            result.putAll(FileSyncUtils.verifyFileDigest(original, child.getName(), d, child));
                            continue;
                        }
                        result.putAll(FileSyncUtils.verifyDirDigest(original, child.getName(), d, child));
                    }
                }
            }
        }
        for (String key : original.keySet()) {
            result.put(key, MARK_DELETED);
        }
        return FileSyncUtils.formatReport(result, verbose);
    }

    public static byte[] file2digest(Digest algorithm, File file) throws Exception {
        algorithm = algorithm.copy();
        algorithm.reset();
        FileSyncUtils.updateDigest(algorithm, file);
        return algorithm.digest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateDigest(Digest algorithm, File file) throws Exception {
        algorithm.update(file.getName().getBytes());
        if (file.length() == 0L) {
            return;
        }
        FileInputStream fis = new FileInputStream(file);
        try (BufferedInputStream bis = new BufferedInputStream(fis);){
            int count;
            byte[] arr = new byte[65536];
            while ((count = bis.read(arr)) != -1) {
                algorithm.update(arr, 0, count);
            }
        }
    }

    public static byte[] dir2digest(Digest algorithm, File dir) throws Exception {
        algorithm = algorithm.copy();
        algorithm.reset();
        FileSyncUtils.updateDigestRecursively(algorithm, dir);
        return algorithm.digest();
    }

    public static void updateDigestRecursively(Digest algorithm, File dir) throws Exception {
        algorithm.update((dir.getName() + "/").getBytes());
        Object[] children = dir.list();
        if (children != null) {
            Arrays.sort(children);
            for (Object name : children) {
                File f = new File(dir, (String)name);
                if (f.isFile()) {
                    FileSyncUtils.updateDigest(algorithm, f);
                    continue;
                }
                FileSyncUtils.updateDigestRecursively(algorithm, f);
            }
        }
    }

    public static String byteArray2Hex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte b : hash) {
            formatter.format("%02x", b);
        }
        return formatter.toString();
    }

    private static HashMap<String, String> parseDigest(String digest) {
        HashMap<String, String> result = new HashMap<String, String>();
        int i = 0;
        while (i != -1) {
            int start = i;
            int mid = digest.indexOf(10, start + 1);
            if (mid == -1) {
                throw new RuntimeException("Malformed digest string");
            }
            int end = digest.indexOf(10, mid + 1);
            if (end == -1) {
                end = digest.length();
                i = -1;
            } else {
                i = end == digest.length() - 1 ? -1 : end + 1;
            }
            String name = digest.substring(start, mid);
            String hash = digest.substring(mid + 1, end);
            result.put(name, hash);
        }
        return result;
    }

    private static HashMap<String, String> verifyFileDigest(HashMap<String, String> original, String name, Digest algorithm, File f) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String signature = original.remove(name + "/");
        if (signature != null) {
            if (original.containsKey(name)) {
                throw new RuntimeException("Invalid digest: ambiguous data for " + name);
            }
            result.put(name, MARK_CONFLICT);
            return result;
        }
        signature = original.remove(name);
        if (signature == null) {
            result.put(name, MARK_ADDED);
        } else {
            byte[] b = FileSyncUtils.file2digest(algorithm, f);
            if (!signature.equals(FileSyncUtils.byteArray2Hex(b))) {
                result.put(name, MARK_MODIFIED);
            } else {
                result.put(name, MARK_OK);
            }
        }
        return result;
    }

    private static HashMap<String, String> verifyDirDigest(HashMap<String, String> original, String name, Digest algorithm, File dir) throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        String signature = original.remove(name);
        name = name + "/";
        if (signature != null) {
            result.put(name, MARK_CONFLICT);
            return result;
        }
        signature = original.remove(name);
        if (signature == null) {
            result.put(name, MARK_ADDED);
        } else if (signature.equals(DIR_HASH)) {
            result.put(name, MARK_OK);
            File[] children = dir.listFiles();
            if (children != null) {
                for (File f : children) {
                    if (f.isFile()) {
                        result.putAll(FileSyncUtils.verifyFileDigest(original, name + f.getName(), algorithm, f));
                        continue;
                    }
                    result.putAll(FileSyncUtils.verifyDirDigest(original, name + f.getName(), algorithm, f));
                }
            }
        } else {
            String actual = FileSyncUtils.byteArray2Hex(FileSyncUtils.dir2digest(algorithm, dir));
            if (actual.equals(signature)) {
                result.put(name, MARK_OK);
            } else {
                result.put(name, MARK_MODIFIED);
            }
        }
        return result;
    }

    private static HashMap<String, byte[]> collectDirDigest(String name, Digest d, File dir) throws Exception {
        assert (name.endsWith("/"));
        HashMap<String, byte[]> m = new HashMap<String, byte[]>();
        m.put(name, DIR_STUB);
        File[] children = dir.listFiles();
        if (children != null) {
            for (File f : children) {
                if (f.isFile()) {
                    m.put(name + f.getName(), FileSyncUtils.file2digest(d, f));
                    continue;
                }
                m.putAll(FileSyncUtils.collectDirDigest(name + f.getName() + "/", d, f));
            }
        }
        return m;
    }

    private static String formatReport(HashMap<String, String> m, boolean verbose) {
        StringBuilder sb = new StringBuilder(m.size() * 256);
        for (Map.Entry<String, String> e : m.entrySet()) {
            if (!verbose && e.getValue().equals(MARK_OK)) continue;
            sb.append(e.getValue()).append(e.getKey()).append('\n');
        }
        return sb.toString();
    }

    private static String formatDigest(HashMap<String, byte[]> m) {
        StringBuilder sb = new StringBuilder(m.size() * 256);
        for (Map.Entry<String, byte[]> e : m.entrySet()) {
            sb.append(e.getKey()).append('\n').append(FileSyncUtils.byteArray2Hex(e.getValue())).append('\n');
        }
        return sb.toString();
    }
}

