/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.shared.utils;

import com.blixx.shared.os.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Set;

public class FileUtils {
    public static void copyFile(File source, File target) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target);
            int count = -1;
            byte[] buffer = new byte[2048];
            while ((count = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fis.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void appendFile(File source, File target) throws IOException {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        try {
            fis = new FileInputStream(source);
            fos = new FileOutputStream(target, true);
            int count = -1;
            byte[] buffer = new byte[2048];
            while ((count = fis.read(buffer)) != -1) {
                fos.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fis.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            fos.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String resolveEnvVars(String in) {
        Set<String> keys = System.getenv().keySet();
        for (String key : keys) {
            String val = System.getenv(key);
            if (val == null) {
                val = "";
            }
            if (SystemUtils.OS == 1) {
                in = in.replace("%" + key + "%", val);
                continue;
            }
            in = in.replace("${" + key + "}", val);
            in = in.replace("$" + key, val);
        }
        return in;
    }

    public static void deleteDirectoryRecursive(String dirPath) throws IOException {
        File dir = new File(dirPath);
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isFile()) {
                    files[i].delete();
                    continue;
                }
                FileUtils.deleteDirectoryRecursive(files[i].getCanonicalPath());
                files[i].delete();
            }
        }
    }
}

