/*
 * Decompiled with CFR 0.152.
 */
package com.bes.utils;

import com.blixx.log.RTLogger;
import com.blixx.shared.Base64Coder;
import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.io.CharArrayWriter;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class CommTokenManager {
    private static final byte _29 = 29;
    private static final byte _223 = -33;
    private static final byte _182 = -74;
    private static final byte _250 = -6;
    private static final byte _56 = 56;
    private static final byte _167 = -89;
    static byte[] SCOPE = new byte[]{-89, 56, 29, -6, -33, -89, 56, 29, -6, -74, -33, -89, 56, 29, -6, -74};
    static byte[] SCOPE2 = new byte[]{-116, 77, 33, 102, -33, -89, 56, 29, -116, 77, 33, 102, 56, 29, -6, -74};
    static byte[] SALT = new byte[]{-89, 56, 29, -6, 56, 29, -6, -74};
    static int iterationCount = 19;
    static final String AES_ECB_PKCS_5_PADDING = "AES/ECB/PKCS5Padding";
    static final String AES_GCM = "AES/GCM/NoPadding";
    private static final int AES_GCM_TAG_SIZE = 128;
    static final int AES_GCM_SALTSIZE = 13;
    private static Key secretKeyV1;
    private static SecretKeySpec secretKeyV2;
    private static String secretV1;

    static {
        secretV1 = "";
    }

    private CommTokenManager() {
    }

    private static String generateSecret() {
        if (!secretV1.isEmpty()) {
            return secretV1;
        }
        String in = "385371374392410421409382373358370415405373374388";
        int d = 0;
        byte[] mass = new byte[in.length() / 3];
        int i = 0;
        while (i < in.length()) {
            String t = in.substring(i, i + 3);
            int v = Integer.parseInt(t) - 305;
            mass[d] = (byte)v;
            ++d;
            i += 3;
        }
        secretV1 = new String(mass);
        return secretV1;
    }

    public static String generateHash(String date, String pass) {
        String result = "";
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.update(pass.getBytes());
            byte[] bytes = digest.digest(date.getBytes());
            StringBuilder sb = new StringBuilder();
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte aByte = byArray[n2];
                sb.append(Integer.toString((aByte & 0xFF) + 256, 16).substring(1));
                ++n2;
            }
            result = sb.toString();
        }
        catch (NoSuchAlgorithmException e) {
            RTLogger.print(3, "No such algorithim", e);
        }
        return result;
    }

    public static SecretKeySpec getKeyV3(String myKey) {
        MessageDigest sha = null;
        try {
            byte[] key = myKey.getBytes(StandardCharsets.UTF_8);
            sha = MessageDigest.getInstance("SHA-1");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            return new SecretKeySpec(key, "AES");
        }
        catch (NoSuchAlgorithmException e) {
            RTLogger.print(3, "No such algorithim", e);
            return null;
        }
    }

    public static void setKeyV1(String myKey) {
        if (secretKeyV1 != null) {
            return;
        }
        try {
            CharArrayWriter wr = new CharArrayWriter();
            wr.append('s');
            wr.append('f');
            wr.append('x');
            wr.append('d');
            wr.append('s');
            wr.append('f');
            wr.append('x');
            PBEKeySpec keySpec = new PBEKeySpec(wr.toCharArray(), SALT, iterationCount);
            secretKeyV1 = SecretKeyFactory.getInstance(myKey).generateSecret(keySpec);
        }
        catch (NoSuchAlgorithmException e) {
            RTLogger.print(3, "No such algorithim", e);
        }
        catch (InvalidKeySpecException e) {
            RTLogger.print(3, "Invalid KeySpec", e);
        }
    }

    public static void setKeyV2() {
        if (secretKeyV2 != null) {
            return;
        }
        secretKeyV2 = new SecretKeySpec(SCOPE2, "AES");
    }

    public static byte[] encryptV1(byte[] toEnc) {
        return toEnc == null ? null : CommTokenManager.encryptV1(toEnc, 0, toEnc.length);
    }

    public static byte[] encryptV1(byte[] toEnc, int start, int length) {
        try {
            String secret = CommTokenManager.generateSecret();
            CommTokenManager.setKeyV1(secret);
            Cipher cipher = Cipher.getInstance(secret);
            PBEParameterSpec paramSpec = new PBEParameterSpec(SALT, iterationCount);
            cipher.init(1, secretKeyV1, paramSpec);
            return cipher.doFinal(toEnc, start, length);
        }
        catch (Exception e) {
            RTLogger.print(3, "Error on Encryption : ", e.getMessage());
            return null;
        }
    }

    public static byte[] encryptV2(byte[] toEnc) {
        return toEnc == null ? null : CommTokenManager.encryptV2(toEnc, 0, toEnc.length);
    }

    public static byte[] encryptV2(byte[] toEnc, int start, int length) {
        try {
            CommTokenManager.setKeyV2();
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(1, secretKeyV2);
            return cipher.doFinal(toEnc, start, length);
        }
        catch (Exception e) {
            RTLogger.print(3, e.getMessage());
            return null;
        }
    }

    public static String encryptV3(String strToEncrypt, String secret) {
        if (strToEncrypt == null) {
            return null;
        }
        byte[] array = strToEncrypt.getBytes(StandardCharsets.UTF_8);
        byte[] encArray = CommTokenManager.encryptV3(array, secret, 0, array.length);
        return encArray == null ? null : new String(Base64Coder.encodeLines(encArray));
    }

    public static byte[] encryptV3(byte[] toEnc, String secret) {
        return toEnc == null ? null : CommTokenManager.encryptV3(toEnc, secret, 0, toEnc.length);
    }

    public static byte[] encryptV3(byte[] toEnc, String secret, int start, int length) {
        SecretKeySpec secretKeyV3;
        block3: {
            try {
                secretKeyV3 = CommTokenManager.getKeyV3(secret);
                if (secretKeyV3 != null) break block3;
                return null;
            }
            catch (Exception e) {
                RTLogger.print(3, e.getMessage());
                return null;
            }
        }
        Cipher cipher = Cipher.getInstance(AES_ECB_PKCS_5_PADDING);
        cipher.init(1, secretKeyV3);
        return cipher.doFinal(toEnc, start, length);
    }

    public static String decryptV3(String strToDecrypt, String secret) {
        if (strToDecrypt == null) {
            return null;
        }
        String noNlStr = strToDecrypt.replace("\\r\\n", "").replace("\r\n", "").trim();
        byte[] decr = CommTokenManager.decryptV3(Base64Coder.decodeLines(noNlStr), secret);
        return decr == null ? "" : new String(decr);
    }

    public static byte[] decryptV3(byte[] toDec, String secret) {
        SecretKeySpec secretKeyV3;
        block3: {
            try {
                secretKeyV3 = CommTokenManager.getKeyV3(secret);
                if (secretKeyV3 != null) break block3;
                return null;
            }
            catch (Exception e) {
                RTLogger.print(3, e.getMessage());
                return null;
            }
        }
        Cipher cipher = Cipher.getInstance(AES_ECB_PKCS_5_PADDING);
        cipher.init(2, secretKeyV3);
        return cipher.doFinal(toDec);
    }

    public static byte[] decryptV1(byte[] toDec) {
        try {
            PBEParameterSpec paramSpec = new PBEParameterSpec(SALT, iterationCount);
            String secret = CommTokenManager.generateSecret();
            CommTokenManager.setKeyV1(secret);
            Cipher cipher = Cipher.getInstance(secret);
            cipher.init(2, secretKeyV1, paramSpec);
            return cipher.doFinal(toDec);
        }
        catch (Exception e) {
            RTLogger.print(3, "Error on Decryption : ", e.getMessage());
            return null;
        }
    }

    public static byte[] decryptV2(byte[] toDec) {
        try {
            CommTokenManager.setKeyV2();
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(2, secretKeyV2);
            return cipher.doFinal(toDec);
        }
        catch (Exception e) {
            RTLogger.print(3, "Error on Decryption : ", e.getMessage());
            return null;
        }
    }

    public static int extractOffset(String data) {
        if (data == null) {
            RTLogger.print(3, "Error while resolving hash: data can not be null");
            return -1;
        }
        if (data.length() < 65) {
            RTLogger.print(3, "Error while resolving offset: datalenght must be longer than 65");
            return -1;
        }
        try {
            String offset = data.substring(64, data.length());
            return Integer.parseInt(offset);
        }
        catch (Exception e) {
            RTLogger.print(3, e.getMessage());
            return -1;
        }
    }

    public static String extractHash(String data) {
        if (data == null) {
            RTLogger.print(3, "Error while resolving hash: data can not be null");
            return "";
        }
        if (data.length() < 65) {
            RTLogger.print(3, "Error while resolving hash: datalenght must be longer than 65");
            return "";
        }
        try {
            return data.substring(0, 64);
        }
        catch (Exception e) {
            RTLogger.print(3, e.getMessage());
            return "";
        }
    }

    public static String generateNextToken(String currentToken, String pass) {
        String decrypted = CommTokenManager.decryptV4(currentToken, pass);
        String currentHash = CommTokenManager.extractHash(decrypted);
        int currentOffset = CommTokenManager.extractOffset(decrypted);
        int nextOffset = currentOffset + 1;
        String nextHash = CommTokenManager.generateHash(currentHash, pass);
        String toEncrypt = String.valueOf(nextHash) + nextOffset;
        return CommTokenManager.encryptV4(toEncrypt, pass);
    }

    public static String getHashByOffset(String startingPoint, String pass, int tokenOffset) {
        String hash = CommTokenManager.generateHash(startingPoint, pass);
        int i = 0;
        while (i < tokenOffset) {
            hash = CommTokenManager.generateHash(hash, pass);
            ++i;
        }
        return hash;
    }

    public static String encryptV4(String strToEncrypt, String secret) {
        if (strToEncrypt == null) {
            return null;
        }
        byte[] array = strToEncrypt.getBytes(StandardCharsets.UTF_8);
        byte[] encArray = CommTokenManager.encryptV4(array, secret, 0, array.length);
        return encArray == null ? null : Base64.encode(encArray);
    }

    public static byte[] encryptV4(byte[] plaintext, String key) {
        if (plaintext == null) {
            return null;
        }
        return CommTokenManager.encryptV4(plaintext, key, 0, plaintext.length);
    }

    public static byte[] encryptV4(byte[] plaintext, String key, int start, int length) {
        if (key == null) {
            return null;
        }
        try {
            SecureRandom rand = new SecureRandom();
            byte[] nonce = new byte[13];
            rand.nextBytes(nonce);
            PBEKeySpec pwSpec = new PBEKeySpec(key.toCharArray(), SCOPE2, iterationCount, 128);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            byte[] keyArr = keyFactory.generateSecret(pwSpec).getEncoded();
            Cipher cipher = Cipher.getInstance(AES_GCM);
            cipher.init(1, (Key)new SecretKeySpec(keyArr, "AES"), new GCMParameterSpec(128, nonce));
            byte[] ciphertext = cipher.doFinal(plaintext, start, length);
            byte[] ciphertextAndNonce = new byte[nonce.length + ciphertext.length];
            System.arraycopy(nonce, 0, ciphertextAndNonce, 0, nonce.length);
            System.arraycopy(ciphertext, 0, ciphertextAndNonce, nonce.length, ciphertext.length);
            return ciphertextAndNonce;
        }
        catch (Exception e) {
            RTLogger.print(5, "", e);
            return null;
        }
    }

    public static String decryptV4(String strToDecrypt, String secret) {
        if (strToDecrypt == null) {
            return null;
        }
        String noNlStr = strToDecrypt.replace("\\r\\n", "").replace("\r\n", "").trim();
        byte[] decr = CommTokenManager.decryptV4(Base64Coder.decodeLines(noNlStr), secret);
        return decr == null ? "" : new String(decr);
    }

    public static byte[] decryptV4(byte[] ciphertextAndNonce, String key) {
        if (key == null) {
            return null;
        }
        try {
            byte[] nonce = new byte[13];
            byte[] ciphertext = new byte[ciphertextAndNonce.length - 13];
            System.arraycopy(ciphertextAndNonce, 0, nonce, 0, nonce.length);
            System.arraycopy(ciphertextAndNonce, nonce.length, ciphertext, 0, ciphertext.length);
            PBEKeySpec pwSpec = new PBEKeySpec(key.toCharArray(), SCOPE2, iterationCount, 128);
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            byte[] keyArr = keyFactory.generateSecret(pwSpec).getEncoded();
            Cipher cipher = Cipher.getInstance(AES_GCM);
            cipher.init(2, (Key)new SecretKeySpec(keyArr, "AES"), new GCMParameterSpec(128, nonce));
            return cipher.doFinal(ciphertext);
        }
        catch (Exception e) {
            RTLogger.print(5, "", e);
            return null;
        }
    }
}

