/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.log.RTLogger;
import com.blixx.shared.User;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;

public class DNDSourceTreeProcessor
implements DragSourceListener {
    private TreeViewer m_tree = null;
    private ArrayList<GroupTreeObjectLast> m_elements;

    public DNDSourceTreeProcessor(TreeViewer tv) {
        this.m_tree = tv;
    }

    public void dragFinished(DragSourceEvent event) {
        RTLogger.print(5, "Finished.");
    }

    public void dragSetData(DragSourceEvent event) {
        event.data = this.m_elements;
        RTLogger.print(5, "Set data. " + event);
    }

    public void dragStart(DragSourceEvent event) {
        if (Repository.getInstance().getRights(1004) < 3) {
            RTLogger.print(5, "READ-ONLY! user has no rights to change user management.");
            event.doit = false;
            return;
        }
        TreeSelection sel = (TreeSelection)this.m_tree.getSelection();
        if (sel.isEmpty()) {
            event.doit = false;
            RTLogger.print(5, "dnd has no selection.");
        } else if (!this.m_tree.getTree().isFocusControl()) {
            event.doit = false;
            RTLogger.print(5, "dnd has no focus.");
        } else {
            Iterator it = sel.iterator();
            this.m_elements = new ArrayList();
            while (it.hasNext()) {
                Object te = it.next();
                if (te instanceof GroupTreeObjectLast) {
                    GroupTreeObjectLast gtol = (GroupTreeObjectLast)te;
                    User user = ((UserTreeObject)gtol.getTreeObject()).getUserObject();
                    if (user.m_roleName.equals(UserManager.ADMINISTRATOR) && (user.m_loginName.equalsIgnoreCase(UserManager.ADMIN) || user.m_loginName.equalsIgnoreCase(UserManager.ADMINISTRATOR))) {
                        event.doit = false;
                        new ShowMessageBox("  Move Users", "Not allowed to move the user '" + user.m_loginName + "'!", 2);
                        break;
                    }
                    this.m_elements.add((GroupTreeObjectLast)te);
                    continue;
                }
                if (te instanceof GroupTreeObject) {
                    event.doit = false;
                    break;
                }
                event.doit = false;
                break;
            }
            if (this.m_elements.size() > 0) {
                event.data = this.m_elements;
            } else {
                event.doit = false;
            }
        }
    }
}

