/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.Repository;
import com.blixx.log.RTLogger;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Shell;

public class DNDTargetTreeProcessor
implements DropTargetListener {
    private TreeViewer m_tree = null;
    private ArrayList<GroupTreeObjectLast> m_elements = new ArrayList();

    public DNDTargetTreeProcessor(TreeViewer tv) {
        this.m_tree = tv;
    }

    public void dragEnter(DropTargetEvent event) {
        RTLogger.print(5, "de " + event.item);
        TreeSelection sel = (TreeSelection)this.m_tree.getSelection();
        Iterator it = sel.iterator();
        this.m_elements = new ArrayList();
        while (it.hasNext()) {
            Object te = it.next();
            if (!(te instanceof GroupTreeObjectLast)) continue;
            this.m_elements.add((GroupTreeObjectLast)te);
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        Object data;
        event.feedback = 24;
        if (Repository.getInstance().getRights(1004) < 3) {
            RTLogger.print(5, "READ-ONLY! user has no rights to change user management.");
            event.detail = 0;
            return;
        }
        event.detail = event.item != null ? ((data = event.item.getData()) instanceof GroupTreeObject && !(data instanceof GroupTreeObjectLast) ? 2 : 0) : 0;
    }

    public void drop(DropTargetEvent event) {
        RTLogger.print(5, "drop " + event.item);
        Object data = event.item.getData();
        GroupTreeObject target = (GroupTreeObject)data;
        String targetRole = target.getName();
        UserRole role = Repository.getInstance().getUserManager().getRoleByName(targetRole);
        if (role != null) {
            ArrayList<User> users = new ArrayList<User>(this.m_elements.size());
            int i = 0;
            while (i < this.m_elements.size()) {
                GroupTreeObjectLast user_gtol = this.m_elements.get(i);
                User user = ((UserTreeObject)user_gtol.getTreeObject()).getUserObject();
                if (!user.m_roleName.equals(UserManager.ADMINISTRATOR) || !user.m_loginName.equalsIgnoreCase(UserManager.ADMIN) && !user.m_loginName.equalsIgnoreCase(UserManager.ADMINISTRATOR)) {
                    String cfr_ignored_0 = user.m_roleName;
                    user.m_roleName = role.getName();
                    user.m_roleID = role.getID();
                    users.add(user);
                }
                ++i;
            }
            Repository.getInstance().getUserManager().saveUsers(users);
        } else {
            RTLogger.print(5, "error moving user (DND) target Role " + targetRole + " does not exist");
            MessageDialog.openError((Shell)this.m_tree.getControl().getShell(), (String)"  Error", (String)"Cannot move user. User Role does not exist!");
        }
    }

    public void dropAccept(DropTargetEvent event) {
        Object data = event.item.getData();
        GroupTreeObject target = (GroupTreeObject)data;
        Iterator<GroupTreeObjectLast> it = this.m_elements.iterator();
        while (it.hasNext()) {
            GroupTreeObjectLast gl = it.next();
            if (target.getChild(gl.getName(), gl.getType()) == null) continue;
            it.remove();
        }
        if (this.m_elements.size() == 0) {
            event.detail = 0;
        }
    }
}

