/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.gui.Application;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.shared.BM;
import com.blixx.shared.os.SystemUtils;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LoginDialog2
implements ModifyListener,
SelectionListener,
KeyListener {
    public static String BUTTON_CANCEL = "cancel";
    public static String BUTTON_LOGIN = "login";
    public static String USERNAME = "username";
    public static String PASSWORD = "password";
    public static String HOSTPORT = "HostPort";
    private static String MAINTENANCE_MODE_CHK = "MAINTENANCE_MODE_CHK";
    private static String IGNORE_CLOSED_CHK = "IGNORE_CLOSED_CHK";
    private static String IGNORE_ALL_CHK = "IGNORE_ALL_CHK";
    public Composite m_comp_Login = null;
    public GUIDisplayElements m_guiElements = null;
    private String m_password = null;
    private String m_username = null;
    private String m_host = BMUI.localhost;
    private int m_port = BMUI.port;
    private List<String> m_hostPortList = null;
    private Display m_display = null;
    public Shell m_shell = null;
    private Text m_password_field = null;
    private Text m_username_field = null;
    private String m_errorText = null;
    private CLabel m_status_label = null;
    private CCombo m_hostPortCombo = null;
    private Button m_login_button = null;
    private Button m_cleanModeCheck = null;
    private Button m_ignoreClosedIndi = null;
    private Button m_ignoreAllIndi = null;

    public LoginDialog2(Display display, String errorText, String host, int port, String login, String password) {
        this.m_display = display;
        if (host != null) {
            this.m_host = host;
        }
        this.m_port = port;
        this.m_errorText = errorText;
        this.m_username = login;
        this.m_password = password;
    }

    public void createContents(List<String> hostPortList) {
        this.m_hostPortList = hostPortList;
        this.m_guiElements = new GUIDisplayElements();
        this.m_shell = new Shell(this.m_display, 16392);
        FillLayout fillLayout = new FillLayout();
        fillLayout.marginHeight = 0;
        this.m_shell.setLayout((Layout)fillLayout);
        Composite composite = new Composite((Composite)this.m_shell, 0);
        GridLayout gridLayout = new GridLayout();
        composite.setLayout((Layout)gridLayout);
        this.setBackgroundImage(composite);
        this.m_comp_Login = new Composite(composite, 0);
        this.m_comp_Login.setBackground(BMUI.color_darkGrey);
        RowLayout rowLayout = new RowLayout();
        rowLayout.fill = true;
        this.m_comp_Login.setLayout((Layout)rowLayout);
        GridData gridData = new GridData(4, 128, false, false);
        gridData.widthHint = 196;
        gridData.heightHint = 403;
        gridData.verticalIndent = 0;
        gridData.horizontalIndent = 385;
        this.m_comp_Login.setLayoutData((Object)gridData);
        this.createHostPortCombo(this.m_comp_Login);
        this.m_username_field = this.createUserNameField(this.m_comp_Login);
        this.m_password_field = this.createPasswordField(this.m_comp_Login);
        this.m_username_field.setFocus();
        this.m_username_field.addKeyListener((KeyListener)this);
        this.m_password_field.addKeyListener((KeyListener)this);
        Composite comp_ButtonBar = new Composite(this.m_comp_Login, 0);
        comp_ButtonBar.setBackground(BMUI.color_darkGrey);
        RowData rowData = new RowData();
        rowData.width = 175;
        rowData.height = 45;
        comp_ButtonBar.setLayoutData((Object)rowData);
        comp_ButtonBar.setLayout((Layout)new FormLayout());
        this.createCancelButton(comp_ButtonBar);
        this.createLoginButton(comp_ButtonBar);
        this.createExtendedLoginSection(this.m_comp_Login);
        Region region = new Region();
        Rectangle pixel = new Rectangle(1, 1, 567, 403);
        region.add(pixel);
        this.m_shell.setRegion(region);
        this.addDragListener(composite, this.m_shell);
        this.m_shell.setSize(567, 403);
        Monitor primary = Display.getCurrent().getPrimaryMonitor();
        Rectangle bounds = primary.getBounds();
        Rectangle rect = this.m_shell.getBounds();
        int x = bounds.x + (bounds.width - rect.width) / 2;
        int y = bounds.y + (bounds.height - rect.height) / 2;
        if (SystemUtils.UNIX_WHO == 4) {
            this.m_shell.setLocation(x, y - 120 * primary.getClientArea().height / 1024);
        } else {
            this.m_shell.setLocation(x, y);
        }
        this.m_shell.open();
        while (!this.m_shell.isDisposed()) {
            if (this.m_display.readAndDispatch()) continue;
            this.m_display.sleep();
        }
        region.dispose();
    }

    private void setBackgroundImage(Composite comp) {
        Image image = BMUI.IMAGE_OWL;
        comp.setBackgroundImage(image);
    }

    private Text createUserNameField(Composite comp) {
        CLabel cLabel = new CLabel(comp, 0);
        RowData rd_label = new RowData();
        rd_label.width = 175;
        rd_label.height = 15;
        cLabel.setLayoutData((Object)rd_label);
        cLabel.setBackground(BMUI.color_darkGrey);
        cLabel.setForeground(BMUI.color_splash_dark_blue);
        cLabel.setText("Username");
        Text text = new Text(comp, 2048);
        BMUI.setDefaultBackground(text.getBackground());
        BMUI.setDefaultForeground(text.getForeground());
        RowData rd_text = new RowData();
        rd_text.width = 160;
        rd_text.height = 12;
        text.setLayoutData((Object)rd_text);
        text.setData((Object)USERNAME);
        if (this.m_username != null) {
            text.setText(this.m_username);
        }
        text.addModifyListener((ModifyListener)this);
        return text;
    }

    private CCombo createHostPortCombo(Composite parent) {
        this.m_status_label = new CLabel(parent, 256);
        RowData rd_label = new RowData();
        rd_label.width = 171;
        rd_label.height = 15;
        this.m_status_label.setAlignment(131072);
        this.m_status_label.setLayoutData((Object)rd_label);
        this.m_status_label.setBackground(BMUI.color_white);
        this.m_status_label.setForeground(BMUI.color_critical);
        this.m_status_label.setFont(BMUI.font_arial7_bold);
        this.m_status_label.setText(this.m_errorText);
        CLabel cLabel = new CLabel(parent, 0);
        rd_label = new RowData();
        rd_label.width = 175;
        rd_label.height = 15;
        cLabel.setLayoutData((Object)rd_label);
        cLabel.setBackground(BMUI.color_darkGrey);
        cLabel.setForeground(BMUI.color_splash_dark_blue);
        cLabel.setText("Host:Port");
        Composite comp = new Composite(parent, 0);
        RowLayout rl = new RowLayout();
        rl.marginTop = 0;
        rl.marginRight = 0;
        rl.marginBottom = 0;
        rl.marginLeft = 0;
        rl.spacing = 1;
        rl.fill = true;
        comp.setLayout((Layout)rl);
        this.m_hostPortCombo = new CCombo(comp, 2052);
        this.m_hostPortCombo.setBackground(BMUI.color_white);
        RowData rowData = new RowData();
        rowData.width = 153;
        rowData.height = 15;
        this.m_hostPortCombo.setLayoutData((Object)rowData);
        this.m_hostPortCombo.setData((Object)HOSTPORT);
        this.m_hostPortCombo.setItems(this.getHostPortStringList());
        if (this.m_errorText == null) {
            this.m_hostPortCombo.select(0);
        } else {
            int selIndex = this.getHostPortIndex(String.valueOf(this.m_host) + ":" + this.m_port);
            if (selIndex == -1) {
                this.m_hostPortCombo.setText(String.valueOf(this.m_host) + ":" + this.m_port);
            } else {
                this.m_hostPortCombo.select(selIndex);
            }
        }
        this.m_hostPortCombo.addModifyListener((ModifyListener)this);
        this.m_hostPortCombo.addKeyListener((KeyListener)this);
        GUIDisplayElements gui = new GUIDisplayElements();
        gui.addDefaultTextContentMenu(this.m_hostPortCombo, false);
        Label delIcon = new Label(comp, 0);
        delIcon.setImage(BMUI.IMAGE_DEL_SMALL);
        delIcon.setBackground(BMUI.color_darkGrey);
        delIcon.setToolTipText("Remove Host from List");
        delIcon.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                String hostPort = LoginDialog2.this.m_hostPortCombo.getText();
                if (LoginDialog2.this.m_hostPortList.contains(hostPort)) {
                    LoginDialog2.this.m_hostPortList.remove(hostPort);
                    if (LoginDialog2.this.m_hostPortList.isEmpty()) {
                        LoginDialog2.this.m_hostPortList.add(String.valueOf(BMUI.localhost) + ":" + BMUI.port);
                    }
                    LoginDialog2.this.m_hostPortCombo.setItems(LoginDialog2.this.getHostPortStringList());
                    LoginDialog2.this.m_hostPortCombo.select(0);
                    Application.saveHostPortList(LoginDialog2.this.m_hostPortList, (String)LoginDialog2.this.m_hostPortList.get(0));
                }
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        return this.m_hostPortCombo;
    }

    public List<String> getHostPortList() {
        return this.m_hostPortList;
    }

    private String[] getHostPortStringList() {
        String[] hostPortList = new String[this.m_hostPortList.size()];
        int count = 0;
        Iterator<String> it = this.m_hostPortList.iterator();
        while (it.hasNext()) {
            hostPortList[count] = it.next();
            ++count;
        }
        return hostPortList;
    }

    private int getHostPortIndex(String hostPort) {
        int index = -1;
        String[] valueList = this.m_hostPortCombo.getItems();
        int i = 0;
        while (i < valueList.length) {
            if (valueList[i].equals(hostPort)) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    private Text createPasswordField(Composite comp) {
        CLabel cLabel = new CLabel(comp, 0);
        RowData rd_label = new RowData();
        rd_label.width = 175;
        rd_label.height = 15;
        cLabel.setLayoutData((Object)rd_label);
        cLabel.setBackground(BMUI.color_darkGrey);
        cLabel.setForeground(BMUI.color_splash_dark_blue);
        cLabel.setText("Password");
        Text text = new Text(comp, 2048);
        RowData rd_text = new RowData();
        rd_text.width = 160;
        rd_text.height = 12;
        text.setLayoutData((Object)rd_text);
        text.setData((Object)PASSWORD);
        text.setEchoChar('*');
        if (this.m_password != null) {
            text.setText(this.m_password);
        }
        text.addModifyListener((ModifyListener)this);
        return text;
    }

    private void createExtendedLoginSection(Composite comp) {
        Composite mainComp = new Composite(comp, 0);
        mainComp.setBackground(BMUI.color_darkGrey);
        ExpandBar expandedBar = new ExpandBar(mainComp, 512);
        expandedBar.setBackground(BMUI.color_darkGrey);
        expandedBar.setFont(BMUI.font_arial8);
        expandedBar.setSize(175, 100);
        expandedBar.setSpacing(0);
        Composite extendedLoginComp = new Composite((Composite)expandedBar, 0);
        extendedLoginComp.setBackground(BMUI.color_darkGrey);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginBottom = 5;
        gl.marginLeft = 5;
        extendedLoginComp.setLayout((Layout)gl);
        extendedLoginComp.setLayoutData((Object)new GridData(4, 128, true, false));
        this.m_cleanModeCheck = new Button(extendedLoginComp, 32);
        this.m_cleanModeCheck.setBackground(BMUI.color_darkGrey);
        this.m_cleanModeCheck.setData((Object)MAINTENANCE_MODE_CHK);
        this.m_cleanModeCheck.addKeyListener((KeyListener)this);
        this.m_cleanModeCheck.addSelectionListener((SelectionListener)this);
        Label text = new Label(extendedLoginComp, 0);
        text.setText("Maintenance Mode");
        text.setBackground(BMUI.color_darkGrey);
        this.m_ignoreClosedIndi = new Button(extendedLoginComp, 32);
        this.m_ignoreClosedIndi.setBackground(BMUI.color_darkGrey);
        this.m_ignoreClosedIndi.setData((Object)IGNORE_CLOSED_CHK);
        this.m_ignoreClosedIndi.addKeyListener((KeyListener)this);
        this.m_ignoreClosedIndi.addSelectionListener((SelectionListener)this);
        Label ignoreClosedLabel = new Label(extendedLoginComp, 0);
        ignoreClosedLabel.setText("Ignore Closed Indications");
        ignoreClosedLabel.setBackground(BMUI.color_darkGrey);
        this.m_ignoreAllIndi = new Button(extendedLoginComp, 32);
        this.m_ignoreAllIndi.setBackground(BMUI.color_darkGrey);
        this.m_ignoreAllIndi.setData((Object)IGNORE_ALL_CHK);
        this.m_ignoreAllIndi.addKeyListener((KeyListener)this);
        this.m_ignoreAllIndi.addSelectionListener((SelectionListener)this);
        Label ignoreAllIndiLabel = new Label(extendedLoginComp, 0);
        ignoreAllIndiLabel.setText("Ignore all Indications");
        ignoreAllIndiLabel.setBackground(BMUI.color_darkGrey);
        ExpandItem expItem1 = new ExpandItem(expandedBar, 0);
        expItem1.setText("Extended Login               ");
        expItem1.setHeight(extendedLoginComp.computeSize((int)-1, (int)-1).y);
        expItem1.setControl((Control)extendedLoginComp);
        expItem1.setExpanded(false);
    }

    private Button createLoginButton(Composite comp) {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.left = new FormAttachment(100, -55);
        this.m_login_button = new Button(comp, 0x800000);
        this.m_login_button.setLayoutData((Object)formData);
        this.m_login_button.setText("Login");
        this.m_login_button.setData((Object)BUTTON_LOGIN);
        this.m_login_button.addSelectionListener((SelectionListener)this);
        return this.m_login_button;
    }

    private Button createCancelButton(Composite comp) {
        FormData fData = new FormData();
        fData.top = new FormAttachment(0, 5);
        fData.right = new FormAttachment(100, -60);
        fData.left = new FormAttachment(100, -115);
        Button button = new Button(comp, 0x800000);
        button.setLayoutData((Object)fData);
        button.setText("Cancel");
        button.setData((Object)BUTTON_CANCEL);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    public void addDragListener(Composite composite, final Shell shell) {
        Listener l = new Listener(){
            Point origin;

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 3: {
                        this.origin = new Point(e.x, e.y);
                        break;
                    }
                    case 4: {
                        this.origin = null;
                        break;
                    }
                    case 5: {
                        if (this.origin == null) break;
                        Point p = LoginDialog2.this.m_display.map((Control)shell, null, e.x, e.y);
                        shell.setLocation(p.x - this.origin.x, p.y - this.origin.y);
                    }
                }
            }
        };
        composite.addListener(3, l);
        composite.addListener(4, l);
        composite.addListener(5, l);
    }

    public void modifyText(ModifyEvent e) {
        CCombo combo;
        String fieldName = "";
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)obj;
            fieldName = (String)field.getData();
            if (fieldName.equals(USERNAME)) {
                this.m_username = this.m_username_field.getText().trim();
            } else if (fieldName.equals(PASSWORD)) {
                this.m_password = this.m_password_field.getText().trim();
            }
        } else if (obj instanceof CCombo && (fieldName = (String)(combo = (CCombo)obj).getData()).equals(HOSTPORT)) {
            this.setHostAndPort();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.getSource() instanceof Button) {
            Button b = (Button)e.getSource();
            String buttonName = (String)b.getData();
            if (buttonName.equals(MAINTENANCE_MODE_CHK)) {
                BMUI.m_cleaningMode = b.getSelection();
                this.m_guiElements.enableField(this.m_ignoreAllIndi, !BMUI.m_cleaningMode);
                this.m_guiElements.enableField(this.m_ignoreClosedIndi, !BMUI.m_cleaningMode);
            } else if (buttonName.equals(IGNORE_CLOSED_CHK)) {
                BMUI.m_ignoreClosedIndications = b.getSelection();
                if (BMUI.m_ignoreClosedIndications) {
                    this.m_ignoreAllIndi.setSelection(false);
                }
            } else if (buttonName.equals(IGNORE_ALL_CHK)) {
                BMUI.m_ignoreAllIndications = b.getSelection();
                if (BMUI.m_ignoreAllIndications) {
                    this.m_ignoreClosedIndi.setSelection(false);
                }
            } else if (buttonName.equals(BUTTON_CANCEL)) {
                this.m_shell.close();
                System.exit(0);
            } else if (buttonName.equals(BUTTON_LOGIN)) {
                this.setHostAndPort();
                this.connect();
            }
        }
    }

    public void connect() {
        this.m_status_label.setText("connecting ...");
        this.m_status_label.setFont(BMUI.font_arial7_bold);
        this.m_status_label.setForeground(BMUI.color_black);
        this.m_status_label.update();
        this.m_login_button.setEnabled(false);
        try {
            Thread.sleep(400L);
        }
        catch (InterruptedException interruptedException) {}
        this.m_shell.close();
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getUsername() {
        return this.m_username;
    }

    public String getHost() {
        return this.m_host;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setHostAndPort() {
        String hostPort = this.m_hostPortCombo.getText().trim();
        String[] hp = hostPort.split("\\Q:\\E");
        if (hp.length > 0) {
            this.m_host = hp[0];
            if (hp.length == 2) {
                try {
                    this.m_port = Integer.parseInt(hp[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    this.m_hostPortCombo.setText(String.valueOf(this.m_host) + ":" + this.m_port);
                }
            } else if (hp.length == 1) {
                this.m_port = BM.CLIENT_PORT;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        if (e.character == '\r' || e.keyCode == 13 || e.keyCode == 0x1000050) {
            this.connect();
        }
    }

    public void keyPressed(KeyEvent e) {
    }
}

