/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.dialogs.SelectInTreeDialog;
import com.blixx.boom.gui.policies.PolicyManager;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.shared.pg.ObjectType;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.pg.PGEntityPermissionFlag;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.pg.PowerGroup;
import com.blixx.shared.utils.GroupTreeObject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PGItemDialog
extends StatusDialog
implements ModifyListener,
SelectionListener {
    private static final String PATH = "PATH";
    private static final String TYPE = "TYPE";
    private static final String ACTION = "ACTION";
    private static final String PRIVILEGEDFLAG = "PRIVILEGEDFLAG";
    public Composite m_dialogArea = null;
    private GUIDisplayElements m_guiElements = null;
    private String m_permissionChar = "+";
    private String m_action = PGEntityAction.MODIFY.name();
    private String m_policyTreePath = "//root/Policies";
    private String m_type = "pol";
    private PowerGroup m_pg = null;
    private PGItem m_orig = null;
    private CCombo m_actionCombo = null;

    public PGItemDialog(Shell parent, PowerGroup pg, PGItem item) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle("  Privileged Group Item");
        this.m_pg = pg;
        try {
            if (item != null) {
                this.m_permissionChar = item.getPermFlag().getChar();
                this.m_action = item.getAction().name();
                this.m_policyTreePath = item.getPath() == null ? item.getIdOrName() : item.getPath();
                this.m_type = item.getObjectType().name();
                this.m_orig = item;
            }
        }
        catch (Throwable throwable) {}
        this.m_guiElements = new GUIDisplayElements();
    }

    protected Control createDialogArea(Composite parent) {
        this.m_guiElements.centerShell(parent.getShell(), Display.getCurrent());
        this.m_dialogArea = new Composite(parent, 0);
        GridLayout gl = new GridLayout(7, false);
        gl.marginHeight = 0;
        gl.marginTop = 5;
        gl.marginBottom = 10;
        gl.verticalSpacing = 5;
        gl.marginRight = 5;
        gl.marginLeft = 5;
        this.m_dialogArea.setLayout((Layout)gl);
        this.m_dialogArea.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        String[] chs = new String[]{PGEntityPermissionFlag.ENFORCE.getChar(), PGEntityPermissionFlag.RESTRICT.getChar(), PGEntityPermissionFlag.EXCLUSIVE.getChar()};
        this.m_guiElements.addDropDown(this.m_dialogArea, PRIVILEGEDFLAG, null, chs, this.m_permissionChar, "Permission flag", 1, 1, 1, 1, this);
        this.m_actionCombo = this.m_guiElements.addDropDown(this.m_dialogArea, ACTION, null, new String[]{PGEntityAction.MODIFY.name(), PGEntityAction.READ.name()}, this.m_action, "Action", 1, 1, 1, 1, this);
        Label l = new Label(this.m_dialogArea, 0);
        l.setText(":");
        this.m_guiElements.addDropDown(this.m_dialogArea, TYPE, null, new String[]{ObjectType.pol.name(), ObjectType.pga.name(), ObjectType.ngr.name()}, this.m_type, "Object type", 1, 1, 1, 1, this);
        l = new Label(this.m_dialogArea, 0);
        l.setText(":/");
        final Text path = this.m_guiElements.addInputFieldSingle(this.m_dialogArea, PATH, null, this.m_policyTreePath, 1, 1, 1, 1, 300, this);
        this.m_guiElements.addButton(this.m_dialogArea, "SELECTPOLICYPATH", "Select in tree", true, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ObjectType.pol.name().equals(PGItemDialog.this.m_type)) {
                    GroupTreeObject gto;
                    GroupTreeObject tree = PolicyManager.getInstance().getPolicyTree();
                    SelectInTreeDialog sit = new SelectInTreeDialog(PGItemDialog.this.getShell(), "Select path", tree, false);
                    sit.setBlockOnOpen(true);
                    int res = sit.open();
                    if (res == 0 && (gto = sit.getSelection()) != null) {
                        path.setText(gto.getPath());
                    }
                } else if (ObjectType.pga.name().equals(PGItemDialog.this.m_type)) {
                    GroupTreeObject gto;
                    GroupTreeObject tree = PolicyManager.getInstance().getAsnTree();
                    SelectInTreeDialog sit = new SelectInTreeDialog(PGItemDialog.this.getShell(), "Select path", tree, false);
                    sit.setBlockOnOpen(true);
                    int res = sit.open();
                    if (res == 0 && (gto = sit.getSelection()) != null) {
                        if (!"pga".equals(gto.getType())) {
                            gto = gto.findFirstParent("pga");
                        }
                        if (gto != null) {
                            path.setText(gto.getPath());
                        }
                    }
                } else if (ObjectType.ngr.name().equals(PGItemDialog.this.m_type)) {
                    GroupTreeObject gto;
                    GroupTreeObject root = new GroupTreeObject("root", "");
                    GroupTreeObject tree = Repository.getInstance().getNodeGroupTree();
                    try {
                        GroupTreeObject clone = tree.clone();
                        root.addElement(clone);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                    SelectInTreeDialog sit = new SelectInTreeDialog(PGItemDialog.this.getShell(), "Select path", root, true);
                    sit.setBlockOnOpen(true);
                    int res = sit.open();
                    if (res == 0 && (gto = sit.getSelection()) != null) {
                        path.setText(gto.getPath());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return this.m_dialogArea;
    }

    public PGItem getResultPGItem() throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.m_permissionChar).append(this.m_action).append(':').append(this.m_type).append(":/").append(this.m_policyTreePath);
        PGItem i = PGItem.parse(sb.toString());
        if (this.m_orig == null || !this.m_orig.equals(i) && this.m_pg.getItems(i.getObjectType(), i.getPermFlag()).containsKey(i)) {
            throw new Exception("Item already exists");
        }
        ObjectType type = ObjectType.valueOf(this.m_type);
        switch (type) {
            case pol: {
                GroupTreeObject policyTree = PolicyManager.getInstance().getPolicyTree();
                if (policyTree.searchPath(this.m_policyTreePath, "") != null || policyTree.searchPath(this.m_policyTreePath, "mon") != null || policyTree.searchPath(this.m_policyTreePath, "msg") != null) break;
                throw new Exception("Policy path not found: " + this.m_policyTreePath);
            }
            case pga: {
                GroupTreeObject asnTree = PolicyManager.getInstance().getAsnTree();
                if (asnTree.searchPath(this.m_policyTreePath, "pga") != null) break;
                throw new Exception("Assignment group not found: " + this.m_policyTreePath);
            }
            case ngr: {
                GroupTreeObject nodeGroupTree = Repository.getInstance().getAgentTree();
                if (nodeGroupTree.searchPath(this.m_policyTreePath, "") != null || nodeGroupTree.searchPath(this.m_policyTreePath, "agt") != null) break;
                throw new Exception("Node group not found: " + this.m_policyTreePath);
            }
        }
        return i;
    }

    public PowerGroup getPowerGroup() {
        return this.m_pg;
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        return c;
    }

    protected Control createButtonBar(Composite parent) {
        Control buttonBar = super.createButtonBar(parent);
        return buttonBar;
    }

    public void create() {
        super.create();
        this.validate();
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)obj;
            String fieldName = (String)field.getData();
            if (fieldName.equals(PATH)) {
                this.m_policyTreePath = ((Text)e.widget).getText();
            }
            this.validate();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void validate() {
        block6: {
            try {
                this.getResultPGItem();
                this.getButton(0).setEnabled(true);
                this.m_dialogArea.setBackground(null);
                var4_1 = this.m_dialogArea.getChildren();
                var3_3 = var4_1.length;
                var2_5 = 0;
                while (var2_5 < var3_3) {
                    ct = var4_1[var2_5];
                    try {
                        ct.setBackground(null);
                    }
                    catch (Throwable v0) {}
                    ++var2_5;
                }
                this.updateStatus((IStatus)new Status(0, "id", null));
                break block6;
            }
            catch (Throwable e2) {
                this.updateStatus((IStatus)new Status(2, "id", e2.getMessage()));
                this.getButton(0).setEnabled(false);
                this.m_dialogArea.setBackground(BMUI.color_light_yellow);
                var5_9 = this.m_dialogArea.getChildren();
                var4_2 = var5_9.length;
                var3_4 = 0;
                ** while (var3_4 < var4_2)
            }
lbl-1000:
            // 1 sources

            {
                ct = var5_9[var3_4];
                ct.setBackground(BMUI.color_light_yellow);
                ++var3_4;
                continue;
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof CCombo) {
            CCombo combo = (CCombo)obj;
            String name = (String)combo.getData();
            if (name.equals(PRIVILEGEDFLAG)) {
                CCombo cCombo = (CCombo)e.widget;
                this.m_permissionChar = cCombo.getText();
            } else if (name.equals(ACTION)) {
                CCombo cCombo = (CCombo)e.widget;
                this.m_action = cCombo.getText();
            } else if (name.equals(TYPE)) {
                CCombo cCombo = (CCombo)e.widget;
                this.m_type = cCombo.getText();
                if (ObjectType.pol.name().equals(this.m_type)) {
                    this.m_actionCombo.setItems(new String[]{PGEntityAction.MODIFY.name(), PGEntityAction.READ.name()});
                    if (PGEntityAction.READ.name().equals(this.m_action)) {
                        this.m_actionCombo.select(1);
                    } else {
                        this.m_actionCombo.select(0);
                    }
                } else if (ObjectType.pga.name().equals(this.m_type)) {
                    this.m_actionCombo.setItems(new String[]{PGEntityAction.MODIFY.name()});
                    this.m_actionCombo.select(0);
                } else if (ObjectType.ngr.name().equals(this.m_type)) {
                    this.m_actionCombo.setItems(new String[]{PGEntityAction.MODIFY.name(), PGEntityAction.READ.name()});
                    this.m_actionCombo.select(0);
                }
            }
            this.validate();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

