/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.authentication.TableItemObject;
import com.blixx.boom.authentication.UserRoleTab;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.shared.UItem;
import com.blixx.shared.UserRight;
import com.blixx.shared.UserRole;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class TableContentProvider
implements IStructuredContentProvider,
ITableLabelProvider {
    private String m_type = null;
    public UserRole m_role = null;
    private UserRoleTab m_tab = null;
    public List<UserRight> m_rights = null;
    private Map<String, TableItemObject> m_elements_actual = new TreeMap<String, TableItemObject>();
    private Map<String, TableItemObject> m_elements_orig = new TreeMap<String, TableItemObject>();
    public static final String COL_NAME = "Name";
    public static final String COL_DISABLED = "Disabled";
    public static final String COL_GUEST = "Guest";
    public static final String COL_OWNER = "Owner";
    public static final String COL_DESCRIPTION = "Description";
    public static HashMap<String, Integer> m_columnMap = new HashMap(20, 0.9f);

    static {
        m_columnMap.put(COL_NAME, 0);
        m_columnMap.put(COL_DISABLED, 1);
        m_columnMap.put(COL_GUEST, 2);
        m_columnMap.put(COL_OWNER, 3);
        m_columnMap.put(COL_DESCRIPTION, 4);
    }

    public TableContentProvider(UserRoleTab tab, UserRole role, String type) {
        this.m_tab = tab;
        this.m_type = type;
        this.m_role = role;
        this.m_rights = role.getRights();
        this.createTableObjects();
    }

    public void createTableObjects() {
        TableItemObject item = new TableItemObject();
        UserRight m2 = null;
        if (this.m_rights == null || this.m_rights.size() == 0) {
            return;
        }
        for (UserRight m2 : this.m_rights) {
            TableItemObject itemOrig;
            TableItemObject newItem;
            int itemID = m2.getItemID();
            if (this.m_type.equals(UserRoleTab.GENERAL_TABLE)) {
                if (itemID >= 8000 || (newItem = TableItemObject.createTableItem(m2)) == null) continue;
                this.m_elements_actual.put(newItem.getName(), newItem);
                itemOrig = TableItemObject.createTableItem(m2);
                this.m_elements_orig.put(newItem.getName(), itemOrig);
                if (itemID != 1007) continue;
                this.m_tab.setGlobalActionRights(m2.getLevel());
                continue;
            }
            if (!this.m_type.equals(UserRoleTab.ACTION_TABLE) || itemID <= 7999 || itemID >= 9999 || (newItem = TableItemObject.createTableItem(m2)) == null) continue;
            this.m_elements_actual.put(newItem.getName(), newItem);
            itemOrig = TableItemObject.createTableItem(m2);
            this.m_elements_orig.put(newItem.getName(), itemOrig);
        }
        for (UItem uitem : Repository.getInstance().getUserManager().getUItems()) {
            int itemID = uitem.m_ID;
            boolean isInRange = false;
            if (this.m_type.equals(UserRoleTab.GENERAL_TABLE)) {
                if (itemID < 8000) {
                    isInRange = true;
                }
            } else if (this.m_type.equals(UserRoleTab.ACTION_TABLE) && itemID > 7999 && itemID < 9999) {
                isInRange = true;
            }
            if (!isInRange || this.m_elements_actual.containsKey(uitem.m_name)) continue;
            TableItemObject newItem = item.createNewTableItem(this.m_role.getID(), "" + uitem.m_ID, uitem.m_name, uitem.m_description);
            this.m_elements_actual.put(newItem.getName(), newItem);
            TableItemObject itemOrig = TableItemObject.createTableItem(m2);
            this.m_elements_orig.put(newItem.getName(), itemOrig);
        }
    }

    public void undo(TableViewer viewer) {
        this.m_elements_actual.clear();
        for (TableItemObject ti_orig : this.m_elements_orig.values()) {
            TableItemObject ti_new = ti_orig.createNewTableItem(ti_orig.getRoleID(), ti_orig.getItemID(), ti_orig.getName(), ti_orig.getDescription());
            ti_new.setDisabled(ti_orig.isDisabled());
            ti_new.setGuestRights(ti_orig.isGuest());
            ti_new.setOwnerRights(ti_orig.isOwner());
            this.m_elements_actual.put(ti_new.getName(), ti_new);
        }
    }

    public void update(TableItemObject item, int columnIndex, TableViewer viewer) {
        if (columnIndex > 0 && columnIndex < 4) {
            this.m_elements_actual.remove(item.getName());
            switch (columnIndex) {
                case 1: {
                    item.setDisabled(!item.isDisabled());
                    break;
                }
                case 2: {
                    item.setGuestRights(!item.isGuest());
                    break;
                }
                case 3: {
                    item.setOwnerRights(!item.isOwner());
                }
            }
            this.m_elements_actual.put(item.getName(), item);
            viewer.refresh(true, false);
        }
    }

    public List<UserRight> getRights() {
        ArrayList<UserRight> list = new ArrayList<UserRight>();
        String key2 = null;
        TableItemObject obj = null;
        for (String key2 : this.m_elements_actual.keySet()) {
            obj = this.m_elements_actual.get(key2);
            try {
                int level = 1;
                if (obj.isGuest()) {
                    level = 2;
                } else if (obj.isOwner()) {
                    level = 3;
                }
                int itemID = Integer.parseInt(obj.getItemID());
                UserRight ur = new UserRight(obj.getRoleID(), itemID, level);
                list.add(ur);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return list;
    }

    public Object[] getElements(Object inputElement) {
        return this.m_elements_actual.values().toArray();
    }

    public static int getColumnPosition(String columnName) {
        Integer i = m_columnMap.get(columnName);
        if (i != null) {
            return i;
        }
        return -1;
    }

    public static String getText(TableItemObject obj, String columnName) {
        String res = "";
        Integer intObj = m_columnMap.get(columnName);
        if (intObj == null) {
            throw new RuntimeException("Column " + columnName + " unsupported");
        }
        int columnNumber = intObj;
        res = TableContentProvider.getLabel(obj, columnNumber);
        return res;
    }

    public static String getLabel(TableItemObject obj, int columnNumber) {
        String res = "";
        switch (columnNumber) {
            case 0: {
                res = obj.getName();
                break;
            }
            case 4: {
                res = obj.getDescription();
                break;
            }
        }
        return res;
    }

    public String getMultilineText(String text, int width) {
        StringBuffer multiLineText = new StringBuffer();
        if (width == -1 || text.length() < width) {
            return text;
        }
        text = text.replace("\n", " ");
        while (text.length() >= width) {
            String sub1 = text.substring(0, width - 1);
            String sub2 = text.substring(width - 1, text.length());
            if (sub1.endsWith(" ") || sub2.startsWith(" ")) {
                multiLineText.append("\n").append(sub1.trim());
                if (sub2.trim().length() < width) {
                    multiLineText.append("\n").append(sub2.trim());
                    break;
                }
                text = sub2;
                continue;
            }
            int li = sub1.lastIndexOf(" ");
            sub1 = text.substring(0, li);
            sub2 = text.substring(li, text.length());
            multiLineText.append("\n").append(sub1.trim());
            if (sub2.trim().length() < width) {
                multiLineText.append("\n").append(sub2.trim());
                break;
            }
            text = sub2;
        }
        if (multiLineText.charAt(0) == '\n') {
            multiLineText.delete(0, 1);
        }
        return multiLineText.toString();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Image getColumnImage(Object element, int columnIndex) {
        TableItemObject item = (TableItemObject)element;
        Image image = BMUI.IMAGE_COMBO_UNCHECKED;
        switch (columnIndex) {
            case 0: {
                image = null;
                break;
            }
            case 1: {
                if (!item.isDisabled()) break;
                image = BMUI.IMAGE_COMBO_CHECKED;
                break;
            }
            case 2: {
                if (!item.isGuest()) break;
                image = BMUI.IMAGE_COMBO_CHECKED;
                break;
            }
            case 3: {
                if (!item.isOwner()) break;
                image = BMUI.IMAGE_COMBO_CHECKED;
                break;
            }
            default: {
                image = null;
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        TableItemObject obj = (TableItemObject)element;
        String label = TableContentProvider.getLabel(obj, columnIndex);
        return label;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

