/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.engine.Repository;
import com.blixx.log.RTLogger;
import com.blixx.shared.UItem;
import com.blixx.shared.UserRight;

public class TableItemObject {
    private String m_roleID = "-1";
    private String m_itemID = "-1";
    private String m_itemName = null;
    private String m_description = null;
    private int m_disabled = 0;
    private int m_guest = 0;
    private int m_owner = 0;
    public static final String ROLE_ID = "ROLE_ID";
    public static final String ITEM_ID = "ITEM_ID";
    public static final String ITEM_NAME = "NAME";
    public static final String DISABLED = "DISABLED";
    public static final String GUEST = "GUEST";
    public static final String OWNER = "OWNER";
    public static final String DESCRIPTION = "DESCRIPTION";

    public static TableItemObject createTableItem(UserRight m) {
        TableItemObject item = new TableItemObject();
        item.m_roleID = m.getRoleID();
        item.m_itemID = "" + m.getItemID();
        UItem itemObj = Repository.getInstance().getUserManager().getUItem(m.getItemID());
        if (itemObj == null) {
            return null;
        }
        item.m_itemName = itemObj.m_name;
        item.m_description = itemObj.m_description;
        switch (m.getLevel()) {
            case 1: {
                item.m_disabled = 1;
                break;
            }
            case 2: {
                item.m_guest = 1;
                break;
            }
            case 3: {
                item.m_owner = 1;
                break;
            }
            default: {
                item.m_disabled = 1;
                RTLogger.print(4, "No rights are assigned to item " + item.m_itemName);
            }
        }
        return item;
    }

    public TableItemObject createNewTableItem(String roleID, String itemID, String name, String description) {
        TableItemObject item = new TableItemObject();
        item.m_roleID = roleID;
        item.m_itemID = itemID;
        item.m_itemName = name;
        item.m_disabled = 0;
        item.m_guest = 0;
        item.m_owner = 0;
        item.m_description = description;
        return item;
    }

    public String getName() {
        return this.m_itemName;
    }

    public void setDisabled(boolean b) {
        if (b) {
            this.m_disabled = 1;
            this.m_guest = 0;
            this.m_owner = 0;
        }
    }

    public void setGuestRights(boolean b) {
        if (b) {
            this.m_guest = 1;
            this.m_owner = 0;
            this.m_disabled = 0;
        }
    }

    public void setOwnerRights(boolean b) {
        if (b) {
            this.m_owner = 1;
            this.m_guest = 0;
            this.m_disabled = 0;
        }
    }

    public boolean isGuest() {
        boolean b = false;
        if (this.m_guest == 1) {
            b = true;
        }
        return b;
    }

    public boolean isOwner() {
        boolean b = false;
        if (this.m_owner == 1) {
            b = true;
        }
        return b;
    }

    public boolean isDisabled() {
        boolean b = false;
        if (this.m_disabled == 1) {
            b = true;
        }
        return b;
    }

    public String getItemID() {
        return this.m_itemID;
    }

    public String getRoleID() {
        return this.m_roleID;
    }

    public String getDescription() {
        return this.m_description;
    }
}

