/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.shared.Cryptor;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserDetailsDialog
extends StatusDialog
implements ModifyListener,
SelectionListener {
    public User m_user = null;
    public List<UserRole> m_userRoleList = null;
    private GUIDisplayElements m_guiElements = null;
    private boolean m_isDirty = false;
    private boolean m_isNew = false;
    public TreeViewer m_treeViewer = null;
    public String m_type = null;
    public String m_currentRole = null;
    public Composite m_dialogArea = null;
    public Text m_login_name = null;
    public Text m_pwd_field = null;
    public Text m_pwd_confirm_field = null;
    public Text m_lastName_field = null;
    public CCombo m_active_combo = null;
    public CCombo m_Role_combo = null;
    public String[] m_userCopy = null;
    private Group m_group1;
    private Group m_group2;
    private Text m_fname;
    private Text m_email;
    private Text m_phone;
    private Text m_pager;
    public static String LOGIN = "LOGIN";
    public static String PASSWPORD = "PASSWORD";
    public static String ROLE = "ROLE";
    public static String LASTNAME = "LASTNAME";
    public static String FIRSTNAME = "FIRSTNAME";
    public static String EMAIL = "EMAIL";
    public static String PHONE = "PHONE";
    public static String PAGER = "PAGER";
    public static String ACTIVE = "ACTIVE";
    public static String BUTTON_RESET = "BUTTON_RESET";

    public UserDetailsDialog(Shell parentShell, User user, TreeViewer treeViewer, String role, List<UserRole> list, boolean isNew) {
        super(new Shell(parentShell, 1265));
        this.setTitle("  User Details");
        this.m_user = user;
        this.m_treeViewer = treeViewer;
        this.m_currentRole = role;
        this.m_userRoleList = list;
        this.m_isNew = isNew;
        if (!this.m_isNew) {
            this.keepUserInfo();
        }
        this.m_type = this.m_user != null && "LDAP".equals(this.m_user.m_pwd) ? "LDAP" : "DEFAULT";
    }

    protected Control createDialogArea(Composite parent) {
        this.setImage(Repository.getInstance().getUserManager().getUserImage(this.m_user));
        this.m_guiElements = new GUIDisplayElements();
        this.m_guiElements.centerShell(parent.getShell(), Display.getCurrent());
        this.m_dialogArea = new Composite(parent, 0);
        GridLayout gdLayout = new GridLayout(1, false);
        gdLayout.marginTop = 5;
        gdLayout.marginLeft = 10;
        gdLayout.marginRight = 10;
        this.m_dialogArea.setLayout((Layout)gdLayout);
        this.m_dialogArea.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.m_group1 = new Group(this.m_dialogArea, 32);
        this.m_group1.setText("Login Information");
        this.m_group1.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        this.m_group1.setLayoutData((Object)gd);
        if (this.m_isNew) {
            this.m_login_name = this.m_guiElements.addInputFieldSingle((Composite)this.m_group1, LOGIN, "Login Name: ", this.m_user.m_loginName, 1, 1, 0, 0, 60, this);
            this.m_login_name.setTextLimit(255);
            this.m_pwd_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_group1, PASSWPORD, "Password: ", this.m_user.m_pwd, 1, 1, 0, 3, 60, this);
            this.m_pwd_field.setTextLimit(255);
            this.m_pwd_field.setEchoChar('*');
            this.m_pwd_confirm_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_group1, PASSWPORD, "Confirm Password: ", "", 1, 1, 0, 5, 60, this);
            this.m_pwd_confirm_field.setEchoChar('*');
        } else {
            this.m_login_name = this.m_guiElements.addInputFieldSingle((Composite)this.m_group1, LOGIN, "Login Name: ", this.m_user.m_loginName, 2, 1, 0, 0, 60, this);
            this.m_login_name.setTextLimit(255);
            this.m_pwd_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_group1, PASSWPORD, "Password: ", this.m_user.m_pwd, 1, 1, 0, 3, 60, this);
            this.m_pwd_field.setTextLimit(255);
            this.m_pwd_field.setEchoChar('*');
            Button changePwd = this.createButton((Composite)this.m_group1, 11, "Reset Password", false);
            if ("LDAP".equals(this.m_user.m_pwd)) {
                changePwd.setEnabled(false);
            }
            this.m_login_name.setEnabled(false);
            this.m_pwd_field.setEnabled(false);
        }
        String[] roleList = this.getStringList(this.m_userRoleList);
        if (this.m_isNew) {
            if (this.m_currentRole == null) {
                this.m_currentRole = roleList[0].toString();
            }
            this.m_Role_combo = this.m_guiElements.addDropDown((Composite)this.m_group1, ROLE, "Role: ", roleList, this.m_currentRole, null, 1, 1, 0, 3, this);
            this.m_user.m_roleName = this.m_currentRole;
        } else {
            this.m_Role_combo = this.m_guiElements.addDropDown((Composite)this.m_group1, ROLE, "Role: ", roleList, this.m_user.m_roleName, null, 2, 1, 0, 3, this);
        }
        ((GridData)this.m_Role_combo.getLayoutData()).horizontalAlignment = 1;
        if (this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMIN) || this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMINISTRATOR)) {
            this.m_guiElements.enableField(this.m_Role_combo, false);
        }
        String selection = "NO";
        if (this.m_user.m_active == 1) {
            selection = "YES";
        }
        if (this.m_isNew) {
            this.m_active_combo = this.m_guiElements.addDropDown((Composite)this.m_group1, ACTIVE, "Active: ", new String[]{"YES", "NO"}, selection, "", 1, 1, 0, 3, this);
            ((GridData)this.m_active_combo.getLayoutData()).horizontalAlignment = 1;
            this.m_guiElements.addTextReadOnlyNoBorder((Composite)this.m_group1, "Type: ", this.m_type, 1, 1, 0, 3, null);
        } else {
            this.m_active_combo = this.m_guiElements.addDropDown((Composite)this.m_group1, ACTIVE, "Active: ", new String[]{"YES", "NO"}, selection, "", 2, 1, 0, 3, this);
            ((GridData)this.m_active_combo.getLayoutData()).horizontalAlignment = 1;
            this.m_guiElements.addTextReadOnlyNoBorder((Composite)this.m_group1, "Type: ", this.m_type, 2, 1, 0, 3, null);
        }
        if (this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMIN) || this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMINISTRATOR)) {
            this.m_guiElements.enableField(this.m_active_combo, false);
        }
        this.m_group2 = new Group(this.m_dialogArea, 32);
        this.m_group2.setText("User Information");
        this.m_group2.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(4, 128, true, false, 1, 1);
        gd.widthHint = 504;
        this.m_group2.setLayoutData((Object)gd);
        this.m_lastName_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_group2, LASTNAME, "Last Name: ", this.m_user.m_lastName, 2, 1, 0, 3, 60, this);
        this.m_lastName_field.setTextLimit(255);
        if (this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMIN) || this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMINISTRATOR)) {
            this.m_lastName_field.setEnabled(false);
        }
        this.m_fname = this.m_guiElements.addInputFieldSingle((Composite)this.m_group2, FIRSTNAME, "First Name: ", this.m_user.m_firstName, 2, 1, 0, 3, 60, this);
        this.m_fname.setTextLimit(255);
        if (this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMIN) || this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMINISTRATOR)) {
            this.m_fname.setEnabled(false);
        }
        this.m_email = this.m_guiElements.addInputFieldSingle((Composite)this.m_group2, EMAIL, "eMail: ", this.m_user.m_email, 2, 1, 0, 3, 60, this);
        this.m_email.setTextLimit(255);
        this.m_phone = this.m_guiElements.addInputFieldSingle((Composite)this.m_group2, PHONE, "Phone Number: ", this.m_user.m_phone, 2, 1, 0, 3, 60, this);
        this.m_phone.setTextLimit(255);
        this.m_pager = this.m_guiElements.addInputFieldSingle((Composite)this.m_group2, PAGER, "Pager: ", this.m_user.m_pager, 2, 1, 0, 3, 60, this);
        this.m_pager.setTextLimit(255);
        return this.m_dialogArea;
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setDirty(boolean b) {
        this.m_isDirty = b;
        this.getButton(0).setEnabled(b);
    }

    public void setNew(boolean b) {
        this.m_isNew = b;
    }

    public String[] getStringList(List<UserRole> aList) {
        UserRole role = null;
        String[] list = new String[aList.size()];
        Iterator<UserRole> it = aList.iterator();
        int index = 0;
        while (it.hasNext()) {
            role = it.next();
            list[index] = role.getName();
            ++index;
        }
        return list;
    }

    public void modifyText(ModifyEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Text) {
            Text field = (Text)obj;
            String fieldName = (String)field.getData();
            String value = field.getText();
            if (fieldName.equals(LOGIN)) {
                this.m_user.m_loginName = value.trim();
            } else if (fieldName.equals(PASSWPORD)) {
                this.m_user.m_pwd = Cryptor.encrypt2(value.trim());
            } else if (fieldName.equals(LASTNAME)) {
                this.m_user.m_lastName = value.trim();
            } else if (fieldName.equals(FIRSTNAME)) {
                this.m_user.m_firstName = value.trim();
            } else if (fieldName.equals(EMAIL)) {
                this.m_user.m_email = value.trim();
            } else if (fieldName.equals(PHONE)) {
                this.m_user.m_phone = value.trim();
            } else if (fieldName.equals(PAGER)) {
                this.m_user.m_pager = value.trim();
            }
        }
        this.getButton(0).setEnabled(true);
    }

    public void save() {
        boolean doSave = true;
        if (this.validateInput()) {
            if (this.m_isNew) {
                if (Repository.getInstance().getUserManager().userExist(this.m_user.m_loginName)) {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Save New User", (String)("Login name '" + this.m_user.m_loginName + "' does already exist!"));
                    this.m_login_name.setText("");
                    this.m_pwd_field.setText("");
                    this.m_pwd_confirm_field.setText("");
                    doSave = false;
                } else if (!this.m_pwd_field.getText().equals(this.m_pwd_confirm_field.getText())) {
                    MessageDialog.openError((Shell)this.m_treeViewer.getControl().getShell(), (String)"Save New User", (String)"Passwords do not match!");
                    this.m_pwd_field.setText("");
                    this.m_pwd_confirm_field.setText("");
                    doSave = false;
                }
            }
            if (doSave && Repository.getInstance().getUserManager().saveUserSync(this.m_user)) {
                this.setDirty(false);
                super.close();
                Repository.getInstance().getUserManager().refresh();
                if (!this.m_isNew && Repository.m_user.equals(this.m_user.m_loginName)) {
                    Repository.m_pass = this.m_user.m_pwd;
                }
            }
        }
    }

    public boolean validateInput() {
        boolean isOkay = false;
        if (this.m_user.m_loginName.trim().length() == 0 || this.m_user.m_lastName.trim().length() == 0) {
            MessageDialog.openInformation((Shell)this.m_treeViewer.getControl().getShell(), (String)"Save User", (String)"Please fill in Loginname and Last Name!");
        } else {
            isOkay = true;
        }
        return isOkay;
    }

    public void resetPassword() {
        ResetPwdDialog pwdResetDialog = new ResetPwdDialog(Display.getCurrent().getActiveShell());
        pwdResetDialog.setBlockOnOpen(true);
        pwdResetDialog.open();
    }

    public void keepUserInfo() {
        if (this.m_user != null) {
            this.m_userCopy = new String[]{this.m_user.m_loginName, this.m_user.m_pwd, this.m_user.m_roleID, this.m_user.m_roleName, Integer.toString(this.m_user.m_active), this.m_user.m_lastName, this.m_user.m_firstName, this.m_user.m_email, this.m_user.m_phone, this.m_user.m_pager};
        }
    }

    public void resetUser() {
        this.m_user.m_pwd = this.m_userCopy[1];
        this.m_user.m_roleID = this.m_userCopy[2];
        this.m_user.m_roleName = this.m_userCopy[3];
        this.m_user.m_active = Integer.valueOf(this.m_userCopy[4]);
        this.m_user.m_lastName = this.m_userCopy[5];
        this.m_user.m_firstName = this.m_userCopy[6];
        this.m_user.m_email = this.m_userCopy[7];
        this.m_user.m_phone = this.m_userCopy[8];
        this.m_user.m_pager = this.m_userCopy[9];
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button b = this.createButton(parent, 0, "Save User", false);
        b.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            if (!this.m_isNew) {
                this.resetUser();
            }
            super.close();
        } else if (buttonId == 0) {
            this.save();
        } else if (buttonId == 11) {
            this.resetPassword();
        }
    }

    public boolean close() {
        try {
            if (!this.m_isNew) {
                this.resetUser();
            }
            this.m_active_combo.dispose();
            this.m_lastName_field.dispose();
            this.m_login_name.dispose();
            this.m_pwd_field.dispose();
            try {
                this.m_pwd_confirm_field.dispose();
            }
            catch (Throwable throwable) {}
            this.m_fname.dispose();
            this.m_email.dispose();
            this.m_phone.dispose();
            this.m_pager.dispose();
            this.m_Role_combo.dispose();
            this.m_group1.dispose();
            this.m_group2.dispose();
            this.m_dialogArea.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof CCombo) {
            CCombo combo = (CCombo)obj;
            String name = (String)combo.getData();
            if (name.equals(ACTIVE)) {
                this.m_user.m_active = combo.getText().toUpperCase().equalsIgnoreCase("YES") ? 1 : 0;
            } else if (name.equals(ROLE)) {
                String roleName = combo.getText().toString();
                UserRole role = Repository.getInstance().getUserManager().getRoleByName(roleName);
                if (role != null) {
                    this.m_user.m_roleName = role.getName();
                    this.m_user.m_roleID = role.getID();
                }
            }
        }
        this.getButton(0).setEnabled(true);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public class ResetPwdDialog
    extends StatusDialog
    implements ModifyListener {
        private Composite m_comp;
        private Text m_newPwd;
        private Text m_confirmPwd;

        public ResetPwdDialog(Shell parentShell) {
            super(parentShell);
            this.m_comp = null;
            this.m_newPwd = null;
            this.m_confirmPwd = null;
            this.setTitle("  Reset Password");
            this.setImage(Repository.getInstance().getUserManager().getUserImage(UserDetailsDialog.this.m_user));
        }

        protected Control createDialogArea(Composite parent) {
            UserDetailsDialog.this.m_guiElements = new GUIDisplayElements();
            this.m_comp = new Composite(parent, 0);
            GridLayout gdLayout = new GridLayout(2, false);
            gdLayout.marginTop = 10;
            gdLayout.marginRight = 10;
            gdLayout.marginLeft = 10;
            this.m_comp.setLayout((Layout)gdLayout);
            this.m_comp.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
            UserDetailsDialog.this.m_guiElements.addTextField(this.m_comp, null, "User: ", 1, 1, 1, 1, null);
            UserDetailsDialog.this.m_guiElements.addTextField(this.m_comp, null, String.valueOf(UserDetailsDialog.this.m_user.m_firstName) + " " + UserDetailsDialog.this.m_user.m_lastName, 1, 1, 1, 1, BMUI.font_arial8_bold);
            this.m_newPwd = UserDetailsDialog.this.m_guiElements.addInputFieldSingle(this.m_comp, "PWD", "New Password: ", null, 1, 1, 0, 3, 150, this);
            this.m_newPwd.setEchoChar('*');
            this.m_confirmPwd = UserDetailsDialog.this.m_guiElements.addInputFieldSingle(this.m_comp, "PWD_CONFIRM", "Confirm Password: ", null, 1, 1, 0, 3, 150, this);
            this.m_confirmPwd.setEchoChar('*');
            return parent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Save", false);
            this.getButton(0).setEnabled(false);
            this.createButton(parent, 1, "Cancel", true);
            this.getButton(1).setFocus();
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 1) {
                super.close();
            } else if (buttonId == 0) {
                String newPwd = this.m_newPwd.getText();
                String confirmPwd = this.m_confirmPwd.getText();
                if (newPwd.trim().length() > 0 && confirmPwd.trim().length() > 0 && newPwd.equals(confirmPwd)) {
                    UserDetailsDialog.this.m_pwd_field.setText(Cryptor.encrypt2(newPwd));
                    UserDetailsDialog.this.m_user.m_pwd = Cryptor.encrypt2(newPwd);
                    UserDetailsDialog.this.setDirty(true);
                    super.close();
                } else {
                    MessageDialog.openInformation((Shell)UserDetailsDialog.this.m_treeViewer.getControl().getShell(), (String)"Reset Password", (String)"Passwords do not match!");
                    this.m_newPwd.setText("");
                    this.m_confirmPwd.setText("");
                }
            }
        }

        public boolean close() {
            try {
                this.m_comp.dispose();
                this.m_newPwd.dispose();
                this.m_confirmPwd.dispose();
            }
            catch (Exception exception) {}
            return super.close();
        }

        public void modifyText(ModifyEvent e) {
            this.getButton(0).setEnabled(true);
        }
    }
}

