/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.authentication.DNDSourceTreeProcessor;
import com.blixx.boom.authentication.DNDTargetTreeProcessor;
import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.authentication.UserRoleTab;
import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.utils.FilterComposite_UserManagement;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.views.StyledTreeLabelProvider;
import com.blixx.boom.gui.views.actions.AddRoleAction;
import com.blixx.boom.gui.views.actions.AddUserAction;
import com.blixx.boom.gui.views.actions.ChangeUserStatus;
import com.blixx.boom.gui.views.actions.DeleteRoleAction;
import com.blixx.boom.gui.views.actions.DeleteUserAction;
import com.blixx.boom.gui.views.actions.EditUserAction;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.RefreshUserRoleTabAction;
import com.blixx.boom.gui.views.actions.RenameRoleAction;
import com.blixx.boom.gui.views.actions.SendForceExitAction;
import com.blixx.boom.gui.views.actions.SendMessageAction;
import com.blixx.log.RTLogger;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.ViewPart;

public class UserManagementView
extends ViewPart
implements IDoubleClickListener,
ISelectionChangedListener,
IRefreshable {
    public static final int VIEW_ID = 1004;
    public static final String ID = "com.blixx.boom.authentication.usermanagementview";
    private static UserManagementView m_instance = null;
    public List<UserRole> m_roleList = null;
    private UserRole m_selectedRole = null;
    public Composite m_parent = null;
    public TreeViewer m_treeViewer;
    private Composite m_rightFrame = null;
    private Composite m_leftFrame = null;
    public CTabFolder m_folder = null;
    public UserRoleTab m_userRoleTab = null;
    public GroupTreeObject m_currTreeSel = null;
    public boolean m_readOnly = true;

    public UserManagementView() {
        m_instance = this;
    }

    public static UserManagementView getInstance() {
        return m_instance;
    }

    public void createPartControl(Composite parent) {
        this.setTitleImage(BMUI.IMAGE_USERS);
        if (Repository.getInstance().getRights(1004) == 3) {
            this.m_readOnly = false;
        } else if (Repository.getInstance().getRights(1004) < 2) {
            parent.setLayout((Layout)new GridLayout(2, false));
            Label l = new Label(parent, 0);
            l.setText(" Insufficient rights.");
            l.setForeground(BMUI.color_critical);
            Button close = new Button(parent, 8);
            close.setText("Close");
            close.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    UserManagementView.this.getSite().getPage().hideView(UserManagementView.this.getSite().getPage().findView(UserManagementView.ID));
                }
            });
            UIJob uiJob = new UIJob("Close Viewcom.blixx.boom.authentication.usermanagementview"){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    UserManagementView.this.getSite().getPage().hideView(UserManagementView.this.getSite().getPage().findView(UserManagementView.ID));
                    return Status.OK_STATUS;
                }
            };
            Repository.getUIJobManager().schedule(uiJob);
            return;
        }
        this.m_parent = parent;
        SashForm compMain = new SashForm(this.m_parent, 256);
        compMain.setLayout((Layout)new FillLayout());
        this.m_leftFrame = new Composite((Composite)compMain, 128);
        this.m_leftFrame.setLayout((Layout)new FillLayout());
        this.m_leftFrame.setBackground(BMUI.color_grey);
        this.m_rightFrame = new Composite((Composite)compMain, 128);
        this.m_rightFrame.setLayout((Layout)new FillLayout());
        this.m_rightFrame.setBackground(BMUI.color_grey);
        this.m_roleList = Repository.getInstance().getUserManager().getRoleList();
        this.m_selectedRole = Repository.getInstance().getUserManager().getRoleByName(UserManager.ADMINISTRATOR);
        this.createUserTree();
        this.createRoleCTabItem();
        compMain.setWeights(new int[]{1, 3});
    }

    public void createUserTree() {
        Composite comp = new Composite(this.m_leftFrame, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        FilterComposite_UserManagement filterComp = new FilterComposite_UserManagement(comp);
        this.m_treeViewer = new STreeViewer(comp, 2818);
        this.m_treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_treeViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new StyledTreeLabelProvider());
        Repository.getInstance().getUserManager().addUserTreeListener(this);
        GroupTreeObject userTreeRoot = Repository.getInstance().getUserManager().getUserTree();
        this.m_treeViewer.setInput((Object)userTreeRoot);
        this.m_treeViewer.expandAll();
        this.m_treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Transfer[] types = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.m_treeViewer.addDragSupport(2, types, (DragSourceListener)new DNDSourceTreeProcessor(this.m_treeViewer));
        this.m_treeViewer.addDropSupport(2, types, (DropTargetListener)new DNDTargetTreeProcessor(this.m_treeViewer));
        IWorkbenchPartSite part = this.getSite();
        part.setSelectionProvider((ISelectionProvider)this.m_treeViewer);
        this.createContentMenu();
        filterComp.setTreeViewer(this.m_treeViewer);
        if (userTreeRoot != null && this.m_selectedRole != null) {
            this.m_currTreeSel = userTreeRoot.findFirstGroupByName(this.m_selectedRole.getName());
        }
        this.m_treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.setTreeSelection(this.m_currTreeSel);
        this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void createRoleCTabItem() {
        this.m_folder = new CTabFolder(this.m_rightFrame, 0);
        this.m_folder.setSimple(false);
        this.m_folder.setMinimizeVisible(false);
        this.m_folder.setMaximizeVisible(false);
        this.m_folder.setBorderVisible(true);
        this.m_folder.setBackground(BMUI.color_unknown);
        this.m_userRoleTab = new UserRoleTab(this.m_folder, this.m_selectedRole, 0, this.m_folder.getItemCount(), this.m_readOnly);
        this.m_folder.setSelection((CTabItem)this.m_userRoleTab);
    }

    public void createContentMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(false);
        Menu menu = menuMgr.createContextMenu(this.m_treeViewer.getControl());
        this.m_treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.m_treeViewer);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                try {
                    manager.add((IAction)new RefreshUserRoleTabAction());
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new AddRoleAction(UserManagementView.this.m_treeViewer));
                    StructuredSelection ssel = (StructuredSelection)UserManagementView.this.m_treeViewer.getSelection();
                    if (!ssel.isEmpty()) {
                        ArrayList<User> usersSelected = new ArrayList<User>();
                        ArrayList<String> roles = new ArrayList<String>();
                        for (GroupTreeObject gto : ssel) {
                            if (gto.getTreeObject() != null && gto.getTreeObject() instanceof UserTreeObject) {
                                UserTreeObject uto = (UserTreeObject)gto.getTreeObject();
                                if (uto.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMIN)) continue;
                                usersSelected.add(uto.m_user);
                                continue;
                            }
                            if (gto.getName().trim().equals(UserManager.ADMINISTRATOR)) continue;
                            roles.add(gto.getName());
                        }
                        Object o = ssel.getFirstElement();
                        UserManagementView.this.m_roleList = Repository.getInstance().getUserManager().getRoleList();
                        if (ssel.size() == 1) {
                            if (o instanceof GroupTreeObject && !(o instanceof GroupTreeObjectLast)) {
                                GroupTreeObject gto = (GroupTreeObject)o;
                                RenameRoleAction renameRoleAction = new RenameRoleAction(UserManagementView.this.m_treeViewer, UserManagementView.this.m_parent.getShell(), gto);
                                manager.add((IAction)renameRoleAction);
                                DeleteRoleAction deleteRoleAction = new DeleteRoleAction(UserManagementView.this.m_treeViewer, gto);
                                manager.add((IAction)deleteRoleAction);
                                if (gto.getName().trim().equals(UserManager.ADMINISTRATOR)) {
                                    renameRoleAction.setEnabled(false);
                                    deleteRoleAction.setEnabled(false);
                                }
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new AddUserAction(UserManagementView.this.m_treeViewer, UserManagementView.this.m_parent.getShell(), gto, UserManagementView.this.m_roleList));
                            } else if (o instanceof GroupTreeObjectLast) {
                                GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)o;
                                String login = null;
                                User user = null;
                                if (gtoLast.getTreeObject() instanceof UserTreeObject) {
                                    UserTreeObject uto = (UserTreeObject)gtoLast.getTreeObject();
                                    user = uto.m_user;
                                    login = user.m_loginName;
                                }
                                if (login == null) {
                                    return;
                                }
                                manager.add((IContributionItem)new Separator());
                                manager.add((IAction)new AddUserAction(UserManagementView.this.m_treeViewer, UserManagementView.this.m_parent.getShell(), gtoLast.getParent(), UserManagementView.this.m_roleList));
                                manager.add((IAction)new EditUserAction(UserManagementView.this.m_treeViewer, UserManagementView.this.m_parent.getShell(), gtoLast, UserManagementView.this.m_roleList));
                                ChangeUserStatus changeUserStatus = new ChangeUserStatus(UserManagementView.this.m_treeViewer, gtoLast);
                                manager.add((IAction)changeUserStatus);
                                if (login.equalsIgnoreCase(UserManager.ADMIN)) {
                                    changeUserStatus.setEnabled(false);
                                }
                                DeleteUserAction deleteUserAction = new DeleteUserAction(UserManagementView.this.m_treeViewer, usersSelected);
                                manager.add((IAction)deleteUserAction);
                                if (login.equalsIgnoreCase(UserManager.ADMIN)) {
                                    deleteUserAction.setEnabled(false);
                                }
                                if (user != null && user.isActive()) {
                                    manager.add((IContributionItem)new Separator());
                                    SendMessageAction sma = new SendMessageAction(login);
                                    manager.add((IAction)sma);
                                    SendForceExitAction sfe = new SendForceExitAction(login);
                                    manager.add((IAction)sfe);
                                }
                            }
                        } else if (usersSelected.size() > 0) {
                            manager.add((IContributionItem)new Separator());
                            ChangeUserStatus changeUserStatus1 = new ChangeUserStatus(UserManagementView.this.m_treeViewer, usersSelected, 1);
                            manager.add((IAction)changeUserStatus1);
                            ChangeUserStatus changeUserStatus2 = new ChangeUserStatus(UserManagementView.this.m_treeViewer, usersSelected, 0);
                            manager.add((IAction)changeUserStatus2);
                            DeleteUserAction deleteUserAction = new DeleteUserAction(UserManagementView.this.m_treeViewer, usersSelected);
                            manager.add((IAction)deleteUserAction);
                            StringBuffer sb = new StringBuffer();
                            for (User us : usersSelected) {
                                if (!us.isActive()) continue;
                                sb.append(us.m_loginName);
                                sb.append(',');
                            }
                            if (sb.length() > 0) {
                                SendMessageAction sma = new SendMessageAction(sb.subSequence(0, sb.length() - 1).toString());
                                manager.add((IAction)sma);
                                SendForceExitAction sfe = new SendForceExitAction(sb.subSequence(0, sb.length() - 1).toString());
                                manager.add((IAction)sfe);
                            }
                        }
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new ExpandCollapseAction(UserManagementView.this.m_treeViewer, "ExpandAll"));
                    manager.add((IAction)new ExpandCollapseAction(UserManagementView.this.m_treeViewer, "CollapseAll"));
                }
                catch (RuntimeException e) {
                    RTLogger.print(5, "Error creating context menu" + e);
                }
            }
        });
    }

    public UserRole getSelectedRole() {
        return Repository.getInstance().getUserManager().getRoleByName(this.m_selectedRole.getName());
    }

    public void closeTab(String name) {
        CTabItem[] list = this.m_folder.getItems();
        int index = 0;
        while (index < list.length) {
            CTabItem cTab = list[index];
            if (name.equalsIgnoreCase(cTab.getText().toString())) {
                cTab.dispose();
            }
            ++index;
        }
    }

    public void refreshRoleTab(UserRole role) {
        if (this.m_userRoleTab == null || this.m_userRoleTab.isDisposed()) {
            if (this.m_folder != null && !this.m_folder.isDisposed()) {
                this.m_userRoleTab = new UserRoleTab(this.m_folder, role, 0, this.m_folder.getItemCount(), this.m_readOnly);
            }
        } else if (role != null) {
            this.m_userRoleTab.setData(UserRoleTab.ROLE_NAME, role.getName());
            this.m_userRoleTab.setUserRole(role);
            this.m_userRoleTab.refreshTab();
        }
    }

    public void setTreeSelection(GroupTreeObject gto) {
        if (gto == null) {
            return;
        }
        this.m_treeViewer.setSelection((ISelection)new StructuredSelection((Object)gto));
        this.m_treeViewer.refresh();
    }

    public void setFocus() {
        try {
            this.m_treeViewer.getControl().setFocus();
            m_instance.refresh();
        }
        catch (Throwable throwable) {}
    }

    public void doubleClick(DoubleClickEvent event) {
        ISelection iSelect = event.getViewer().getSelection();
        Object obj = ((IStructuredSelection)iSelect).getFirstElement();
        if (obj instanceof GroupTreeObjectLast) {
            GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)obj;
            EditUserAction eua = new EditUserAction(this.m_treeViewer, this.m_parent.getShell(), gtoLast, this.m_roleList);
            eua.run();
        } else if (obj instanceof GroupTreeObject) {
            if (this.m_treeViewer.getExpandedState(obj)) {
                this.m_treeViewer.collapseToLevel(obj, -1);
            } else {
                this.m_treeViewer.expandToLevel(obj, 1);
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSource() instanceof TreeViewer) {
            Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (obj instanceof GroupTreeObjectLast) {
                GroupTreeObjectLast gtoLast = (GroupTreeObjectLast)obj;
                User user = ((UserTreeObject)gtoLast.getTreeObject()).getUserObject();
                if (this.m_selectedRole != null && user.m_roleName.equals(this.m_selectedRole.getName())) {
                    return;
                }
                if (UserRoleTab.getInstance() == null || !UserRoleTab.getInstance().isDirty()) {
                    this.m_currTreeSel = gtoLast;
                    this.m_selectedRole = Repository.getInstance().getUserManager().getRoleByName(user.m_roleName);
                    this.refreshRoleTab(this.m_selectedRole);
                } else {
                    UserRole newSelectedRole = Repository.getInstance().getUserManager().getRoleByName(user.m_roleName);
                    this.openSaveDialog(gtoLast, newSelectedRole);
                }
            } else if (obj instanceof GroupTreeObject) {
                GroupTreeObject gto = (GroupTreeObject)obj;
                UserRole newSelectedRole = Repository.getInstance().getUserManager().getRoleByName(gto.getName());
                if (newSelectedRole.getName().equals(this.m_selectedRole.getName())) {
                    return;
                }
                if (UserRoleTab.getInstance() == null || !UserRoleTab.getInstance().isDirty()) {
                    this.m_currTreeSel = gto;
                    this.m_selectedRole = newSelectedRole;
                    this.refreshRoleTab(this.m_selectedRole);
                } else {
                    this.openSaveDialog(gto, newSelectedRole);
                }
            }
        }
    }

    public void openSaveDialog(GroupTreeObject curSelectedGto, UserRole newSelectedRole) {
        SaveDialog dialog = new SaveDialog(this.m_folder.getShell(), this.m_selectedRole.getName());
        dialog.setBlockOnOpen(true);
        dialog.open();
        String action = dialog.getCloseType();
        if (action.equals(SaveDialog.YES)) {
            try {
                this.m_userRoleTab.save();
                this.m_currTreeSel = curSelectedGto;
                this.m_selectedRole = newSelectedRole;
                this.m_userRoleTab.clearPowerGroups();
                this.refreshRoleTab(this.m_selectedRole);
            }
            catch (Exception e) {
                MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)e.getMessage());
                this.m_treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                this.setTreeSelection(curSelectedGto);
                this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        } else if (action.equals(SaveDialog.NO)) {
            this.m_userRoleTab.undo(false);
            this.m_currTreeSel = curSelectedGto;
            this.m_selectedRole = newSelectedRole;
            this.refreshRoleTab(this.m_selectedRole);
        } else if (action.equals(SaveDialog.CANCEL)) {
            this.m_treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
            this.setTreeSelection(this.m_currTreeSel);
            this.m_treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }
    }

    @Override
    public void refresh() {
        UserManager userManager = Repository.getInstance().getUserManager();
        GroupTreeObject root = userManager.getUserTree();
        if (root == null || !root.hasElements().booleanValue()) {
            userManager.createUserTree();
        }
        try {
            Object[] expanded = this.m_treeViewer.getExpandedElements();
            this.m_treeViewer.refresh();
            if (expanded != null) {
                this.m_treeViewer.setExpandedElements(expanded);
            }
        }
        catch (Throwable throwable) {}
        this.refreshRoleTab(this.getSelectedRole());
    }

    public TreeViewer getTreeViewer() {
        return this.m_treeViewer;
    }

    public static class SaveDialog
    extends StatusDialog {
        private String m_roleName = null;
        private GUIDisplayElements m_gui = null;
        public static String YES = "YES";
        public static String NO = "NO";
        public static String CANCEL = "CANCEL";
        private String m_closeType = CANCEL;

        public SaveDialog(Shell parentShell, String roleName) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle());
            this.setImage(BMUI.IMAGE_PRODUCT);
            this.setTitle("  Save User Role");
            this.m_roleName = roleName;
        }

        protected Control createDialogArea(Composite parent) {
            this.m_gui = new GUIDisplayElements();
            Composite comp = new Composite(parent, 0);
            GridLayout gl = new GridLayout(2, false);
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            gl.marginTop = 5;
            gl.marginLeft = 5;
            comp.setLayout((Layout)gl);
            comp.setLayoutData((Object)new GridData(4, 4, true, false));
            Label image = new Label(comp, 1);
            image.setImage(BMUI.IMAGE_QUESTION_MARK);
            image.setLayoutData((Object)new GridData(16384, 128, false, false));
            StringBuffer sb = new StringBuffer();
            sb.append("'").append(this.m_roleName).append("' has been modified. Save changes?");
            Text text = this.m_gui.addTextReadOnlyMulitLineNoBorder(comp, null, sb.toString(), 1, 1, 0, 0, null);
            ((GridData)text.getLayoutData()).verticalAlignment = 0x1000000;
            ((GridData)text.getLayoutData()).horizontalIndent = 5;
            return parent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 2, "Save", false);
            this.getButton(2).setFocus();
            this.createButton(parent, 3, "No", false);
            this.createButton(parent, 1, "Cancel", true);
        }

        protected Point getInitialSize() {
            return new Point(441, 129);
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 2) {
                this.m_closeType = YES;
            } else if (buttonId == 3) {
                this.m_closeType = NO;
            } else if (buttonId == 1) {
                this.m_closeType = CANCEL;
            }
            super.close();
        }

        public String getCloseType() {
            return this.m_closeType;
        }
    }
}

