/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.authentication.UserTreeObject;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.ICommandListener;
import com.blixx.boom.engine.JobManager;
import com.blixx.boom.engine.UIJob;
import com.blixx.boom.engine.UIJobManager;
import com.blixx.boom.gui.dialogs.IRefreshable;
import com.blixx.ctrl.sc.ICmdPostProcess;
import com.blixx.ctrl.sc.IServerAuth;
import com.blixx.ctrl.sc.SCException;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.ServerClientBatch;
import com.blixx.ctrl.sc.auth.ScDeleteUser;
import com.blixx.ctrl.sc.auth.ScDeleteUserRole;
import com.blixx.ctrl.sc.auth.ScGetUItems;
import com.blixx.ctrl.sc.auth.ScGetUserRoles;
import com.blixx.ctrl.sc.auth.ScGetUsers;
import com.blixx.ctrl.sc.auth.ScPutUser;
import com.blixx.ctrl.sc.auth.ScPutUserRole;
import com.blixx.ctrl.sc.in.ScDeletePowerGroup;
import com.blixx.ctrl.sc.in.ScGetConnectedUsers;
import com.blixx.ctrl.sc.in.ScGetPowerGroups;
import com.blixx.ctrl.sc.in.ScPutPowerGroups;
import com.blixx.log.RTLogger;
import com.blixx.shared.UItem;
import com.blixx.shared.User;
import com.blixx.shared.UserRole;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.pg.PowerGroup;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class UserManager
implements IRefreshable,
ICmdPostProcess,
ICommandListener {
    private static UserManager m_instance = null;
    private List<UserRole> m_roleList = new ArrayList<UserRole>();
    private List<UItem> m_items = new ArrayList<UItem>();
    private Map<String, Integer> m_actionItems = new HashMap<String, Integer>();
    private List<User> m_users = new ArrayList<User>();
    public static String ADMINISTRATOR = "Administrator";
    public static String ADMIN = "Admin";
    public static String USER_MANAGEMENT = "1004";
    public static final String DEFAULT = "DEFAULT";
    public static final String LDAP = "LDAP";
    private List<String> m_onlineUsers;
    ConcurrentHashMap<PowerGroup, String> m_powerGroups = new ConcurrentHashMap();
    IServerAuth m_rep = null;
    private UserRole m_activeRole = null;
    private GroupTreeObject m_userTree;
    private List<IRefreshable> m_userTreeViewers = new ArrayList<IRefreshable>();
    private boolean m_isPowerGroupsSupported = false;
    public static String DUMMY_USERROLE = "DUMMY_USERROLE";

    private UserManager(IServerAuth rep) {
        this.m_rep = rep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UserManager getInstance(IServerAuth rep) {
        if (m_instance != null) return m_instance;
        Class<UserManager> clazz = UserManager.class;
        synchronized (UserManager.class) {
            if (m_instance != null) return m_instance;
            m_instance = new UserManager(rep);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return m_instance;
        }
    }

    public UserRole getActiveRole() {
        return this.m_activeRole;
    }

    public void setActiveRole(UserRole activeRole) {
        this.m_activeRole = activeRole;
    }

    public boolean isPowerGroupsSupported() {
        return this.m_isPowerGroupsSupported;
    }

    public boolean saveUser(User user) {
        boolean isOk = true;
        try {
            ScPutUser sc = new ScPutUser(this.m_rep, new User[]{user});
            sc.addCmdPostProcess(this);
            sc.start();
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error saving user " + user.m_loginName, e);
        }
        return isOk;
    }

    public boolean saveUserSync(User user) {
        boolean isOk = true;
        try {
            ScPutUser sc = new ScPutUser(this.m_rep, new User[]{user});
            sc.run();
            if (!sc.isSuccess()) {
                String error = sc.getResultObject();
                if (error == null) {
                    error = sc.getLastException() == null ? "Unknown network problem occured." : sc.getLastException().getMessage();
                }
                throw new RuntimeException(error);
            }
        }
        catch (Throwable e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)("Cannot save User!\n" + e.getMessage()));
            RTLogger.print(5, "Error saving user " + user.m_loginName, e);
        }
        return isOk;
    }

    public boolean saveUsers(List<User> users) {
        boolean isOk = true;
        try {
            ScPutUser sc = new ScPutUser(this.m_rep, users.toArray(new User[0]));
            sc.addCmdPostProcess(this);
            sc.start();
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error saving users " + users, e);
        }
        return isOk;
    }

    public boolean deleteUser(User user) {
        boolean isSuccess = true;
        try {
            ScDeleteUser sc = new ScDeleteUser(this.m_rep, new User[]{user});
            sc.addCmdPostProcess(this);
            sc.start();
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error deleting user " + user.m_loginName, e);
        }
        return isSuccess;
    }

    public boolean deleteUsers(List<User> users) {
        boolean isSuccess = true;
        try {
            ScDeleteUser sc = new ScDeleteUser(this.m_rep, users.toArray(new User[0]));
            sc.addCmdPostProcess(this);
            sc.start();
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error deleting users " + users, e);
        }
        return isSuccess;
    }

    public boolean saveRole(UserRole role) {
        boolean isSuccess = true;
        try {
            ScPutUserRole sc = new ScPutUserRole(this.m_rep, new UserRole[]{role});
            sc.addCmdPostProcess(this);
            sc.start();
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error saving role " + role.getName(), e);
        }
        return isSuccess;
    }

    public boolean deleteRole(UserRole role) {
        boolean isSuccess = true;
        try {
            ScDeleteUserRole sc = new ScDeleteUserRole(this.m_rep, new UserRole[]{role});
            sc.addCmdPostProcess(this);
            sc.start();
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "Error deleting user role " + role.getName(), e);
        }
        return isSuccess;
    }

    public List<UserRole> getRoleList() {
        return this.m_roleList;
    }

    public List<User> getUsers() {
        return this.m_users;
    }

    public boolean userExist(String username) {
        boolean b = false;
        for (User user : this.m_users) {
            if (!username.equalsIgnoreCase(user.m_loginName)) continue;
            b = true;
            break;
        }
        return b;
    }

    public String getCorrectUserName(String name) {
        name = name.trim();
        for (User user : this.m_users) {
            if (!name.equalsIgnoreCase(user.m_loginName)) continue;
            return user.m_loginName;
        }
        return null;
    }

    public String getCorrectRoleName(String name) {
        if (name != null) {
            if ((name = name.trim()).startsWith("[")) {
                name = name.replace("[", "");
                name = name.replace("]", "");
            }
            int index = 0;
            while (index < this.m_roleList.size()) {
                UserRole role = this.m_roleList.get(index);
                if (role.getName().equalsIgnoreCase(name)) {
                    return role.getName();
                }
                ++index;
            }
        }
        return null;
    }

    public List<UItem> getUItems() {
        return this.m_items;
    }

    public UItem getUItem(int id) {
        UItem item = null;
        for (UItem uui : this.m_items) {
            if (uui.m_ID != id) continue;
            return uui;
        }
        return item;
    }

    public int getUItemIDForActionGroup(String name) {
        int itemID = -1;
        if (this.m_actionItems.containsKey(name)) {
            itemID = this.m_actionItems.get(name);
        }
        return itemID;
    }

    public UserRole getRoleByName(String name) {
        UserRole role = null;
        int index = 0;
        while (index < this.m_roleList.size()) {
            role = this.m_roleList.get(index);
            if (role.getName().equals(name)) {
                return role;
            }
            ++index;
        }
        return null;
    }

    public UserRole getRoleByID(String roleID) {
        UserRole role = null;
        int index = 0;
        while (index < this.m_roleList.size()) {
            role = this.m_roleList.get(index);
            if (role.getID().equals(roleID)) break;
            ++index;
        }
        return role;
    }

    public User getUserByLoginName(String name) {
        User user = null;
        int index = 0;
        while (index < this.m_users.size()) {
            user = this.m_users.get(index);
            if (user.m_loginName.equals(name)) {
                return user;
            }
            ++index;
        }
        return null;
    }

    public ArrayList<String> getAllUserFromRole(String roleName) {
        ArrayList<String> users = new ArrayList<String>();
        int i = 0;
        while (i < this.m_users.size()) {
            User user = this.m_users.get(i);
            if (user.m_roleName.equals(roleName)) {
                users.add(user.m_loginName);
            }
            ++i;
        }
        return users;
    }

    public boolean roleExist(String name) {
        boolean doExist = false;
        UserRole role = null;
        int index = 0;
        while (index < this.m_roleList.size()) {
            role = this.m_roleList.get(index);
            if (role.getName().equals(name)) {
                doExist = true;
                break;
            }
            ++index;
        }
        return doExist;
    }

    private void scheduleGetConnectedUsers() {
        ScGetConnectedUsers sc = new ScGetConnectedUsers(this.m_rep);
        sc.addCmdPostProcess(this);
        sc.start();
    }

    private void processItems(List<UItem> list) {
        this.m_items.clear();
        this.m_items.addAll(list);
        this.m_actionItems.clear();
        for (UItem uItem : this.m_items) {
            int id = uItem.m_ID;
            if (id < 8000 || id >= 9000) continue;
            this.m_actionItems.put(uItem.m_name, id);
        }
    }

    private void fetchRoles() {
        ScGetUserRoles sc = new ScGetUserRoles(this.m_rep);
        sc.addCmdPostProcess(this);
        sc.start();
    }

    public void fetchUsers() {
        block13: {
            ServerClientBatch scb = new ServerClientBatch(this.m_rep);
            try {
                try {
                    ScGetUsers sc = new ScGetUsers(null);
                    scb.runBatch(sc);
                    if (sc.isSuccess()) {
                        this.m_users.clear();
                        this.m_users.addAll((Collection<User>)sc.getResultObject());
                    }
                    ScGetUItems sc3 = new ScGetUItems(null);
                    scb.runBatch(sc3);
                    if (sc3.isSuccess()) {
                        this.processItems((List<UItem>)sc3.getResultObject());
                    }
                }
                catch (SCException e) {
                    RTLogger.print(2, "", e);
                    try {
                        scb.close();
                    }
                    catch (Throwable throwable) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    scb.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                scb.close();
            }
            catch (Throwable throwable) {}
        }
        this.scheduleGetConnectedUsers();
    }

    public void fetchAll() {
        block16: {
            ServerClientBatch scb = new ServerClientBatch(this.m_rep);
            try {
                try {
                    ScGetUsers sc = new ScGetUsers(null);
                    scb.runBatch(sc);
                    if (sc.isSuccess()) {
                        this.m_users.clear();
                        this.m_users.addAll((Collection<User>)sc.getResultObject());
                    }
                    ScGetUserRoles sc2 = new ScGetUserRoles(null);
                    scb.runBatch(sc2);
                    if (sc2.isSuccess()) {
                        String activeRoleId = this.getActiveRole().getID();
                        this.m_roleList.clear();
                        this.m_roleList.addAll((Collection<UserRole>)sc2.getResultObject());
                        for (UserRole role : this.m_roleList) {
                            if (!role.getID().equals(activeRoleId)) continue;
                            this.setActiveRole(role);
                        }
                    }
                    ScGetUItems sc3 = new ScGetUItems(null);
                    scb.runBatch(sc3);
                    if (sc3.isSuccess()) {
                        this.processItems((List<UItem>)sc3.getResultObject());
                    }
                    ScGetPowerGroups sc4 = new ScGetPowerGroups(this.m_rep, null);
                    sc4.run();
                    if (sc4.isSuccess()) {
                        this.m_powerGroups.clear();
                        this.m_powerGroups.putAll((Map<PowerGroup, String>)sc4.getResultObject());
                    }
                    this.m_isPowerGroupsSupported = sc4.isSupported();
                }
                catch (SCException e) {
                    RTLogger.print(2, "", e);
                    try {
                        scb.close();
                    }
                    catch (Throwable throwable) {}
                    break block16;
                }
            }
            catch (Throwable throwable) {
                try {
                    scb.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                scb.close();
            }
            catch (Throwable throwable) {}
        }
        this.scheduleGetConnectedUsers();
    }

    public void addUserTreeListener(IRefreshable comp) {
        if (comp != null && !this.m_userTreeViewers.contains(comp)) {
            this.m_userTreeViewers.add(comp);
        }
    }

    public GroupTreeObject getUserTree() {
        if (this.m_userTree == null) {
            this.m_userTree = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
        }
        return this.m_userTree;
    }

    public GroupTreeObject createUserTree() {
        HashMap<String, GroupTreeObject> roles = new HashMap<String, GroupTreeObject>();
        if (this.m_userTree == null) {
            this.m_userTree = new GroupTreeObject(new TreeObject("root", BMUI.type_folder, null));
        } else {
            for (GroupTreeObject gtoRole : this.m_userTree.getElements()) {
                gtoRole.clean();
                roles.put(gtoRole.getName(), gtoRole);
            }
            this.m_userTree.clean();
        }
        UserRole role = null;
        int index = 0;
        while (index < this.getRoleList().size()) {
            role = this.getRoleList().get(index);
            GroupTreeObject gto = this.m_userTree.findFirstGroupByName(role.getName());
            if (gto == null) {
                gto = (GroupTreeObject)roles.get(role.getName());
                if (gto == null) {
                    gto = new GroupTreeObject(new TreeObject(role.getName(), BMUI.type_folder, null));
                }
                this.m_userTree.addElement(gto);
            }
            ++index;
        }
        for (User user : this.getUsers()) {
            GroupTreeObject roleGTO = this.m_userTree.findFirstGroupByName(user.m_roleName);
            if (roleGTO == null) continue;
            UserTreeObject userTreeObj = new UserTreeObject(user);
            String image = null;
            image = this.getUserImageStr(user);
            GroupTreeObjectLast userTreeElement = new GroupTreeObjectLast(userTreeObj, null, image);
            try {
                roleGTO.addElement(userTreeElement);
            }
            catch (Throwable throwable) {}
        }
        return this.m_userTree;
    }

    public List<String> getConnectedUsers() {
        ScGetConnectedUsers sc = new ScGetConnectedUsers(this.m_rep);
        sc.run();
        this.m_onlineUsers = sc.isSuccess() ? sc.getResultObject() : new ArrayList<String>(0);
        return this.m_onlineUsers;
    }

    public Image getUserImage(User user) {
        return BMUI.IMAGE_MAP.get(this.getUserImageStr(user));
    }

    public String getUserImageStr(User user) {
        String imageStr = null;
        imageStr = this.getUserType(user).equals(LDAP) ? (!user.isActive() ? "IMAGE_USER_NOTACTIVE_LDAP" : (this.isUserOnline(user) ? "IMAGE_USER_ON_LDAP" : "IMAGE_USER_OFF_LDAP")) : (!user.isActive() ? "IMAGE_USER_NOTACTIVE" : (this.isUserOnline(user) ? "IMAGE_USER_ON" : "IMAGE_USER_OFF"));
        return imageStr;
    }

    public boolean isUserOnline(User user) {
        return this.m_onlineUsers != null && this.m_onlineUsers.contains(user.m_loginName);
    }

    public String getUserType(User user) {
        if (user.m_pwd.equals(LDAP)) {
            return LDAP;
        }
        return DEFAULT;
    }

    @Override
    public void refresh() {
        if (Display.findDisplay((Thread)Thread.currentThread()) == null) {
            UIJob j = new UIJob(null){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        UserManager.this.createUserTree();
                        for (IRefreshable r : UserManager.this.m_userTreeViewers) {
                            try {
                                r.refresh();
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (Throwable throwable) {}
                    return Status.OK_STATUS;
                }
            };
            UIJobManager.getInstance().schedule(j);
        } else {
            this.createUserTree();
            for (IRefreshable r : this.m_userTreeViewers) {
                try {
                    r.refresh();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void onCommand(String command, String action) {
        if ("GET_POWERGROUPS".equals(command)) {
            this.loadPowerGroups();
        } else if ("GET_CONNECTED_USERS".equals(command)) {
            this.scheduleGetConnectedUsers();
        }
    }

    public void postProcess(ServerClient sc) {
        String error = null;
        if (sc != null) {
            Object res;
            if (sc instanceof ScGetConnectedUsers) {
                if (sc.isSuccess()) {
                    this.m_onlineUsers = ((ScGetConnectedUsers)sc).getResultObject();
                }
            } else if (sc instanceof ScGetPowerGroups) {
                if (sc.isSuccess()) {
                    ScGetPowerGroups s = (ScGetPowerGroups)sc;
                    this.m_powerGroups.clear();
                    this.m_powerGroups.putAll((Map<PowerGroup, String>)s.getResultObject());
                }
                this.m_isPowerGroupsSupported = sc.isSupported();
            } else if (sc instanceof ScPutUser) {
                if (sc.isSuccess()) {
                    this.fetchUsers();
                } else {
                    error = sc.getLastException() == null ? ((res = sc.getResultObject()) != null && res instanceof String ? (String)sc.getResultObject() : "Unexpected server error") : sc.getLastException().getMessage();
                    error = "Error saving User: " + error;
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, error);
                    }
                }
            } else if (sc instanceof ScDeleteUser) {
                if (sc.isSuccess()) {
                    this.fetchUsers();
                } else {
                    error = sc.getLastException() == null ? ((res = sc.getResultObject()) != null && res instanceof String ? (String)sc.getResultObject() : "Unexpected server error") : sc.getLastException().getMessage();
                    error = "Error deleting User: " + error;
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, error);
                    }
                }
            } else if (sc instanceof ScPutUserRole) {
                if (sc.isSuccess()) {
                    this.fetchRoles();
                } else {
                    error = sc.getLastException() == null ? ((res = sc.getResultObject()) != null && res instanceof String ? (String)sc.getResultObject() : "Unexpected server error") : sc.getLastException().getMessage();
                    error = "Error saving UserRole: " + error;
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, error);
                    }
                }
            } else if (sc instanceof ScDeleteUserRole) {
                if (sc.isSuccess()) {
                    this.fetchRoles();
                } else {
                    error = sc.getLastException() == null ? ((res = sc.getResultObject()) != null && res instanceof String ? (String)sc.getResultObject() : "Unexpected server error") : sc.getLastException().getMessage();
                    error = "Error deleting UserRole: " + error;
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, error);
                    }
                }
            } else if (sc instanceof ScGetUserRoles) {
                if (sc.isSuccess()) {
                    this.m_roleList.clear();
                    this.m_roleList.addAll((Collection<UserRole>)((ScGetUserRoles)sc).getResultObject());
                } else {
                    error = sc.getLastException() == null ? ((res = sc.getResultObject()) != null && res instanceof String ? (String)sc.getResultObject() : "Unexpected server error") : sc.getLastException().getMessage();
                    error = "Error getting UserRoles: " + error;
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, error);
                    }
                }
            } else if (sc instanceof ScPutPowerGroups) {
                if (sc.isSuccess()) {
                    this.loadPowerGroups();
                } else {
                    error = sc.getLastException() == null ? ((res = sc.getResultObject()) != null && res instanceof String ? (String)sc.getResultObject() : "Unexpected server error") : sc.getLastException().getMessage();
                    error = "Error saving Privileged Group: " + error;
                    if (RTLogger.getCurrentLevel() >= 5) {
                        RTLogger.print(5, error);
                    }
                }
            }
            this.refresh();
        }
        if (error != null) {
            final String ferror = error;
            UIJob j = new UIJob(null){

                @Override
                public IStatus runInUIThread(IProgressMonitor monitor) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)ferror);
                    return null;
                }
            };
            UIJobManager.getInstance().schedule(j);
        }
    }

    public void loadPowerGroups() {
        ScGetPowerGroups sc = new ScGetPowerGroups(this.m_rep, null);
        sc.addCmdPostProcess(this);
        JobManager.getInstance().schedule(sc);
    }

    public GroupTreeObject getPowerGroups(String roleID) {
        UserRole r = this.getRoleByID(roleID);
        GroupTreeObject root = new GroupTreeObject(new TreeObject(r.getName(), BMUI.type_folder, r));
        for (Map.Entry<PowerGroup, String> en : this.m_powerGroups.entrySet()) {
            if (!roleID.equals(en.getValue())) continue;
            PowerGroup p = en.getKey();
            GroupTreeObject pg = root.getChild(p.m_name, BMUI.type_folder);
            if (pg == null) {
                pg = new GroupTreeObject(new TreeObject(p.m_name, BMUI.type_folder, p));
                root.addElement(pg);
            }
            for (PGItem item : p.getAllItems()) {
                GroupTreeObjectLast itemGTOL = new GroupTreeObjectLast(new TreeObject(item.toString(), BMUI.type_file, item), null, null);
                pg.addElement(itemGTOL);
            }
        }
        return root;
    }

    public List<String> getPowerGroupIDs(String roleID) {
        LinkedList<String> ids = new LinkedList<String>();
        for (Map.Entry<PowerGroup, String> en : this.m_powerGroups.entrySet()) {
            if (!roleID.equals(en.getValue())) continue;
            PowerGroup p = en.getKey();
            ids.add(p.m_ID);
        }
        return ids;
    }

    public ScPutPowerGroups savePowerGroup(String roleID, List<PowerGroup> pgList, boolean sync) {
        ScPutPowerGroups sc = new ScPutPowerGroups(this.m_rep, roleID, pgList);
        if (sync) {
            sc.run();
        } else {
            sc.addCmdPostProcess(this);
            sc.start();
        }
        return sc;
    }

    public ScDeletePowerGroup deletePowerGroups(String roleID, List<String> pgIDsList, boolean sync) {
        ScDeletePowerGroup sc = new ScDeletePowerGroup(this.m_rep, roleID, pgIDsList);
        if (sync) {
            sc.run();
        } else {
            sc.addCmdPostProcess(this);
            sc.start();
        }
        return sc;
    }
}

