/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.authentication.PGItemDialog;
import com.blixx.boom.authentication.TableContentProvider;
import com.blixx.boom.authentication.TableItemObject;
import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.Activator;
import com.blixx.boom.gui.dialogs.ShowMessageBox;
import com.blixx.boom.gui.dialogs.SinglelineInputDialog;
import com.blixx.boom.gui.policies.FPolicyManager;
import com.blixx.boom.gui.policies.ViewContentProvider;
import com.blixx.boom.gui.policies.ViewLabelProvider;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.boom.gui.utils.ICanSetTreeDirty;
import com.blixx.boom.gui.utils.STreeViewer;
import com.blixx.boom.gui.utils.TreeElementComparer;
import com.blixx.boom.gui.utils.UserRoleTableFilter;
import com.blixx.boom.gui.views.FancyToolTipSupport;
import com.blixx.boom.gui.views.ServerFilterOverviewTab;
import com.blixx.boom.gui.views.ServerFilterTableProvider;
import com.blixx.boom.gui.views.ServerFilterUsersTab;
import com.blixx.boom.gui.views.ServerFilterView;
import com.blixx.boom.gui.views.actions.ExpandCollapseAction;
import com.blixx.boom.gui.views.actions.RefreshUserRoleTabAction;
import com.blixx.boom.gui.views.actions.ShowViewAction;
import com.blixx.boom.gui.views.dnd.DNDCopyPGItem;
import com.blixx.boom.gui.views.dnd.DNDPastePGItem;
import com.blixx.ctrl.sc.ServerClient;
import com.blixx.ctrl.sc.in.ScDeletePowerGroup;
import com.blixx.shared.UserRight;
import com.blixx.shared.UserRole;
import com.blixx.shared.ext.ForwardCondition;
import com.blixx.shared.ext.ForwardPolicy;
import com.blixx.shared.pg.ObjectType;
import com.blixx.shared.pg.PGEntityAction;
import com.blixx.shared.pg.PGEntityPermissionFlag;
import com.blixx.shared.pg.PGItem;
import com.blixx.shared.pg.PowerGroup;
import com.blixx.shared.utils.GroupTreeObject;
import com.blixx.shared.utils.GroupTreeObjectLast;
import com.blixx.shared.utils.GroupTreeObjectUnsubmitted;
import com.blixx.shared.utils.TreeObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.ISharedImages;

public class UserRoleTab
extends CTabItem
implements SelectionListener,
MouseListener,
ICanSetTreeDirty,
IDoubleClickListener {
    private static UserRoleTab m_instance = null;
    private UserRole m_selectedRole = null;
    private GroupTreeObject m_powerGroups = null;
    private boolean m_pgDirty = false;
    private CTabFolder m_folder = null;
    private GUIDisplayElements m_gui = null;
    private SashForm m_sash = null;
    private Composite m_compInTab = null;
    private ScrolledComposite sc = null;
    private Table m_generalTable = null;
    private Table m_actGrpTable = null;
    private TableViewer general_tableViewer = null;
    private TableViewer m_actGrp_tableViewer = null;
    private TableContentProvider m_general_contentProvider = null;
    private TableContentProvider m_actGrp_contentProvider = null;
    private Text m_actionGrpTitle = null;
    private boolean m_readOnly = false;
    private boolean m_isDirty = false;
    private boolean m_isPGSuported = false;
    private Button m_save_btn = null;
    private Button m_undo_btn = null;
    private Button m_addPGItem_btn = null;
    private Button m_addPGGroup_btn = null;
    private Button m_delPGElement_btn = null;
    private Button m_editPGItem_btn = null;
    public STreeViewer pgviewer = null;
    private int m_globalActRights = 0;
    private ServerFilterTableProvider m_userFilterTableProvider = null;
    private TableViewer m_userFilter_tv = null;
    private Map<ForwardPolicy, String> m_userFilters_orig = null;
    public static String TAB = "TAB";
    public static String CONTENT_PROVIDER = "CONTENT_PROVIDER";
    public static String TABLE_VIEWER = "TABLE_VIEWER";
    public static String TABLE_TYPE = "TABLE_TYPE";
    public static String GENERAL_TABLE = "GENERAL_TABLE";
    public static String ACTION_TABLE = "ACTION_TABLE";
    public static String POWERGROUP_TABLE = "POWERGROUP_TABLE";
    public static String PG_TREE = "PG_TREE";
    public static String TREE_VIEWER_TYPE = "TREE_VIEWER_TYPE";
    public static String BUTTON_SAVE = "SAVE";
    public static String BUTTON_UNDO = "UNDO";
    public static String ROLE_NAME = "ROLE_NAME";
    private static final String ADDPG = "ADDPG";
    private static final String DELETEITEM = "DELETEITEM";
    private static final String EDITITEM = "EDITITEM";
    private static final String ADDITEM = "ADDITEM";
    private boolean m_hasOwnerRights_on_userManagement = Repository.getInstance().getRights(1004) == 3;
    public Listener sortListenerUserFilterTable = new Listener(){

        public void handleEvent(Event e) {
            if (e.type == 13) {
                TableColumn sortColumn = UserRoleTab.this.m_userFilter_tv.getTable().getSortColumn();
                TableColumn currentColumn = (TableColumn)e.widget;
                int dir = UserRoleTab.this.m_userFilter_tv.getTable().getSortDirection();
                if (sortColumn == currentColumn) {
                    dir = dir == 128 ? 1024 : 128;
                } else {
                    UserRoleTab.this.m_userFilter_tv.getTable().setSortColumn(currentColumn);
                    dir = 128;
                }
                String sortIdentifier = currentColumn.getText();
                UserRoleTab.this.m_userFilterTableProvider.setSortingProps(sortIdentifier, dir);
                UserRoleTab.this.m_userFilter_tv.getTable().setSortDirection(dir);
                ISelection sel = UserRoleTab.this.m_userFilter_tv.getSelection();
                if (UserRoleTab.this.m_userFilter_tv.getSorter() != UserRoleTab.this.m_userFilterTableProvider) {
                    UserRoleTab.this.m_userFilter_tv.setSorter((ViewerSorter)UserRoleTab.this.m_userFilterTableProvider);
                } else {
                    UserRoleTab.this.m_userFilter_tv.refresh(true, false);
                }
                UserRoleTab.this.m_userFilter_tv.setSelection(sel, false);
            }
        }
    };

    public static UserRoleTab getInstance() {
        return m_instance;
    }

    public UserRoleTab(CTabFolder folder, UserRole role, int style, int index, boolean readOnly) {
        super(folder, style);
        m_instance = this;
        this.m_folder = folder;
        this.m_readOnly = readOnly;
        this.m_userFilters_orig = new HashMap<ForwardPolicy, String>();
        this.m_gui = new GUIDisplayElements();
        this.setUserRole(role);
        if (this.getUserRole() == null) {
            this.setUserRole(UserRole.createNewRole());
        }
        this.setData(ROLE_NAME, this.getUserRole().getName());
        this.setCTabTitle(this.getUserRole().getName());
        this.m_powerGroups = Repository.getInstance().getUserManager().getPowerGroups(this.getUserRole().getID());
        this.m_isPGSuported = Repository.getInstance().getUserManager().isPowerGroupsSupported();
        this.m_compInTab = new Composite((Composite)this.m_folder, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        this.m_compInTab.setLayout((Layout)gl);
        GridData gd = new GridData(4, 4, true, true);
        this.m_compInTab.setLayoutData((Object)gd);
        Composite mainComp = new Composite(this.m_compInTab, 0);
        mainComp.setLayout((Layout)gl);
        mainComp.setLayoutData((Object)gd);
        this.m_sash = new SashForm(mainComp, 513);
        this.m_sash.setLayout((Layout)gl);
        this.m_sash.setLayoutData((Object)gd);
        this.createGeneralRightsTable(this.m_sash);
        this.createActionRightsTable(this.m_sash);
        if (this.m_isPGSuported) {
            this.createPrivilegedGroupsTree(this.m_sash);
        }
        this.createUserFilterTable(this.m_sash);
        if (this.m_isPGSuported) {
            this.m_sash.setWeights(new int[]{25, 25, 25, 25});
        } else {
            this.m_sash.setWeights(new int[]{35, 35, 30});
        }
        this.m_sash.computeSize(-1, -1, true);
        Composite compLine = new Composite(this.m_compInTab, 0);
        compLine.setLayout((Layout)gl);
        compLine.setLayoutData((Object)new GridData(4, 128, true, false));
        Label line = new Label(compLine, 259);
        line.setForeground(BMUI.color_darkGrey2);
        line.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Composite compBtn = new Composite(this.m_compInTab, 0);
        compBtn.setLayout((Layout)new GridLayout(2, true));
        compBtn.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.m_save_btn = this.m_gui.addButton(compBtn, BUTTON_SAVE, " Save ", false, 80, 20, 3, this);
        this.m_save_btn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.m_undo_btn = this.m_gui.addButton(compBtn, BUTTON_UNDO, " Undo Changes ", false, 80, 20, 3, this);
        this.m_undo_btn.setLayoutData((Object)new GridData(4, 128, false, false, 1, 1));
        this.setControl((Control)this.m_compInTab);
    }

    public void createGeneralRightsTable(SashForm sash) {
        Composite comp = new Composite((Composite)sash, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_gui.addTextReadOnlyNoBorder(comp, null, "General Rights", 1, 1, 5, 5, BMUI.font_arial8_bold);
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_generalTable = new Table(tableComp, 0x10000B00);
        this.m_generalTable.setHeaderVisible(true);
        this.m_generalTable.setBackground(BMUI.color_unknown);
        this.m_generalTable.setLayout((Layout)gl);
        this.m_generalTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_generalTable.addMouseListener((MouseListener)this);
        TableColumn col1 = new TableColumn(this.m_generalTable, 16384);
        col1.setText("Name");
        col1.setWidth(150);
        TableColumn col2 = new TableColumn(this.m_generalTable, 16384);
        col2.setText("Disabled");
        col2.setWidth(60);
        TableColumn col3 = new TableColumn(this.m_generalTable, 16384);
        col3.setText("Guest");
        col3.setWidth(55);
        TableColumn col4 = new TableColumn(this.m_generalTable, 16384);
        col4.setText("Owner");
        col4.setWidth(55);
        TableColumn col5 = new TableColumn(this.m_generalTable, 16384);
        col5.setText("Description");
        col5.setWidth(300);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(0, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(100, col5.getWidth()));
        this.general_tableViewer = new TableViewer(this.m_generalTable);
        this.m_general_contentProvider = new TableContentProvider(m_instance, this.getUserRole(), GENERAL_TABLE);
        this.general_tableViewer.setContentProvider((IContentProvider)this.m_general_contentProvider);
        this.general_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_general_contentProvider);
        this.general_tableViewer.setInput((Object)this.m_general_contentProvider.getElements(null));
        this.m_generalTable.setData(TAB, (Object)m_instance);
        this.m_generalTable.setData(TABLE_TYPE, (Object)GENERAL_TABLE);
        this.m_generalTable.setData(CONTENT_PROVIDER, (Object)this.m_general_contentProvider);
        this.m_generalTable.setData(TABLE_VIEWER, (Object)this.general_tableViewer);
        this.m_generalTable.setToolTipText("");
        this.addListenersToTable(this.m_generalTable);
    }

    public void createActionRightsTable(SashForm sash) {
        Composite comp = new Composite((Composite)sash, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label l = new Label(comp, 0);
        l.setImage(BMUI.IMAGE_DESCR_ACTION.createImage());
        l.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.m_actionGrpTitle = this.m_gui.addTextReadOnlyNoBorder(comp, null, "Action Rights", 1, 1, 0, 10, BMUI.font_arial8_bold);
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_actGrpTable = new Table(tableComp, 0x10000B00);
        this.m_actGrpTable.setHeaderVisible(true);
        this.m_actGrpTable.setBackground(BMUI.color_unknown);
        this.m_actGrpTable.setLayout((Layout)gl);
        this.m_actGrpTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_actGrpTable.addMouseListener((MouseListener)this);
        TableColumn col1 = new TableColumn(this.m_actGrpTable, 16384);
        col1.setText("ActionGroup Name");
        col1.setWidth(150);
        TableColumn col2 = new TableColumn(this.m_actGrpTable, 16384);
        col2.setText("Disabled");
        col2.setWidth(60);
        TableColumn col3 = new TableColumn(this.m_actGrpTable, 16384);
        col3.setText("Guest");
        col3.setWidth(55);
        TableColumn col4 = new TableColumn(this.m_actGrpTable, 16384);
        col4.setText("Owner");
        col4.setWidth(55);
        TableColumn col5 = new TableColumn(this.m_actGrpTable, 16384);
        col5.setText("ActionGroup File Name");
        col5.setWidth(300);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(0, col3.getWidth()));
        tableLayout.setColumnData((Widget)col4, (ColumnLayoutData)new ColumnWeightData(0, col4.getWidth()));
        tableLayout.setColumnData((Widget)col5, (ColumnLayoutData)new ColumnWeightData(100, col5.getWidth()));
        this.m_actGrp_tableViewer = new TableViewer(this.m_actGrpTable);
        this.m_actGrp_contentProvider = new TableContentProvider(m_instance, this.getUserRole(), ACTION_TABLE);
        this.m_actGrp_tableViewer.setContentProvider((IContentProvider)this.m_actGrp_contentProvider);
        this.m_actGrp_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_actGrp_contentProvider);
        this.m_actGrp_tableViewer.setInput((Object)this.m_actGrp_contentProvider.getElements(null));
        this.m_actGrpTable.setData(TAB, (Object)m_instance);
        this.m_actGrpTable.setData(TABLE_TYPE, (Object)ACTION_TABLE);
        this.m_actGrpTable.setData(CONTENT_PROVIDER, (Object)this.m_actGrp_contentProvider);
        this.m_actGrpTable.setData(TABLE_VIEWER, (Object)this.m_actGrp_tableViewer);
        this.m_actGrpTable.setToolTipText("");
        this.addListenersToTable(this.m_actGrpTable);
    }

    public void createPrivilegedGroupsTree(SashForm sash) {
        this.sc = new ScrolledComposite((Composite)sash, 2816);
        GridData layoutData = new GridData(4, 4, true, true);
        this.sc.setLayoutData((Object)layoutData);
        this.sc.setAlwaysShowScrollBars(false);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sc.setLayout((Layout)new GridLayout(1, false));
        this.sc.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite comp = new Composite((Composite)this.sc, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginBottom = 5;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.m_gui.addTextReadOnlyNoBorder(comp, null, "Privileged Groups", 2, 1, 0, 10, BMUI.font_arial8_bold);
        this.pgviewer = new STreeViewer(comp, 2818);
        this.pgviewer.setData(TREE_VIEWER_TYPE, PG_TREE);
        this.pgviewer.getTree().setLayoutData((Object)layoutData);
        this.pgviewer.setComparer(new TreeElementComparer());
        this.pgviewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.pgviewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(null, null));
        this.pgviewer.setInput(this.m_powerGroups);
        this.pgviewer.expandToLevel(2);
        GridData gd = new GridData(4, 4, true, false);
        gd.heightHint = 80;
        this.pgviewer.getTree().setLayoutData((Object)gd);
        this.pgviewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                try {
                    STreeViewer tv = (STreeViewer)((Object)arg0.getSource());
                    StructuredSelection ss = (StructuredSelection)tv.getSelection();
                    if (!ss.isEmpty()) {
                        GroupTreeObject pgigto = (GroupTreeObject)ss.getFirstElement();
                        if (pgigto instanceof GroupTreeObjectLast) {
                            EditPGItem editItemAction = new EditPGItem(m_instance, UserRoleTab.this.pgviewer, UserRoleTab.this.m_hasOwnerRights_on_userManagement);
                            editItemAction.run();
                        } else {
                            tv.setExpandedState(pgigto, !tv.getExpandedState(pgigto));
                        }
                    }
                }
                catch (Throwable throwable) {}
            }
        });
        this.pgviewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (UserRoleTab.this.m_hasOwnerRights_on_userManagement) {
                    UserRoleTab.this.checkPGButtons();
                }
            }
        });
        this.createContentMenu_privGroups();
        Composite button_comp = new Composite(comp, 0);
        GridData gd1 = new GridData(131072, 4, false, true);
        gd1.widthHint = 80;
        button_comp.setLayoutData((Object)gd1);
        GridLayout gl1 = new GridLayout(1, false);
        gl1.verticalSpacing = 0;
        gl1.marginHeight = 0;
        gl1.marginWidth = 0;
        button_comp.setLayout((Layout)gl1);
        GridData bgd = new GridData(4, 128, true, false);
        this.m_addPGGroup_btn = this.m_gui.addButton(button_comp, ADDPG, "Add Group", false, this);
        this.m_addPGGroup_btn.setLayoutData((Object)bgd);
        this.m_addPGItem_btn = this.m_gui.addButton(button_comp, ADDITEM, "Add Item", false, this);
        this.m_addPGItem_btn.setLayoutData((Object)bgd);
        this.m_editPGItem_btn = this.m_gui.addButton(button_comp, EDITITEM, "Edit Item", false, this);
        this.m_editPGItem_btn.setLayoutData((Object)bgd);
        this.m_delPGElement_btn = this.m_gui.addButton(button_comp, DELETEITEM, "Delete", false, this);
        this.m_delPGElement_btn.setLayoutData((Object)bgd);
        if (this.m_hasOwnerRights_on_userManagement) {
            this.checkPGButtons();
        }
        this.sc.setContent((Control)comp);
        this.sc.setMinSize(comp.computeSize(-1, -1, true));
    }

    public void createContentMenu_privGroups() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(this.pgviewer.getControl());
        this.pgviewer.getControl().setMenu(menu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)new AddPGGroup(UserRoleTab.this.pgviewer, UserRoleTab.this.m_powerGroups, UserRoleTab.this.m_hasOwnerRights_on_userManagement));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new AddPGItem(m_instance, UserRoleTab.this.pgviewer, UserRoleTab.this.m_hasOwnerRights_on_userManagement));
                manager.add((IAction)new EditPGItem(m_instance, UserRoleTab.this.pgviewer, UserRoleTab.this.m_hasOwnerRights_on_userManagement));
                manager.add((IAction)new DeletePGItem(m_instance, UserRoleTab.this.pgviewer, UserRoleTab.this.m_hasOwnerRights_on_userManagement));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new DNDCopyPGItem((StructuredViewer)UserRoleTab.this.pgviewer, UserRoleTab.this.m_hasOwnerRights_on_userManagement));
                manager.add((IAction)new DNDPastePGItem(UserRoleTab.this.pgviewer, m_instance, UserRoleTab.this.m_hasOwnerRights_on_userManagement));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new ExpandCollapseAction(UserRoleTab.this.pgviewer, "ExpandAll"));
                manager.add((IAction)new ExpandCollapseAction(UserRoleTab.this.pgviewer, "CollapseAll"));
            }
        });
    }

    public void checkPGButtons() {
        this.m_addPGGroup_btn.setEnabled(true);
        StructuredSelection ssel = (StructuredSelection)this.pgviewer.getSelection();
        if (ssel.isEmpty()) {
            this.m_addPGItem_btn.setEnabled(false);
            this.m_editPGItem_btn.setEnabled(false);
            this.m_delPGElement_btn.setEnabled(false);
        } else {
            this.m_delPGElement_btn.setEnabled(true);
            if (ssel.size() == 1) {
                this.m_addPGItem_btn.setEnabled(true);
                GroupTreeObject gto = (GroupTreeObject)ssel.getFirstElement();
                if (gto instanceof GroupTreeObjectLast) {
                    this.m_editPGItem_btn.setEnabled(true);
                } else {
                    this.m_editPGItem_btn.setEnabled(false);
                }
            } else {
                this.m_addPGItem_btn.setEnabled(false);
                this.m_editPGItem_btn.setEnabled(false);
            }
        }
    }

    public void createUserFilterTable(SashForm sash) {
        Composite comp = new Composite((Composite)sash, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        Label l = new Label(comp, 0);
        l.setImage(BMUI.IMAGE_DESCR_FWD.createImage());
        l.setLayoutData((Object)new GridData(16384, 1024, false, false));
        this.m_gui.addTextReadOnlyNoBorder(comp, null, "User Filters", 1, 1, 0, 10, BMUI.font_arial8_bold);
        Composite tableComp = new Composite(comp, 0);
        tableComp.setLayout((Layout)gl);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Table userFilter_tbl = new Table(tableComp, 0x10010B00);
        userFilter_tbl.setData(TABLE_TYPE, (Object)"USER_FILTER_TABLE");
        userFilter_tbl.setHeaderVisible(true);
        userFilter_tbl.setLinesVisible(true);
        gl = new GridLayout(1, false);
        gl.verticalSpacing = 0;
        gl.horizontalSpacing = 0;
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        userFilter_tbl.setLayout((Layout)gl);
        userFilter_tbl.setLayoutData((Object)new GridData(4, 4, true, true));
        userFilter_tbl.addSelectionListener((SelectionListener)this);
        this.m_userFilter_tv = new TableViewer(userFilter_tbl);
        this.m_userFilterTableProvider = new ServerFilterTableProvider(this.m_userFilter_tv, ServerFilterTableProvider.USER_POLICIES);
        TableViewerColumn tv_col0 = new TableViewerColumn(this.m_userFilter_tv, 0);
        tv_col0.setLabelProvider(this.m_userFilterTableProvider.labelProvider);
        TableColumn col0 = tv_col0.getColumn();
        col0.setText(ServerFilterTableProvider.COL_STATUS);
        col0.setWidth(25);
        col0.addListener(13, this.sortListenerUserFilterTable);
        TableViewerColumn tv_col1 = new TableViewerColumn(this.m_userFilter_tv, 0);
        tv_col1.setLabelProvider(this.m_userFilterTableProvider.labelProvider);
        TableColumn col1 = tv_col1.getColumn();
        col1.setText(ServerFilterTableProvider.COL_NAME);
        col1.setWidth(200);
        col1.addListener(13, this.sortListenerUserFilterTable);
        TableViewerColumn tv_col2 = new TableViewerColumn(this.m_userFilter_tv, 16384);
        tv_col2.setLabelProvider(this.m_userFilterTableProvider.labelProvider);
        TableColumn col2 = tv_col2.getColumn();
        col2.setText(ServerFilterTableProvider.COL_DESC);
        col2.setWidth(250);
        col2.addListener(13, this.sortListenerUserFilterTable);
        TableViewerColumn tv_col3 = new TableViewerColumn(this.m_userFilter_tv, 16384);
        tv_col3.setLabelProvider(this.m_userFilterTableProvider.labelProvider);
        TableColumn col3 = tv_col3.getColumn();
        col3.setText(ServerFilterTableProvider.COL_ATTR_FILTERS);
        col3.setWidth(200);
        col3.addListener(13, this.sortListenerUserFilterTable);
        TableColumnLayout tableLayout = new TableColumnLayout();
        tableComp.setLayout((Layout)tableLayout);
        tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
        tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
        tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
        tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(100, col3.getWidth()));
        this.m_userFilter_tv.setContentProvider((IContentProvider)this.m_userFilterTableProvider);
        this.m_userFilter_tv.setInput((Object)this.m_userFilterTableProvider.getElements(null));
        this.m_userFilter_tv.addDoubleClickListener((IDoubleClickListener)this);
        this.m_userFilter_tv.refresh(true);
        userFilter_tbl.setSortColumn(col1);
        userFilter_tbl.setSortDirection(128);
        this.m_userFilter_tv.setSorter((ViewerSorter)this.m_userFilterTableProvider);
        this.m_userFilter_tv.setComparer((IElementComparer)this.m_userFilterTableProvider);
        UserRoleTableFilter filter = new UserRoleTableFilter(this.m_selectedRole.getName());
        ViewerFilter[] filters = new ViewerFilter[]{filter};
        this.m_userFilter_tv.resetFilters();
        this.m_userFilter_tv.setFilters(filters);
        FancyToolTipSupport.enableFor((ColumnViewer)this.m_userFilter_tv, 2);
        userFilter_tbl.setToolTipText("");
        this.createContentMenu_UserFilterTable(this.m_userFilter_tv);
    }

    public void createContentMenu_UserFilterTable(final TableViewer tableViewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                StructuredSelection ssel = (StructuredSelection)tableViewer.getSelection();
                manager.add((IAction)new ReloadUserFilterTableAction());
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new AddFilterAction(m_instance, UserRoleTab.this.m_selectedRole.getName()));
                manager.add((IAction)new RemoveFilterAction(m_instance, ssel));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new OpenFilterAction(ssel));
                manager.add((IAction)new NewFilterAction(m_instance, UserRoleTab.this.m_selectedRole.getName()));
            }
        });
    }

    public void addListenersToTable(Table table) {
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        TableItem item = (TableItem)event.item;
                        String text = this.getText(item, event.index);
                        if (text == null) break;
                        Point size = event.gc.textExtent(text);
                        event.width = size.x + 4;
                        event.height = Math.max(event.height, size.y + 4);
                        break;
                    }
                    case 42: {
                        String text;
                        int hIndent = 0;
                        TableItem item = (TableItem)event.item;
                        Image image = item.getImage(event.index);
                        if (image != null) {
                            Rectangle rect = image.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(image, event.x + 4 + event.width / 2, event.y + 2 + offset);
                            hIndent = rect.width + 4;
                        }
                        if ((text = this.getText(item, event.index)) == null) break;
                        Point size = event.gc.textExtent(text);
                        int offset2 = Math.max(0, (event.height - size.y) / 2);
                        event.gc.drawText(text, event.x + 4 + hIndent, event.y + 2 + offset2, true);
                        break;
                    }
                    case 40: {
                        event.detail &= 0xFFFFFFEF;
                    }
                }
            }

            String getText(TableItem item, int column) {
                String text = item.getText(column);
                if (text == null || text.length() == 0) {
                    return null;
                }
                return text;
            }
        };
        Listener toolTipListener = new Listener(){
            Shell tooltip_shell = null;
            Label label = null;

            public void handleEvent(Event event) {
                int columnIndex = UserRoleTab.this.getColumnIndex(UserRoleTab.this.m_generalTable, event.x);
                switch (event.type) {
                    case 1: 
                    case 12: {
                        if (this.tooltip_shell == null) break;
                        this.tooltip_shell.dispose();
                        this.tooltip_shell = null;
                        this.label = null;
                        break;
                    }
                    case 5: {
                        if (this.tooltip_shell == null) break;
                        this.tooltip_shell.dispose();
                        this.tooltip_shell = null;
                        this.label = null;
                        break;
                    }
                    case 32: {
                        if (!(event.widget instanceof Table)) break;
                        Table table = (Table)event.widget;
                        TableItem item = table.getItem(new Point(5, event.y));
                        if (item == null || !(item.getData() instanceof TableItemObject)) {
                            return;
                        }
                        TableItemObject tableItem = (TableItemObject)item.getData();
                        String tooltip = "";
                        try {
                            TableContentProvider contentProvider = (TableContentProvider)table.getData(CONTENT_PROVIDER);
                            String text = contentProvider.getColumnText(tableItem, columnIndex);
                            tooltip = contentProvider.getMultilineText(text, 30);
                        }
                        catch (Exception exception) {
                            tooltip = "";
                        }
                        if (tooltip.length() == 0 || tooltip.equals("")) {
                            return;
                        }
                        if (this.tooltip_shell != null && !this.tooltip_shell.isDisposed()) {
                            this.tooltip_shell.dispose();
                        }
                        Shell shell = UserRoleTab.this.m_folder.getShell();
                        this.tooltip_shell = new Shell(shell, 16388);
                        FillLayout fl = new FillLayout();
                        fl.marginWidth = 5;
                        fl.marginHeight = 3;
                        this.tooltip_shell.setLayout((Layout)fl);
                        this.tooltip_shell.setBackground(shell.getDisplay().getSystemColor(29));
                        this.label = new Label((Composite)this.tooltip_shell, 0);
                        this.label.setForeground(shell.getDisplay().getSystemColor(28));
                        this.label.setBackground(shell.getDisplay().getSystemColor(29));
                        this.label.setText(tooltip);
                        Point size = this.tooltip_shell.computeSize(-1, -1);
                        Rectangle rect = item.getBounds(0);
                        Point pt = table.toDisplay(rect.x, rect.y);
                        this.tooltip_shell.setBounds(pt.x + event.x + 10, pt.y + 10, size.x, size.y);
                        this.tooltip_shell.setVisible(true);
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        table.addListener(40, paintListener);
        table.addListener(1, toolTipListener);
        table.addListener(5, toolTipListener);
        table.addListener(32, toolTipListener);
        table.addListener(3, paintListener);
    }

    public void setUserRole(UserRole role) {
        this.m_selectedRole = role;
    }

    public UserRole getUserRole() {
        return this.m_selectedRole;
    }

    public void updateActionTable(TableItemObject ti) {
        if (ti.isDisabled()) {
            this.setGlobalActionRights(1);
            if (this.isActionTableActive()) {
                this.activateActionTable(false);
            }
        } else if (ti.isOwner()) {
            this.setGlobalActionRights(3);
            if (!this.isActionTableActive()) {
                this.activateActionTable(true);
            }
        } else if (ti.isGuest()) {
            this.setGlobalActionRights(2);
            if (!this.isActionTableActive()) {
                this.activateActionTable(true);
            }
        }
    }

    public int getGlobalActionRights() {
        return this.m_globalActRights;
    }

    public void setGlobalActionRights(int right) {
        this.m_globalActRights = right;
    }

    public void activateActionTable(boolean activate) {
        this.m_actGrpTable.setEnabled(activate);
        if (activate) {
            this.m_actionGrpTitle.setText("Action Rights");
        } else {
            this.m_actionGrpTitle.setText("Action Rights - DISABLED!");
        }
    }

    public boolean isActionTableActive() {
        return this.m_actGrpTable.isEnabled();
    }

    public void refreshTab() {
        this.setCTabTitle(this.m_selectedRole.getName());
        if (!this.m_isDirty) {
            this.m_general_contentProvider = new TableContentProvider(m_instance, this.getUserRole(), GENERAL_TABLE);
            this.general_tableViewer.setContentProvider((IContentProvider)this.m_general_contentProvider);
            this.general_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_general_contentProvider);
            this.general_tableViewer.setInput((Object)this.m_general_contentProvider.getElements(null));
            this.general_tableViewer.refresh();
            this.m_actGrp_contentProvider = new TableContentProvider(m_instance, this.getUserRole(), ACTION_TABLE);
            this.m_actGrp_tableViewer.setContentProvider((IContentProvider)this.m_actGrp_contentProvider);
            this.m_actGrp_tableViewer.setLabelProvider((IBaseLabelProvider)this.m_actGrp_contentProvider);
            this.m_actGrp_tableViewer.setInput((Object)this.m_actGrp_contentProvider.getElements(null));
            this.m_actGrp_tableViewer.refresh();
        } else {
            this.general_tableViewer.refresh();
            this.m_actGrp_tableViewer.refresh();
        }
        if (this.getGlobalActionRights() == 1) {
            if (this.isActionTableActive()) {
                this.activateActionTable(false);
            }
        } else if (!this.isActionTableActive()) {
            this.activateActionTable(true);
        }
        try {
            if (this.pgviewer != null && !this.m_pgDirty) {
                this.m_powerGroups = Repository.getInstance().getUserManager().getPowerGroups(this.getUserRole().getID());
                GroupTreeObject oldRoot = (GroupTreeObject)this.pgviewer.getInput();
                for (GroupTreeObject el : oldRoot.getAllElements()) {
                    GroupTreeObjectUnsubmitted gl;
                    if (!(el instanceof GroupTreeObjectUnsubmitted) || this.m_powerGroups.searchPath((gl = (GroupTreeObjectUnsubmitted)el).getPath(), gl.getType()) != null) continue;
                    GroupTreeObject parent = GroupTreeObject.createPath(gl.getParentPath(), this.m_powerGroups);
                    parent.addElement(gl);
                }
                this.pgviewer.setInput(this.m_powerGroups);
                this.pgviewer.expandToLevel(2);
            }
        }
        catch (Throwable throwable) {}
        this.RefreshUserFilterTable();
        this.rememberOriginalUserFilters();
    }

    public void RefreshUserFilterTable() {
        this.m_userFilterTableProvider.loadFwdPolicies();
        this.m_userFilter_tv.setInput((Object)this.m_userFilterTableProvider.getElements(null));
        this.m_userFilter_tv.refresh(true);
        UserRoleTableFilter filter = new UserRoleTableFilter(this.m_selectedRole.getName());
        ViewerFilter[] filters = new ViewerFilter[]{filter};
        this.m_userFilter_tv.resetFilters();
        this.m_userFilter_tv.setFilters(filters);
    }

    private void rememberOriginalUserFilters() {
        TableItem[] userFilters = this.m_userFilter_tv.getTable().getItems();
        this.m_userFilters_orig.clear();
        int i = 0;
        while (i < userFilters.length) {
            TableItem ti = userFilters[i];
            Object obj = ti.getData();
            if (obj != null && obj instanceof ForwardPolicy) {
                this.m_userFilters_orig.put((ForwardPolicy)obj, null);
            }
            ++i;
        }
    }

    public void resetUserFilters() {
        TableItem[] tblItems = this.m_userFilter_tv.getTable().getItems();
        HashMap userFilter_current = new HashMap();
        int i = 0;
        while (i < tblItems.length) {
            TableItem ti = tblItems[i];
            Object obj = ti.getData();
            if (obj != null && obj instanceof ForwardPolicy) {
                userFilter_current.put((ForwardPolicy)obj, null);
            }
            ++i;
        }
        for (ForwardPolicy fp : userFilter_current.keySet()) {
            if (this.m_userFilters_orig.containsKey(fp)) continue;
            try {
                fp = FPolicyManager.getInstance().getFPolicyByName(fp.getPolicyName());
                ForwardCondition fc = fp.getConditions().getConditionList().get(0);
                List<String> users = fc.getUsersAssociated();
                Iterator<String> it2 = users.iterator();
                while (it2.hasNext()) {
                    String ur = it2.next();
                    ur = Repository.getInstance().getUserManager().getCorrectRoleName(ur);
                    if (!ur.equals(this.m_selectedRole.getName())) continue;
                    it2.remove();
                }
                fc.to = fc.m_users.isEmpty() ? UserManager.DUMMY_USERROLE : ServerFilterView.getSimplifiedUserString(fc.m_users.toString());
                FPolicyManager.getInstance().saveForwardPolicy(fp, fp.getPolicyName(), false);
            }
            catch (Exception exception) {}
        }
        for (ForwardPolicy fp : this.m_userFilters_orig.keySet()) {
            if (userFilter_current.containsKey(fp)) continue;
            try {
                FPolicyManager fPolManager = FPolicyManager.getInstance();
                fp = fPolManager.getFPolicyByName(fp.getPolicyName());
                ForwardCondition fc = fp.getConditions().getConditionList().get(0);
                List<String> users = fc.getUsersAssociated();
                boolean doesExist = false;
                for (String roleName : users) {
                    String tmp = Repository.getInstance().getUserManager().getCorrectRoleName(roleName);
                    if (tmp == null || tmp.length() <= 0 || !tmp.equals(this.m_selectedRole.getName())) continue;
                    doesExist = true;
                    break;
                }
                if (doesExist) continue;
                fc.m_users.add("[" + this.m_selectedRole.getName() + "]");
                fc.to = ServerFilterView.getSimplifiedUserString(fc.m_users.toString());
                FPolicyManager.getInstance().saveForwardPolicy(fp, fp.getPolicyName(), false);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void setTreeDirty() {
        this.setDirty(this.m_isDirty, true);
    }

    public void setDirty(boolean b) {
        this.setDirty(b, this.m_pgDirty);
    }

    public void setDirty(boolean b, boolean pg) {
        if (this.m_readOnly) {
            return;
        }
        this.m_isDirty = b;
        this.m_pgDirty = pg;
        this.m_save_btn.setEnabled(this.isDirty());
        this.m_undo_btn.setEnabled(this.isDirty());
        if (b || pg) {
            this.setText("User Role:  * " + this.getData(ROLE_NAME));
        } else if (!b && !pg) {
            this.setText("User Role:  " + this.getData(ROLE_NAME));
        }
    }

    public boolean isDirty() {
        return this.m_isDirty || this.m_pgDirty;
    }

    public int getColumnIndex(Table t, int position) {
        int colIndex = -1;
        int start = 0;
        int end = 0;
        LinkedHashMap<Integer, Integer> m = new LinkedHashMap<Integer, Integer>();
        TableColumn[] colList = t.getColumns();
        int index = 0;
        while (index < t.getColumnCount()) {
            m.put(index, colList[index].getWidth());
            ++index;
        }
        index = 0;
        while (index < m.size()) {
            if (index > 0) {
                start += Integer.valueOf(((Integer)m.get(index - 1)).toString()).intValue();
            }
            end = start + Integer.valueOf(((Integer)m.get(index)).toString());
            if (position >= start && position <= end) {
                colIndex = index;
                break;
            }
            ++index;
        }
        return colIndex;
    }

    public void setCTabTitle(String userRoleName) {
        StringBuffer sb = new StringBuffer();
        sb.append("User Role:  ").append(userRoleName);
        if (userRoleName.equals(UserManager.ADMINISTRATOR)) {
            sb.append("  (Read Only!)");
        }
        this.setText(sb.toString());
    }

    public void save() throws Exception {
        block10: {
            boolean isPowerGroups = this.m_pgDirty;
            boolean isUserRole = this.m_isDirty;
            this.setDirty(false, false);
            try {
                if (isUserRole) {
                    List<UserRight> generalRights = this.m_general_contentProvider.getRights();
                    List<UserRight> actionRights = this.m_actGrp_contentProvider.getRights();
                    ArrayList<UserRight> allRights = new ArrayList<UserRight>();
                    allRights.addAll(generalRights);
                    allRights.addAll(actionRights);
                    this.m_selectedRole.addRights(allRights);
                    boolean isSuccess = Repository.getInstance().getUserManager().saveRole(this.getUserRole());
                    if (!isSuccess) {
                        throw new Exception("Error saving User role!");
                    }
                    isUserRole = false;
                }
                if (!isPowerGroups) break block10;
                List<String> allIDsBefore = Repository.getInstance().getUserManager().getPowerGroupIDs(this.getUserRole().getID());
                if (allIDsBefore == null) {
                    allIDsBefore = new ArrayList<String>(0);
                }
                List<GroupTreeObject> pgroups = this.m_powerGroups.getElements();
                ArrayList<PowerGroup> toSave = new ArrayList<PowerGroup>(pgroups.size());
                for (GroupTreeObject pggto : pgroups) {
                    PowerGroup pg = (PowerGroup)pggto.getTreeObject().getObject();
                    PowerGroup newPG = new PowerGroup(pg.m_name, pg.m_description);
                    newPG.m_ID = pg.m_ID;
                    List<GroupTreeObject> items = pggto.getElements();
                    for (GroupTreeObject item : items) {
                        newPG.add((PGItem)item.getTreeObject().getObject());
                    }
                    toSave.add(newPG);
                    allIDsBefore.remove(pg.m_ID);
                }
                ServerClient sc = null;
                if (toSave.size() > 0) {
                    sc = Repository.getInstance().getUserManager().savePowerGroup(this.getUserRole().getID(), toSave, true);
                }
                if (sc == null || sc.isSuccess()) {
                    ScDeletePowerGroup scd;
                    if (allIDsBefore.size() > 0 && !(scd = Repository.getInstance().getUserManager().deletePowerGroups(this.getUserRole().getID(), allIDsBefore, true)).isSuccess()) {
                        throw new Exception(scd.getLastException() != null ? scd.getLastException().getMessage() : "Error deleting privileged groups!");
                    }
                    break block10;
                }
                throw new Exception(sc.getLastException() != null ? sc.getLastException().getMessage() : "Error saving privileged groups!");
            }
            catch (Exception e) {
                this.setDirty(isUserRole, isPowerGroups);
                throw e;
            }
        }
    }

    public void clearPowerGroups() {
        try {
            this.m_powerGroups.clean();
        }
        catch (Throwable throwable) {}
    }

    public void undo(boolean doRefresh) {
        this.m_general_contentProvider.undo(this.general_tableViewer);
        if (this.isActionTableActive()) {
            this.m_actGrp_contentProvider.undo(this.m_actGrp_tableViewer);
        }
        if (this.pgviewer != null && !this.pgviewer.getTree().isDisposed()) {
            GroupTreeObject oldRoot = (GroupTreeObject)this.pgviewer.getInput();
            for (GroupTreeObject el : oldRoot.getAllElements()) {
                if (!(el instanceof GroupTreeObjectUnsubmitted)) continue;
                GroupTreeObjectUnsubmitted gl = (GroupTreeObjectUnsubmitted)el;
                gl.getParent().removeElement(gl);
            }
            this.pgviewer.refresh(true);
        }
        if (doRefresh) {
            this.resetUserFilters();
            RefreshUserRoleTabAction refreshAction = new RefreshUserRoleTabAction();
            refreshAction.run();
        }
        this.setDirty(false, false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof Button) {
            Button b = (Button)obj;
            String name = (String)b.getData();
            if (BUTTON_SAVE.equals(name)) {
                try {
                    this.save();
                    this.clearPowerGroups();
                }
                catch (Exception e1) {
                    MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error", (String)e1.getMessage());
                }
            } else if (BUTTON_UNDO.equals(name)) {
                this.undo(true);
            } else if (ADDITEM.equals(name)) {
                AddPGItem addAction = new AddPGItem(m_instance, this.pgviewer, this.m_hasOwnerRights_on_userManagement);
                addAction.run();
            } else if (DELETEITEM.equals(name)) {
                DeletePGItem delAction = new DeletePGItem(m_instance, this.pgviewer, this.m_hasOwnerRights_on_userManagement);
                delAction.run();
            } else if (EDITITEM.equals(name)) {
                EditPGItem editAction = new EditPGItem(this, this.pgviewer, this.m_hasOwnerRights_on_userManagement);
                editAction.run();
            } else if (ADDPG.equals(name)) {
                AddPGGroup addAction = new AddPGGroup(this.pgviewer, this.m_powerGroups, this.m_hasOwnerRights_on_userManagement);
                addAction.run();
            }
        }
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        Object o = e.getSource();
        if (o instanceof Table) {
            Table table = (Table)o;
            table.deselectAll();
        }
    }

    public void mouseUp(MouseEvent e) {
        if (e.button == 1 && Repository.getInstance().getRights(1004) == 3) {
            Table table = (Table)e.getSource();
            TableItem item = table.getItem(new Point(5, e.y));
            if (item == null) {
                return;
            }
            int columnIndex = this.getColumnIndex(table, e.x);
            if (!this.getUserRole().getName().equals(UserManager.ADMINISTRATOR) && columnIndex > 0 && columnIndex < 4) {
                TableItemObject ti = (TableItemObject)item.getData();
                if (ti == null) {
                    return;
                }
                TableContentProvider contentProvider = (TableContentProvider)table.getData(CONTENT_PROVIDER);
                TableViewer tableViewer = (TableViewer)table.getData(TABLE_VIEWER);
                contentProvider.update(ti, columnIndex, tableViewer);
                this.setDirty(true, this.m_pgDirty);
                if (ti.getItemID().equals("1007")) {
                    UserRoleTab tab = (UserRoleTab)table.getData(TAB);
                    tab.updateActionTable(ti);
                }
            }
        }
    }

    public void dispose() {
        this.m_compInTab.dispose();
        super.dispose();
    }

    private void openPGItemDialog(STreeViewer tv, GroupTreeObject pgigto) throws Exception {
        Object old = pgigto.getTreeObject().getObject();
        if (old instanceof PGItem) {
            GroupTreeObject pgroupParent = pgigto.getParent();
            PGItemDialog pd = new PGItemDialog(this.pgviewer.getControl().getShell(), (PowerGroup)pgroupParent.getTreeObject().getObject(), (PGItem)old);
            pd.setBlockOnOpen(true);
            int res = pd.open();
            if (res == 0) {
                pd.getPowerGroup();
                PGItem pgitem = pd.getResultPGItem();
                pgroupParent.removeElement(pgigto);
                this.setDirty(this.m_isDirty, true);
                GroupTreeObjectUnsubmitted changed = new GroupTreeObjectUnsubmitted(new TreeObject(pgitem.toString(), BMUI.type_file, pgitem), null, "IMAGE_FILE_CUT");
                pgroupParent.addElement(changed);
                this.pgviewer.refresh();
                if (!tv.getExpandedState(pgroupParent)) {
                    tv.setExpandedState(pgroupParent, true);
                }
            } else if (pgigto instanceof GroupTreeObjectUnsubmitted) {
                pgigto.getParent().removeElement(pgigto);
            }
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        TableViewer tv;
        String type;
        Object o = event.getSource();
        if (o instanceof TableViewer && (type = (String)(tv = (TableViewer)o).getTable().getData(TABLE_TYPE)).equals("USER_FILTER_TABLE")) {
            StructuredSelection ssel = (StructuredSelection)tv.getSelection();
            OpenFilterAction openUserFilter = new OpenFilterAction(ssel);
            openUserFilter.run();
        }
    }

    public class AddFilterAction
    extends Action {
        private String m_currUserRole;
        private UserRoleTab m_userRoleTab;

        public AddFilterAction(UserRoleTab userRoleTab2, String currUserRole) {
            super("addUserFilter");
            this.m_currUserRole = null;
            this.m_userRoleTab = null;
            this.setId("adduserfilter");
            this.setText("Add Filter");
            this.m_currUserRole = currUserRole;
            this.m_userRoleTab = userRoleTab2;
            if (Repository.getInstance().getRights(1009) < 2 || Repository.getInstance().getRights(1004) < 3 || this.m_currUserRole == null || this.m_currUserRole.length() == 0 || this.m_userRoleTab == null) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            UserFilterDialog ufd = new UserFilterDialog(m_instance.getParent().getShell(), this.m_currUserRole);
            ufd.setBlockOnOpen(true);
            try {
                ufd.open();
                if (ufd.getReturnCode() == 0) {
                    String fPolName = ufd.getSelectedUserFilter();
                    FPolicyManager fPolManager = FPolicyManager.getInstance();
                    ForwardPolicy fp = fPolManager.getFPolicyByName(fPolName);
                    ForwardCondition fc = fp.getConditions().getConditionList().get(0);
                    List<String> users = fc.getUsersAssociated();
                    for (String roleName : users) {
                        String tmp = Repository.getInstance().getUserManager().getCorrectRoleName(roleName);
                        if (tmp == null || tmp.length() <= 0 || !tmp.equals(UserRoleTab.this.m_selectedRole.getName())) continue;
                        return;
                    }
                    fc.m_users.add("[" + UserRoleTab.this.m_selectedRole.getName() + "]");
                    fc.to = ServerFilterView.getSimplifiedUserString(fc.m_users.toString());
                    boolean success = FPolicyManager.getInstance().saveForwardPolicy(fp, fp.getPolicyName(), false);
                    if (success) {
                        UserRoleTab.this.RefreshUserFilterTable();
                    }
                } else {
                    ufd.getReturnCode();
                }
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    private class AddPGGroup
    extends Action {
        private STreeViewer m_tv;
        private GroupTreeObject m_pgGroup;

        public AddPGGroup(STreeViewer treeViewer, GroupTreeObject powerGroups, boolean hasOwnerRights) {
            super("AddGroup");
            this.m_tv = null;
            this.m_pgGroup = null;
            this.setText("Add Group");
            this.setId("addgroup");
            this.m_tv = treeViewer;
            this.m_pgGroup = powerGroups;
            if (!hasOwnerRights || this.m_pgGroup == null) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            String pgName;
            if (!this.isEnabled()) {
                return;
            }
            SinglelineInputDialog slid = new SinglelineInputDialog(UserRoleTab.this.getControl().getShell(), " Add Privileged Group ", " Privileged Group Name:", "", null);
            slid.setBlockOnOpen(true);
            int res = slid.open();
            if (res == 0 && (pgName = slid.getValue()) != null && pgName.length() > 0) {
                GroupTreeObject gto = this.m_pgGroup.findFirstGroup(pgName, BMUI.type_folder);
                if (gto != null) {
                    new ShowMessageBox("Add Group", "Privileged Group does allready exist!", 1);
                    return;
                }
                PowerGroup newPG = new PowerGroup(pgName, "");
                GroupTreeObject gto_new = new GroupTreeObject(new TreeObject(newPG.m_name, BMUI.type_folder, newPG));
                this.m_pgGroup.addElement(gto_new);
                this.m_tv.refresh();
                this.m_tv.setSelection((ISelection)new StructuredSelection((Object)gto_new));
                UserRoleTab.this.setDirty(UserRoleTab.this.m_isDirty, true);
            }
        }
    }

    private class AddPGItem
    extends Action {
        private UserRoleTab m_tab;
        private GroupTreeObject m_pgGroup;
        private STreeViewer m_tv;

        public AddPGItem(UserRoleTab userRoleTab2, STreeViewer treeViewer, boolean hasOwnerRights) {
            super("AddItem");
            this.m_tab = null;
            this.m_pgGroup = null;
            this.m_tv = null;
            this.setText("Add Item");
            this.setId("additem");
            this.m_tab = userRoleTab2;
            this.m_tv = treeViewer;
            if (!hasOwnerRights || this.m_tv == null || this.m_tab == null || this.m_tv.getSelection().isEmpty() || ((StructuredSelection)this.m_tv.getSelection()).size() > 1) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection ssel = (StructuredSelection)this.m_tv.getSelection();
            this.m_pgGroup = (GroupTreeObject)ssel.getFirstElement();
            if (this.m_pgGroup == null) {
                this.setEnabled(false);
                return;
            }
            if (this.m_pgGroup instanceof GroupTreeObjectLast) {
                this.m_pgGroup = this.m_pgGroup.getParent();
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            try {
                PGItem item = new PGItem(PGEntityPermissionFlag.RESTRICT, PGEntityAction.MODIFY, ObjectType.pol, "");
                GroupTreeObjectUnsubmitted newItem = new GroupTreeObjectUnsubmitted(new TreeObject(item.toString(), BMUI.type_file, item), null, null);
                this.m_pgGroup.addElement(newItem);
                this.m_tv.refresh();
                try {
                    this.m_tab.openPGItemDialog(this.m_tv, newItem);
                }
                catch (Throwable throwable) {}
                if (newItem.getParent() != null) {
                    newItem.getParent().removeElement(newItem);
                }
                this.m_tv.refresh();
                this.m_tab.setDirty(UserRoleTab.this.m_isDirty, true);
            }
            catch (Exception exception) {}
        }
    }

    private class DeletePGItem
    extends Action {
        private UserRoleTab m_tab;
        private STreeViewer m_tv;

        public DeletePGItem(UserRoleTab userRoleTab2, STreeViewer treeViewer, boolean hasOwnerRights) {
            super("DeleteItem");
            this.m_tab = null;
            this.m_tv = null;
            this.setText("Delete Item");
            this.setId("deleteitem");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            this.m_tab = userRoleTab2;
            this.m_tv = treeViewer;
            if (!hasOwnerRights || this.m_tv == null || this.m_tv.getSelection().isEmpty() || this.m_tab == null) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            try {
                StructuredSelection ssel = (StructuredSelection)this.m_tv.getSelection();
                for (GroupTreeObject gto : ssel) {
                    gto.getParent().removeElement(gto);
                }
                this.m_tv.refresh();
                this.m_tab.setDirty(UserRoleTab.this.m_isDirty, true);
            }
            catch (Exception exception) {}
        }
    }

    private class EditPGItem
    extends Action {
        private UserRoleTab m_tab;
        private GroupTreeObject m_selItem;
        private STreeViewer m_tv;

        public EditPGItem(UserRoleTab userRoleTab2, STreeViewer treeViewer, boolean hasOwnerRights) {
            super("EditItem");
            this.m_tab = null;
            this.m_selItem = null;
            this.m_tv = null;
            this.setText("Edit Item");
            this.setId("edititem");
            this.m_tab = userRoleTab2;
            this.m_tv = treeViewer;
            if (!hasOwnerRights || this.m_tv == null || this.m_tab == null || this.m_tv.getSelection().isEmpty() || ((StructuredSelection)this.m_tv.getSelection()).size() > 1) {
                this.setEnabled(false);
                return;
            }
            StructuredSelection ssel = (StructuredSelection)this.m_tv.getSelection();
            this.m_selItem = (GroupTreeObject)ssel.getFirstElement();
            if (this.m_selItem == null || !(this.m_selItem instanceof GroupTreeObjectLast)) {
                this.setEnabled(false);
                return;
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            try {
                this.m_tab.openPGItemDialog(this.m_tv, this.m_selItem);
                this.m_tab.setDirty(UserRoleTab.this.m_isDirty, true);
            }
            catch (Exception exception) {}
        }
    }

    public class NewFilterAction
    extends Action {
        private UserRoleTab m_userRoleTab;
        private String m_userRoleName;

        public NewFilterAction(UserRoleTab userRoleTab2, String userRoleName) {
            super("newUserFilter");
            this.m_userRoleTab = null;
            this.m_userRoleName = null;
            this.setId("newuserfilter");
            this.setText("New Filter");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_FWD);
            if (Repository.getInstance().getRights(1009) < 2 || Repository.getInstance().getRights(1004) < 3 || userRoleTab2 == null || userRoleName == null) {
                this.setEnabled(false);
                return;
            }
            this.m_userRoleTab = userRoleTab2;
            this.m_userRoleName = userRoleName;
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            try {
                ShowViewAction activateView = new ShowViewAction(1009, 1, "com.blixx.boom.gui.views.serverfilterview", "Server Filters View", BMUI.IMAGE_DESCR_FWD);
                activateView.run();
                ServerFilterUsersTab userTab = ServerFilterView.getInstance().getUserFilterTab();
                ServerFilterView.getInstance().getFolder().setSelection((CTabItem)userTab);
                userTab.newFPolicy(this.m_userRoleName);
            }
            catch (Throwable throwable) {}
        }
    }

    public class OpenFilterAction
    extends Action {
        private ForwardPolicy m_fp;

        public OpenFilterAction(StructuredSelection ssel) {
            Object o;
            super("openUserFilter");
            this.m_fp = null;
            this.setId("openuserfilter");
            this.setText("Open Filter");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_FWD);
            if (Repository.getInstance().getRights(1004) < 3 || Repository.getInstance().getRights(1009) < 2 || ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            if (!ssel.isEmpty() && (o = ssel.getFirstElement()) instanceof ForwardPolicy) {
                this.m_fp = (ForwardPolicy)o;
            }
            if (this.m_fp == null) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            ArrayList<ForwardPolicy> selItems = new ArrayList<ForwardPolicy>();
            selItems.add(this.m_fp);
            try {
                ShowViewAction activateView = new ShowViewAction(1009, 1, "com.blixx.boom.gui.views.serverfilterview", "Server Filters View", BMUI.IMAGE_DESCR_FWD);
                activateView.run();
                ServerFilterOverviewTab.OpenServerFilterAction action = new ServerFilterOverviewTab.OpenServerFilterAction(selItems);
                action.run();
            }
            catch (Throwable throwable) {}
        }
    }

    public class ReloadUserFilterTableAction
    extends Action {
        public ReloadUserFilterTableAction() {
            super("refreshfiltertable");
            this.setId("refreshfiltertable");
            this.setText("Refresh");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_REFRESH);
        }

        public void run() {
            UserRoleTab.this.RefreshUserFilterTable();
        }
    }

    public class RemoveFilterAction
    extends Action {
        private UserRoleTab m_userRoleTab;
        private ForwardPolicy m_fp;

        public RemoveFilterAction(UserRoleTab userRoleTab2, StructuredSelection ssel) {
            super("removeUserFilter");
            this.m_userRoleTab = null;
            this.m_fp = null;
            this.setId("removeuserfilter");
            this.setText("Remove Filter");
            ISharedImages sharedImages = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getWorkbench().getSharedImages();
            this.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
            this.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
            this.m_userRoleTab = userRoleTab2;
            if (Repository.getInstance().getRights(1009) < 2 || Repository.getInstance().getRights(1004) < 3 || this.m_userRoleTab == null || ssel == null || ssel.isEmpty()) {
                this.setEnabled(false);
                return;
            }
            this.m_fp = (ForwardPolicy)ssel.getFirstElement();
            if (this.m_fp == null) {
                this.setEnabled(false);
            }
        }

        public void run() {
            if (!this.isEnabled()) {
                return;
            }
            try {
                ForwardPolicy fp = FPolicyManager.getInstance().getFPolicyByName(this.m_fp.getPolicyName());
                ForwardCondition fc = fp.getConditions().getConditionList().get(0);
                List<String> users = fc.getUsersAssociated();
                Iterator<String> it = users.iterator();
                while (it.hasNext()) {
                    String ur = it.next();
                    ur = Repository.getInstance().getUserManager().getCorrectRoleName(ur);
                    if (!ur.equals(UserRoleTab.this.m_selectedRole.getName())) continue;
                    it.remove();
                }
                fc.to = fc.m_users.isEmpty() ? UserManager.DUMMY_USERROLE : ServerFilterView.getSimplifiedUserString(fc.m_users.toString());
                boolean success = FPolicyManager.getInstance().saveForwardPolicy(fp, fp.getPolicyName(), false);
                if (success) {
                    UserRoleTab.this.RefreshUserFilterTable();
                }
            }
            catch (Throwable throwable) {}
        }
    }

    private class TableFilter
    extends ViewerFilter {
        private String m_userRole = null;

        public TableFilter(String userRole) {
            this.m_userRole = Repository.getInstance().getUserManager().getCorrectRoleName(userRole);
        }

        public boolean select(Viewer arg0, Object arg1, Object arg2) {
            if (arg2 == null) {
                return false;
            }
            boolean isVisible = true;
            if (this.m_userRole != null && this.m_userRole.length() > 0) {
                ForwardPolicy fp = (ForwardPolicy)arg2;
                List<String> userRoles = fp.getAllUsers();
                int i = 0;
                while (i < userRoles.size()) {
                    String ur = userRoles.get(i).trim();
                    ur = Repository.getInstance().getUserManager().getCorrectRoleName(ur);
                    if (ur != null && ur.equals(this.m_userRole)) {
                        isVisible = false;
                        break;
                    }
                    ++i;
                }
            }
            return isVisible;
        }
    }

    private class UserFilterDialog
    extends Dialog {
        private Table m_table;
        private TableViewer m_tv;
        private String m_selection;
        private String m_userRole;

        public UserFilterDialog(Shell parentShell, String userRole) {
            super(parentShell);
            this.m_table = null;
            this.m_tv = null;
            this.m_selection = null;
            this.m_userRole = null;
            super.setShellStyle(66704);
            UserFilterDialog.setDefaultImage((Image)BMUI.IMAGE_FWD);
            this.m_userRole = userRole;
        }

        protected Control createDialogArea(Composite parent) {
            super.getShell().setText("User Filter");
            GUIDisplayElements gui = new GUIDisplayElements();
            Composite mainComp = (Composite)super.createDialogArea(parent);
            GridLayout gl = new GridLayout(1, false);
            gl.marginTop = 7;
            gl.marginRight = 7;
            gl.marginLeft = 7;
            mainComp.setLayout((Layout)gl);
            GridData gd = new GridData(4, 4, true, true);
            gd.widthHint = 700;
            gd.heightHint = 350;
            mainComp.setLayoutData((Object)gd);
            gui.addTextField(mainComp, null, "Select User Filter: ", 2, 1, 1, 1, null);
            try {
                this.createTable(mainComp);
            }
            catch (Exception exception) {}
            return mainComp;
        }

        public void createTable(Composite parent) {
            Composite table_comp = new Composite(parent, 2048);
            GridLayout gl = new GridLayout(1, false);
            gl.verticalSpacing = 0;
            gl.horizontalSpacing = 0;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            table_comp.setLayout((Layout)gl);
            table_comp.setLayoutData((Object)new GridData(4, 4, true, true));
            this.m_table = new Table(table_comp, 268503812);
            this.m_table.setData((Object)"USER_FILTER_TABLE");
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            this.m_table.setLayout((Layout)gl);
            this.m_table.setLayoutData((Object)new GridData(4, 4, true, true));
            this.m_table.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    StructuredSelection sel = (StructuredSelection)UserFilterDialog.this.m_tv.getSelection();
                    if (!sel.isEmpty()) {
                        ForwardPolicy fp = (ForwardPolicy)sel.getFirstElement();
                        UserFilterDialog.this.m_selection = fp.getPolicyName();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.m_tv = new TableViewer(this.m_table);
            ServerFilterTableProvider tableProvider = new ServerFilterTableProvider(this.m_tv, ServerFilterTableProvider.USER_POLICIES);
            tableProvider.loadFwdPolicies();
            TableViewerColumn tv_col0 = new TableViewerColumn(this.m_tv, 0);
            tv_col0.setLabelProvider(tableProvider.labelProvider);
            TableColumn col0 = tv_col0.getColumn();
            col0.setText(ServerFilterTableProvider.COL_STATUS);
            col0.setWidth(25);
            TableViewerColumn tv_col1 = new TableViewerColumn(this.m_tv, 0);
            tv_col1.setLabelProvider(tableProvider.labelProvider);
            TableColumn col1 = tv_col1.getColumn();
            col1.setText(ServerFilterTableProvider.COL_NAME);
            col1.setWidth(200);
            TableViewerColumn tv_col2 = new TableViewerColumn(this.m_tv, 0);
            tv_col2.setLabelProvider(tableProvider.labelProvider);
            TableColumn col2 = tv_col2.getColumn();
            col2.setText(ServerFilterTableProvider.COL_DESC);
            col2.setWidth(220);
            TableViewerColumn tv_col3 = new TableViewerColumn(this.m_tv, 0);
            tv_col3.setLabelProvider(tableProvider.labelProvider);
            TableColumn col3 = tv_col3.getColumn();
            col3.setText(ServerFilterTableProvider.COL_ATTR_FILTERS);
            col3.setWidth(200);
            TableColumnLayout tableLayout = new TableColumnLayout();
            table_comp.setLayout((Layout)tableLayout);
            tableLayout.setColumnData((Widget)col0, (ColumnLayoutData)new ColumnWeightData(0, col0.getWidth()));
            tableLayout.setColumnData((Widget)col1, (ColumnLayoutData)new ColumnWeightData(0, col1.getWidth()));
            tableLayout.setColumnData((Widget)col2, (ColumnLayoutData)new ColumnWeightData(0, col2.getWidth()));
            tableLayout.setColumnData((Widget)col3, (ColumnLayoutData)new ColumnWeightData(100, col3.getWidth()));
            this.m_tv.setContentProvider((IContentProvider)tableProvider);
            this.m_tv.setInput((Object)tableProvider.getElements(null));
            this.m_tv.refresh(true);
            this.m_tv.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    StructuredSelection ssel = (StructuredSelection)UserFilterDialog.this.m_tv.getSelection();
                    if (!ssel.isEmpty()) {
                        ForwardPolicy fp = (ForwardPolicy)ssel.getFirstElement();
                        UserFilterDialog.this.m_selection = fp.getPolicyName();
                        UserFilterDialog.this.okPressed();
                    }
                }
            });
            TableFilter tblFilter = new TableFilter(this.m_userRole);
            ViewerFilter[] filters = new ViewerFilter[]{tblFilter};
            this.m_tv.setFilters(filters);
        }

        public String getSelectedUserFilter() {
            return this.m_selection;
        }

        protected void okPressed() {
            super.okPressed();
        }

        protected void cancelPressed() {
            super.cancelPressed();
        }

        public boolean close() {
            try {
                this.m_table.dispose();
            }
            catch (Throwable throwable) {}
            return super.close();
        }
    }
}

