/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.authentication;

import com.blixx.boom.authentication.UserManager;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.gui.utils.GUIDisplayElements;
import com.blixx.shared.Cryptor;
import com.blixx.shared.User;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserSelfEdit
extends StatusDialog
implements ModifyListener {
    public User m_user = null;
    private GUIDisplayElements m_guiElements = null;
    private boolean m_isDirty = false;
    public Composite m_dialogArea = null;
    private Group m_group_pwd = null;
    private Group m_group_user = null;
    public Text m_pwd_field = null;
    public Text m_lastName_field = null;
    private Text m_firstName = null;
    private Text m_email = null;
    private Text m_phone = null;
    private Text m_pager = null;
    public static String LOGIN = "LOGIN";
    public static String PASSWPORD = "PASSWPORD";
    public static String PASSWPORD_OLD = "PASSWPORD_OLD";
    public static String PASSWPORD_NEW = "PASSWPORD_NEW";
    public static String PASSWPORD_CONFIRM = "PASSWPORD_CONFIRM";
    public static String LASTNAME = "LASTNAME";
    public static String FIRSTNAME = "FIRSTNAME";
    public static String EMAIL = "EMAIL";
    public static String PHONE = "PHONE";
    public static String PAGER = "PAGER";
    public static String BUTTON_CHANGE_PWD = "BUTTON_CHANGE_PWD";

    public UserSelfEdit(Shell parentShell, User user) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
        this.setTitle("  User Preferences");
        this.m_user = user;
    }

    protected Control createDialogArea(Composite parent) {
        this.setImage(Repository.getInstance().getUserManager().getUserImage(this.m_user));
        this.m_guiElements = new GUIDisplayElements();
        this.m_guiElements.centerShell(parent.getShell(), Display.getCurrent());
        this.m_dialogArea = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 0;
        gl.marginTop = 10;
        gl.verticalSpacing = 10;
        gl.marginRight = 10;
        gl.marginLeft = 10;
        this.m_dialogArea.setLayout((Layout)gl);
        this.m_dialogArea.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.m_group_pwd = new Group(this.m_dialogArea, 32);
        this.m_group_pwd.setText("Password");
        this.m_group_pwd.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 128, true, false, 1, 1);
        this.m_group_pwd.setLayoutData((Object)gd);
        this.m_guiElements.addTextField((Composite)this.m_group_pwd, "Login: ", this.m_user.m_loginName, 2, 1, 0, 0, BMUI.font_arial8_bold);
        this.m_pwd_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_group_pwd, PASSWPORD, "Password:   ", this.m_user.m_pwd, 1, 1, 0, 3, 250, this);
        this.m_pwd_field.setTextLimit(255);
        this.m_pwd_field.setEchoChar('*');
        this.m_pwd_field.setEnabled(false);
        Button changePwd = this.createButton((Composite)this.m_group_pwd, 11, "Change Password", false);
        if ("LDAP".equals(this.m_user.m_pwd)) {
            changePwd.setEnabled(false);
        }
        this.m_group_user = new Group(this.m_dialogArea, 32);
        this.m_group_user.setText("User Preferences");
        this.m_group_user.setLayout((Layout)new GridLayout(3, false));
        gd = new GridData(4, 4, true, false, 1, 1);
        this.m_group_user.setLayoutData((Object)gd);
        this.m_lastName_field = this.m_guiElements.addInputFieldSingle((Composite)this.m_group_user, LASTNAME, "Last Name: ", this.m_user.m_lastName, 2, 1, 0, 3, 60, this);
        this.m_lastName_field.setTextLimit(255);
        if (this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMIN) || this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMINISTRATOR)) {
            this.m_lastName_field.setEnabled(false);
        }
        this.m_firstName = this.m_guiElements.addInputFieldSingle((Composite)this.m_group_user, FIRSTNAME, "First Name: ", this.m_user.m_firstName, 2, 1, 0, 3, 60, this);
        this.m_firstName.setTextLimit(255);
        if (this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMIN) || this.m_user.m_loginName.equalsIgnoreCase(UserManager.ADMINISTRATOR)) {
            this.m_firstName.setEnabled(false);
        }
        this.m_email = this.m_guiElements.addInputFieldSingle((Composite)this.m_group_user, EMAIL, "Email: ", this.m_user.m_email, 2, 1, 0, 3, 60, this);
        this.m_email.setTextLimit(255);
        this.m_phone = this.m_guiElements.addInputFieldSingle((Composite)this.m_group_user, PHONE, "Phone: ", this.m_user.m_phone, 2, 1, 0, 3, 60, this);
        this.m_phone.setTextLimit(255);
        this.m_pager = this.m_guiElements.addInputFieldSingle((Composite)this.m_group_user, PAGER, "Pager: ", this.m_user.m_pager, 2, 1, 0, 3, 60, this);
        this.m_pager.setTextLimit(255);
        return this.m_dialogArea;
    }

    public void changePWD() {
        ChangePwdDialog changePWDDialog = new ChangePwdDialog(Display.getCurrent().getActiveShell());
        changePWDDialog.setBlockOnOpen(true);
        changePWDDialog.open();
        if (changePWDDialog.getReturnCode() == 0) {
            this.getButton(0).setEnabled(true);
            this.m_pwd_field.setText(this.m_user.m_pwd);
        }
    }

    public void save() {
        if (this.m_lastName_field.getText().trim().length() == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Missing Last Name", (String)"Please fill in Last Name!");
            return;
        }
        this.m_user.m_lastName = this.m_lastName_field.getText().trim();
        this.m_user.m_firstName = this.m_firstName.getText().trim();
        this.m_user.m_email = this.m_email.getText().trim();
        this.m_user.m_phone = this.m_phone.getText().trim();
        this.m_user.m_pager = this.m_pager.getText().trim();
        if (Repository.getInstance().getUserManager().saveUserSync(this.m_user)) {
            this.setDirty(false);
            super.close();
            Repository.m_pass = this.m_user.m_pwd;
        }
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    public void setDirty(boolean b) {
        this.m_isDirty = b;
        this.getButton(0).setEnabled(b);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button b = this.createButton(parent, 0, "Save", true);
        b.setEnabled(false);
        this.createButton(parent, 1, "Cancel", false);
        this.getButton(1).setFocus();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1) {
            super.close();
        } else if (buttonId == 0) {
            this.save();
        } else if (buttonId == 11) {
            this.changePWD();
        }
    }

    public boolean close() {
        try {
            this.m_pwd_field.dispose();
            this.m_lastName_field.dispose();
            this.m_firstName.dispose();
            this.m_email.dispose();
            this.m_phone.dispose();
            this.m_pager.dispose();
            this.m_group_pwd.dispose();
            this.m_group_user.dispose();
            this.m_dialogArea.dispose();
        }
        catch (Throwable throwable) {}
        return super.close();
    }

    public void modifyText(ModifyEvent e) {
        if (e.getSource() instanceof Text) {
            this.getButton(0).setEnabled(true);
        }
    }

    public class ChangePwdDialog
    extends StatusDialog
    implements ModifyListener {
        private Composite m_comp1;
        private Composite m_comp2;
        private Text m_pwd_old_field;
        private Text m_pwd_new_field;
        private Text m_pwd_confirm_field;

        public ChangePwdDialog(Shell parentShell) {
            super(parentShell);
            this.m_comp1 = null;
            this.m_comp2 = null;
            this.m_pwd_old_field = null;
            this.m_pwd_new_field = null;
            this.m_pwd_confirm_field = null;
            this.setShellStyle(this.getShellStyle() | 0x10 | 0x80 | 0x400);
            this.setTitle("  Change Password");
            this.setImage(Repository.getInstance().getUserManager().getUserImage(UserSelfEdit.this.m_user));
        }

        protected Control createDialogArea(Composite parent) {
            UserSelfEdit.this.m_guiElements = new GUIDisplayElements();
            GridLayout gl = new GridLayout(2, false);
            gl.marginHeight = 0;
            gl.marginRight = 10;
            gl.marginLeft = 10;
            this.m_comp1 = new Composite(parent, 0);
            this.m_comp1.setLayout((Layout)gl);
            this.m_comp1.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            UserSelfEdit.this.m_guiElements.addTextField(this.m_comp1, null, UserSelfEdit.this.m_user.m_loginName, 2, 1, 10, 1, BMUI.font_arial8_bold);
            this.m_comp2 = new Composite(parent, 0);
            this.m_comp2.setLayout((Layout)gl);
            this.m_comp2.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.m_pwd_old_field = UserSelfEdit.this.m_guiElements.addInputFieldSingle(this.m_comp2, PASSWPORD_OLD, "Old Password: ", null, 1, 1, 0, 10, 150, this);
            this.m_pwd_old_field.setTextLimit(255);
            this.m_pwd_old_field.setEchoChar('*');
            this.m_pwd_new_field = UserSelfEdit.this.m_guiElements.addInputFieldSingle(this.m_comp2, PASSWPORD_NEW, "New Password: ", null, 1, 1, 0, 3, 150, this);
            this.m_pwd_new_field.setTextLimit(255);
            this.m_pwd_new_field.setEchoChar('*');
            this.m_pwd_confirm_field = UserSelfEdit.this.m_guiElements.addInputFieldSingle(this.m_comp2, PASSWPORD_CONFIRM, "Confirm New Password: ", null, 1, 1, 0, 3, 150, this);
            this.m_pwd_confirm_field.setTextLimit(255);
            this.m_pwd_confirm_field.setEchoChar('*');
            return parent;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, "Save", true);
            this.getButton(0).setEnabled(false);
            this.createButton(parent, 1, "Cancel", false);
            this.getButton(1).setFocus();
        }

        protected void buttonPressed(int buttonId) {
            if (buttonId == 1) {
                super.cancelPressed();
            } else if (buttonId == 0) {
                String oldPwd = this.m_pwd_old_field.getText();
                String newPwd = this.m_pwd_new_field.getText();
                String confirmPwd = this.m_pwd_confirm_field.getText();
                if (!oldPwd.equals(Cryptor.decrypt(UserSelfEdit.this.m_user.m_pwd))) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Change Password", (String)"Invalid old Password!");
                    this.m_pwd_old_field.setText("");
                    this.m_pwd_new_field.setText("");
                    this.m_pwd_confirm_field.setText("");
                    return;
                }
                if (newPwd.trim().length() == 0 || confirmPwd.trim().length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Change Password", (String)"Invalid new Password!");
                    this.m_pwd_old_field.setText("");
                    this.m_pwd_new_field.setText("");
                    this.m_pwd_confirm_field.setText("");
                    return;
                }
                if (!newPwd.equals(confirmPwd)) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Change Password", (String)"Passwords do not match!");
                    this.m_pwd_old_field.setText("");
                    this.m_pwd_new_field.setText("");
                    this.m_pwd_confirm_field.setText("");
                    return;
                }
                UserSelfEdit.this.m_user.m_pwd = Cryptor.encrypt2(newPwd);
                UserSelfEdit.this.setDirty(true);
                super.okPressed();
            }
        }

        public boolean close() {
            try {
                this.m_pwd_old_field.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.m_pwd_new_field.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.m_pwd_confirm_field.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.m_comp1.dispose();
            }
            catch (Throwable throwable) {}
            try {
                this.m_comp2.dispose();
            }
            catch (Throwable throwable) {}
            return super.close();
        }

        public void modifyText(ModifyEvent e) {
            this.getButton(0).setEnabled(true);
        }
    }
}

