/*
 * Decompiled with CFR 0.152.
 */
package com.blixx.boom.editors;

import com.blixx.boom.editors.PathEditorInput;
import com.blixx.boom.editors.SimpleEditor;
import com.blixx.boom.editors.xml.XMLEditor;
import com.blixx.boom.engine.BMUI;
import com.blixx.boom.engine.Repository;
import com.blixx.boom.engine.ServerClient;
import com.blixx.log.RTLogger;
import com.blixx.shared.utils.GroupTreeObjectLast;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;

public class OpenFileAction
extends Action
implements IPartListener {
    private IWorkbenchWindow m_window;
    private IEditorPart m_editor = null;
    private boolean m_deleteFile = false;
    public static HashMap<String, Boolean> m_openFileList = new HashMap();
    private List<GroupTreeObjectLast> m_elements = new ArrayList<GroupTreeObjectLast>();
    private boolean m_openUserFile = false;

    public OpenFileAction(IWorkbenchWindow window) {
        super("Open File ...");
        try {
            this.setId("com.blixx.boom.gui.openFile");
            this.setActionDefinitionId("com.blixx.boom.gui.openFile");
            this.setText("Open File ...");
            this.setImageDescriptor(BMUI.IMAGE_DESCR_OPEN_FILE);
            this.m_window = window;
            this.m_openUserFile = true;
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "" + e);
        }
    }

    public OpenFileAction(IWorkbenchWindow window, GroupTreeObjectLast gtol) {
        super("Open File");
        try {
            this.setId("com.blixx.boom.gui.openFile");
            this.setActionDefinitionId("com.blixx.boom.gui.openFile");
            this.m_window = window;
            if (Repository.getInstance().getRights(1006) < 3) {
                this.setText("Open File (read only)");
            } else {
                this.setText("Edit File");
            }
            if (gtol != null && gtol.getType().equals(BMUI.type_file)) {
                this.m_elements.add(gtol);
            } else {
                this.setEnabled(false);
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "" + e);
        }
    }

    public OpenFileAction(IWorkbenchWindow window, StructuredSelection ssel) {
        super("Open File");
        this.setText("Open File");
        this.setId("com.blixx.boom.gui.openFile");
        this.setActionDefinitionId("com.blixx.boom.gui.openFile");
        this.m_window = window;
        if (Repository.getInstance().getRights(1006) < 3) {
            this.setText("Open File (read only)");
        } else {
            this.setText("Edit File");
        }
        if (ssel != null && !ssel.isEmpty()) {
            for (Object o : ssel) {
                GroupTreeObjectLast gtol;
                if (!(o instanceof GroupTreeObjectLast) || !(gtol = (GroupTreeObjectLast)o).getType().equals(BMUI.type_file)) continue;
                this.m_elements.add(gtol);
            }
        }
        if (this.m_elements.size() == 0) {
            this.setEnabled(false);
        } else if (this.m_elements.size() > 1) {
            this.setText(String.valueOf(this.getText()) + "s");
        }
    }

    public void run() {
        try {
            if (this.m_openUserFile) {
                File file = this.queryFile();
                String path = file.getPath();
                path = path.replace("\\", "/");
                this.openFile(file, path);
            } else if (this.m_elements != null && this.m_elements.size() > 0) {
                int i = 0;
                while (i < this.m_elements.size()) {
                    GroupTreeObjectLast gtol = this.m_elements.get(i);
                    String path = gtol.getPath();
                    path = path.replace("/root/Packages", "");
                    String[] name_type_dir = new String[]{path, gtol.getTreeObject().getType(), Repository.getUserTmpDirectory()};
                    ServerClient sc = ServerClient.getFile(name_type_dir);
                    sc.runInUIThread(null);
                    if (sc.isSuccess()) {
                        File file = (File)sc.getResultObject();
                        String path2 = file.getCanonicalPath();
                        path2 = path2.replace("\\", "/");
                        this.openFile(file, path2);
                    }
                    ++i;
                }
            }
        }
        catch (RuntimeException e) {
            RTLogger.print(5, "" + e);
        }
        catch (IOException e) {
            RTLogger.print(5, "" + e);
        }
    }

    public void openFile(File file, String path) {
        if (file != null && path != null) {
            IEditorInput input = this.createEditorInput(file, path);
            String editorId = this.getEditorId(file);
            IWorkbenchPage page = this.m_window.getActivePage();
            page.getWorkbenchWindow().getPartService().addPartListener((IPartListener)this);
            try {
                this.m_editor = page.openEditor(input, editorId);
                page.activate((IWorkbenchPart)this.m_editor);
                if (!m_openFileList.containsKey(path)) {
                    m_openFileList.put(path, this.m_deleteFile);
                }
            }
            catch (PartInitException e) {
                RTLogger.print(4, "", e);
            }
        } else {
            RTLogger.print(3, "file==null || path==null. path=" + path);
        }
    }

    private File queryFile() {
        FileDialog dialog = new FileDialog(this.m_window.getShell(), 4096);
        dialog.setText("Open File");
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            return new File(path);
        }
        return null;
    }

    private String getEditorId(File file) {
        String id = null;
        if (this.getFileExtention(file).equalsIgnoreCase(BMUI.file_extension_xml)) {
            id = XMLEditor.getID();
            RTLogger.print(5, "Open file in XML Editor file: " + file.getPath());
        } else {
            id = SimpleEditor.getID();
            RTLogger.print(5, "Open file in Standard Editor file: " + file.getPath());
        }
        return id;
    }

    private IEditorInput createEditorInput(File file, String path) {
        Path location = new Path(path);
        PathEditorInput input = new PathEditorInput((IPath)location);
        return input;
    }

    private String getFileExtention(File file) {
        String[] results = file.getName().split("\\.");
        String s = "." + results[results.length - 1];
        return s;
    }

    public void partClosed(IWorkbenchPart part) {
        String path;
        if (part instanceof IEditorPart && m_openFileList.containsKey(path = part.getTitle())) {
            m_openFileList.remove(path);
            if (m_openFileList.size() == 0) {
                try {
                    this.m_window.getActivePage().setEditorAreaVisible(false);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }
}

